<?php

namespace HulkPlugins\ElementorPro\Forms\GSheetConnector\Services;

use ElementorPro\Modules\Forms\Submissions\Database\Query;
use Google\Service\Sheets\Request;
use HulkPlugins\ElementorPro\Forms\GSheetConnector\Traits\SingletonTrait;

class FormActionService {
	use SingletonTrait;

	private static FormActionService $instance;

	public static function getInstance(): FormActionService {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get form submission last entry
	 * @return array
	 */
	public function getSubmissionLastEntry(): array {
		$query = Query::get_instance();
		$submissions = $query->get_submissions(
			[
				'page'             => 1,
				'per_page'         => 1,
				'filters'          => [],
				'order'            => [
					'by'    => 'id',
					'order' => 'DESC',
				],
				'with_meta'        => false,
				'with_form_fields' => false,
			]
		);

		if ( ! empty( $submissions['data'][0] ) && is_array( $submissions['data'][0] ) ) {
			return (array) $submissions['data'][0];
		}
		return [];
	}

	public function getReferer( array $formMeta ) {
		return remove_query_arg(
			[ 'preview_id', 'preview_nonce', 'preview' ],
			$formMeta['page_url']['value']
		);
	}

	public function boldHeaderRequest( $sheetId ): array {
		return [
			new Request(
				[
					'repeatCell' => [
						'range'  => [
							'sheetId'          => $sheetId,
							'startRowIndex'    => 0, // Start at the first row
							'endRowIndex'      => 1,   // End at the second row (non-inclusive)
							'startColumnIndex' => 0, // Start at the first column
							'endColumnIndex'   => 100,  // Adjust to the number of columns in your header
						],
						'cell'   => [
							'userEnteredFormat' => [
								'textFormat' => [
									'bold' => true, // Set text to bold
								],
							],
						],
						'fields' => 'userEnteredFormat.textFormat', // Specify what fields to update
					],
				]
			),
		];
	}

	public function freezeHeaderRequest( $sheetId, int $frozenRowCount ): array {
		return [
			new Request(
				[
					'updateSheetProperties' => [
						'properties' => [
							'sheetId'        => $sheetId,
							'gridProperties' => [
								'frozenRowCount' => $frozenRowCount,
							],
						],
						'fields'     => 'gridProperties.frozenRowCount',
					],
				]
			),
		];
	}
}
