<?php

namespace HulkPlugins\ElementorPro\Forms\GSheetConnector\Services;

use HulkPlugins\ElementorPro\Forms\GSheetConnector\Models\SettingsModel;
use HulkPlugins\ElementorPro\Forms\GSheetConnector\Traits\SingletonTrait;

class SettingsService {
	use SingletonTrait;

	private static SettingsService $instance;
	private SettingsModel $model;

	/**
	 * Sets up the SettingsService.
	 *
	 * Sets up the SettingsModel instance.
	 *
	 * @return void
	 */
	private function __construct( SettingsModel $model ) {
		$this->model = $model;
	}

	public static function getInstance( SettingsModel $model ): SettingsService {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self( $model );
		}

		return self::$instance;
	}

	/**
	 * Gets all settings
	 */
	public function &getSettings(): array {
		return $this->model->getSettings();
	}

	/**
	 * Get hostname
	 * @return array|false|mixed|null
	 */
	public function getHostname() {
		$site_url = get_site_url();
		return wp_parse_url( $site_url, PHP_URL_HOST );
	}
}
