<?php

namespace HulkPlugins\ElementorPro\Forms\GSheetConnector\Traits;

use Exception;

trait SingletonTrait {

	// Hold the instances for each class.
	private static array $instances = [];

	// Prevent direct instantiation
	private function __construct() {}

	// Prevent instance cloning
	private function __clone() {}

	/**
	 * @throws Exception
	 */
	public function __wakeup() {
		throw new Exception( 'Cannot unserialize Singleton' );
	}

	// Static method to get the Singleton instance
	protected static function __getInstance() {
		$class = static::class;  // Get the name of the class using the trait
		if ( ! isset( self::$instances[ $class ] ) ) {
			self::$instances[ $class ] = new static();  // Create the instance
		}
		return self::$instances[ $class ];
	}
}
