<?php

namespace HulkPlugins\ElementorPro\Forms\GSheetConnector\Utils;

class Helper {

	/**
	 * Sanitize array
	 * @param array $data
	 *
	 * @return array
	 */
	public static function sanitize_array( array $data ): array {
		$sanitized_array = [];

		foreach ( $data as $key => $value ) {
			// Sanitize keys if necessary
			$sanitized_key = sanitize_key( $key );

			if ( is_array( $value ) ) {
				// Recursive sanitization for nested arrays
				$sanitized_array[ $sanitized_key ] = self::sanitize_array( $value );
			} else {
				// Apply appropriate sanitization for each value
				$sanitized_array[ $sanitized_key ] = sanitize_text_field( $value );
			}
		}

		return $sanitized_array;
	}
}
