import "./styles/index.scss";
import React, {useEffect} from "react";
import {__} from "@wordpress/i18n";
import {Icon} from "@wordpress/components";
import {commentAuthorAvatar, page} from "@wordpress/icons";
import ErrorBoundary from "../../components/ErrorBoundary";
import localizeSettings from "./types/localizeSettings";
import Notice from "./components/Notice";
import {HashRouter, Route, Routes} from "react-router-dom";
import Layout from "./Layout";
import Integration from "./pages/Integration";
import NoMatch from "./pages/NoMatch";

let logoUrl = `${localizeSettings.PLUGIN_DIR_URL}assets/images/logo-fresh.svg`;

if (localizeSettings.adminColor === 'modern') {
	logoUrl = `${localizeSettings.PLUGIN_DIR_URL}assets/images/logo-modern.svg`;
}

const App = ({element}: { element: HTMLElement }) => {

	useEffect(() => {
		if (element) {
			element.classList.add('init-active');
		}
	}, [element]);

	return (
		<ErrorBoundary>
			<div className="hulk-settings-wrap">
				<div className="hulk-settings-header">
					<div className="flex flex-wrap items-center w-full">
						<div className="p-2 flex-grow pl-0">
							<div className="hulk-brand">
								<figure className={'hulk-logo'}>
									<img
										src={logoUrl}
										alt="Hulk Plugins"
										width={32}
									/>
								</figure>
								<h2 className="hulk-heading">
									{__('Google Sheet Connector For Elementor Forms by')}&nbsp;
									<a href="https://hulkplugins.com" target={'_blank'} rel="noreferrer">
										{__('Hulk Plugins')}
									</a>
								</h2>
							</div>
						</div>
						<div className="p-2">
							<a href={localizeSettings.DOCUMENTATION} target={'_blank'}
							   className={'components-button is-secondary is-compact has-text has-icon'}
							   rel="noreferrer">
								<Icon icon={page}/>
								{__('Documentation')}
							</a>
						</div>
						<div className="p-2">
							<a href={localizeSettings.SUPPORT} target={'_blank'}
							   className={'components-button is-secondary is-compact has-text has-icon'}
							   rel="noreferrer">
								<Icon icon={commentAuthorAvatar}/>
								{__('Support')}
							</a>
						</div>
						<div className="p-2">
							<div className="hulk-settings-version">{localizeSettings.VERSION}</div>
						</div>
					</div>
				</div>
				<div className="hulk-settings-body">
					<HashRouter future={{
						v7_relativeSplatPath: true,
						v7_startTransition: true
					}}>
						<Routes>
							<Route path="/" element={<Layout/>}>
								<Route index element={<Integration/>}/>
								<Route path="*" element={<NoMatch/>}/>
							</Route>
						</Routes>
					</HashRouter>
				</div>
				<Notice/>
			</div>
		</ErrorBoundary>
	)
}

export default App
