import React from "react";
import {__} from "@wordpress/i18n";
import {NavLink, Outlet} from "react-router-dom";

const items = [
	{
		slug: '/',
		name: __('Integration'),
	},
	/*{
		slug: '/settings',
		name: __('Settings'),
	},*/
];

function Layout() {
	return (
		<form
			id={'hulk-settings-form'}
			className={'hulk-settings-form'}
			encType={'multipart/form-data'}
			method={'post'}
			noValidate
			action=""
		>
			<div className="hulk-settings-nav">
				<ul className="hulk-nav-list">
					{items.map(({slug, name}) => (
						<li key={`nav-item-${slug}`} className="hulk-nav-item">
							<NavLink
								to={slug}
								className={({isActive}) => isActive ? 'hulk-nav-link hulk-link-active' : 'hulk-nav-link'}
							>{name}</NavLink>
						</li>
					))}
				</ul>
				{/*<div className="hulk-nav-last">
					<div className="hulk-save-btn-wrap">
						<SaveChanges/>
					</div>
				</div>*/}
			</div>
			<div className="hulk-settings-content">
				<Outlet/>
			</div>
			{/*<div className="hulk-save-btn-wrap">
				<SaveChanges/>
			</div>*/}
		</form>
	)
}

export default Layout
