import React from "react";
import {__} from "@wordpress/i18n";
import {Button} from "@wordpress/components";
import {arrowLeft, home} from "@wordpress/icons";
import {useNavigate} from "react-router-dom";

function NoMatch() {

	const navigate = useNavigate();

	return (
		<div className="hulk-error-page">
			<div className="error-status">
				<span>{__('404')}</span>
			</div>
			<h1 className="error-heading">
				{__('Page not found')}
			</h1>
			<p className="error-desc">
				{__('Sorry, we could not find the page.')}
			</p>
			<div className="error-footer">
				<div className="error-flex">
					<div className="error-flex-left">
						<Button
							type={'button'}
							variant={'secondary'}
							icon={arrowLeft}
							onClick={(e: React.MouseEvent<HTMLButtonElement>) => {
								e.preventDefault();
								navigate(-1);
							}}
						>
							{__('Go Back')}
						</Button>
					</div>
					<div className="error-flex-right">
						<Button
							type={'button'}
							variant={'primary'}
							icon={home}
							onClick={(e: React.MouseEvent<HTMLButtonElement>) => {
								e.preventDefault();
								navigate('/');
							}}
						>
							{__('Go to Home')}
						</Button>
					</div>
				</div>
			</div>
		</div>
	)
}

export default NoMatch
