import React, {createRef} from 'react';
import {create} from 'zustand'
import NoticeStore from "../types/NoticeStore";
import {check, closeSmall} from "@wordpress/icons";
import {Icon} from "@wordpress/components";
import uuid from "../../../utils/uuid";

const useNoticeStore = create<NoticeStore>((set) => ({
	notices: [],
	loading: false,
	setLoading: val => set({loading: val}),
	setError: val => set(state => ({
		notices: [
			{
				actions: [],
				content: val,
				explicitDismiss: true,
				id: `hulk-notice-${uuid()}`,
				icon: <Icon className={'hulk-notice-error'} icon={closeSmall}/>,
				ref: createRef(),
			},
			...state.notices,
		]
	})),
	setSuccess: val => set(state => ({
		notices: [
			{
				actions: [],
				content: val,
				explicitDismiss: true,
				id: `hulk-notice-${uuid()}`,
				icon: <Icon className={'hulk-notice-success'} icon={check}/>,
				ref: createRef(),
			},
			...state.notices,
		]
	})),
	removeNotice: val => set(state => ({
		notices: state.notices.filter((notice) => notice.id !== val),
	})),
	removeLastItem: () => set(state => ({
		notices: state.notices.slice(0, -1),
	}))
}))

export default useNoticeStore
