import {SettingsStoreProps} from "./SettingsStoreProps";

export type SheetsPops = {
	[key: string]: {
		title: string,
		options: {
			[key: string]: string
		}
	}
}

type SettingsType = {
	VERSION: string
	SUPPORT: string
	PREFIX: string
	GROUP: string
	DOCUMENTATION: string
	PLUGIN_DIR_URL: string
	adminColor: 'fresh' | 'modern',
	restUrl: string
	nonce: string
	settings: SettingsStoreProps,
	authCode: string
	settingsPageUrl: string
	hostname: string
	sheets: SheetsPops
}

const localizeSettings: SettingsType = (window as any).hulk_epfgsc_settings;

export default localizeSettings
