import fetcher from "../../../utils/fetcher";
import localizeSettings from "../types/localizeSettings";
import useSettingsStore from "../stores/useSettingsStore";

const restUrl = localizeSettings.restUrl;
const GROUP = localizeSettings.GROUP;

function clientAuthManualAjax() {
	return fetcher(`${restUrl}${GROUP}/v1/client-auth-manual`, {
		method: "POST",
		headers: {
			'Content-Type': 'application/json',
			'X-WP-Nonce': localizeSettings.nonce
		},
		body: JSON.stringify(useSettingsStore.getState())
	})
}

export default clientAuthManualAjax;
