import fetcher from "../../../utils/fetcher";
import localizeSettings from "../types/localizeSettings";
import useSettingsStore from "../stores/useSettingsStore";

const restUrl = localizeSettings.restUrl;
const GROUP = localizeSettings.GROUP;

async function settingsSaveAjax() {
	return await fetcher(`${restUrl}${GROUP}/v1/save-settings`, {
		method: "POST",
		headers: {
			'Content-Type': 'application/json',
			'X-WP-Nonce': localizeSettings.nonce
		},
		body: JSON.stringify(useSettingsStore.getState())
	});
}

export default settingsSaveAjax;
