import React, {Component, ErrorInfo, ReactNode} from "react";
import {__} from "@wordpress/i18n";

interface ErrorBoundaryProps {
	children: ReactNode;
}

interface ErrorBoundaryState {
	error: Error | null;
	errorInfo: ErrorInfo | null;
}

class ErrorBoundary extends Component<ErrorBoundaryProps, ErrorBoundaryState> {
	constructor(props: ErrorBoundaryProps) {
		super(props);
		this.state = {error: null, errorInfo: null};
	}

	componentDidCatch(error: Error, errorInfo: ErrorInfo) {
		// Catch errors in any components below and re-render with error message
		this.setState({
			error,
			errorInfo
		});
		// You can also log error messages to an error reporting service here
	}

	render() {
		if (this.state.errorInfo) {
			// Error path
			return (
				<div>
					<p style={{color: 'rgb(211, 79, 86)', fontWeight: 'bold'}}>
						{__('Something went wrong.')}
					</p>
					<details style={{whiteSpace: 'pre-wrap'}}>
						{this.state.error && this.state.error.toString()}
						<br/>
						{this.state.errorInfo.componentStack}
					</details>
				</div>
			);
		}
		// Normally, just render children
		return this.props.children;
	}
}

export default ErrorBoundary;
