import "./index.scss";
import React, {memo} from "react";

type TableProps = React.HTMLAttributes<HTMLTableElement>;

const Table = memo((props: TableProps) => (
	<table className={`form-table hulk-settings-table ${props.className || ''}`} role="presentation">
		<tbody>
		{props.children}
		</tbody>
	</table>
));

type TrProps = React.HTMLAttributes<HTMLTableRowElement>;

const Tr = memo((props: TrProps) => (
	<tr {...props}>{props.children}</tr>
));

type ThProps = React.ThHTMLAttributes<HTMLTableHeaderCellElement>;

const Th = memo((props: ThProps) => (
	<th {...props}>{props.children}</th>
));

type TdProps = React.TdHTMLAttributes<HTMLTableDataCellElement>;

const Td = memo((props: TdProps) => (
	<td {...props}>{props.children}</td>
));

export {Table, Tr, Th, Td};
