import React from 'react';
import './index.scss';
import {__} from "@wordpress/i18n";

type UpgradeOverlayProps = React.HTMLAttributes<HTMLDivElement> & {
	url: string
};

const UpgradeOverlay = (props: UpgradeOverlayProps) => {
	return (
		<div className={'hulk-ffef-upgrade-overlay'}>
			<a
				href={props.url}
				target="_blank"
				rel="noreferrer"
			>{__('Upgrade Now!')}</a>
		</div>
	);
};

export default UpgradeOverlay;
