import localizeSettings from "../admin/settings/types/localizeSettings";

/**
 * Show/Hide auth error
 * @param editor
 */
function authErrorControl(editor: any) {
	const element: HTMLSelectElement | null = editor.el.querySelector('.elementor-control-hulk_epfgsc_gsheetcaauthError');
	if (!element) {
		return;
	}
	const pElement = element.querySelector('p');
	if (!pElement) {
		return;
	}
	const sheets = localizeSettings.sheets;
	if (Object.keys(sheets).length === 0) {
		pElement.style.display = 'block';
	} else {
		pElement.style.display = 'none';
	}
}

export default authErrorControl;
