import fetcher from "../utils/fetcher";
import localizeSettings from "../admin/settings/types/localizeSettings";
import fetchSheet from "./fetchSheet";

const restUrl = localizeSettings.restUrl;
const GROUP = localizeSettings.GROUP;

/**
 * Create a new spreadsheet with name
 * @param instance
 */
async function createNew(instance: any) {
	// eslint-disable-next-line no-alert
	const prompt = window.prompt('Please enter the spreadsheet name.');
	if (!prompt?.trim()) {
		return;
	}
	const container: HTMLDivElement = instance.el.closest('#elementor-controls');
	const button: HTMLButtonElement = instance.el.querySelector('[data-event="namespace:editor:hulk_epfgsc_createNew"]');
	button.innerText = 'Creating...';
	button.disabled = true;

	// Auth error element
	const authError: HTMLDivElement | null = container?.querySelector('.authErrorControl');
	if (authError) {
		authError.style.display = 'none';
	}

	try {
		await fetcher(`${restUrl}${GROUP}/v1/create-spreadsheet`, {
			method: "POST",
			headers: {'Content-Type': 'application/json'},
			body: JSON.stringify({prompt})
		});
		await fetchSheet(instance);
	} catch (err) {
		if (typeof err?.message === "string") {
			// eslint-disable-next-line no-alert
			window.alert(err.message);
		} else if (typeof err === 'string') {
			// eslint-disable-next-line no-alert
			window.alert(err);
		} else {
			// eslint-disable-next-line no-alert
			window.alert(JSON.stringify(err));
		}
		if (authError) {
			authError.style.display = 'block';
		}
	} finally {
		button.disabled = false;
		button.innerText = 'Create New';
	}
}

export default createNew;
