import fetcher from "../utils/fetcher";
import localizeSettings, {SheetsPops} from "../admin/settings/types/localizeSettings";
import renderSpreadsheetOptions from "./renderSpreadsheetOptions";
import renderSheetOptions from "./renderSheetOptions";

const elementor = (window as any).elementor;
const restUrl = localizeSettings.restUrl;
const GROUP = localizeSettings.GROUP;
const PREFIX = localizeSettings.PREFIX;

/**
 * Fetch google sheets
 * @param element
 */
async function fetchSheet(element: any) {
	const container: HTMLDivElement = element.el.closest('#elementor-controls');
	const button: HTMLButtonElement | null = container?.querySelector('[data-event="namespace:editor:hulk_epfgsc_sheetFetch"]');
	if (button) {
		button.innerText = 'Fetching...';
		button.disabled = true;
	}

	// Error element
	const apiError: HTMLDivElement | null = container?.querySelector('.apiErrorControl .elementor-control-raw-html');
	if (apiError) {
		apiError.classList.remove('apiError');
		apiError.innerHTML = '';
	}

	// Auth error element
	const authError: HTMLDivElement | null = container?.querySelector('.authErrorControl');
	if (authError) {
		authError.style.display = 'none';
	}

	const select1 = container?.querySelector(`[data-setting="${PREFIX}gsheetcasheetName"]`) as HTMLSelectElement | null;
	const select2 = container?.querySelector(`[data-setting="${PREFIX}gsheetcasheetTabName"]`) as HTMLSelectElement | null;

	try {
		const sheets: SheetsPops = await fetcher(`${restUrl}${GROUP}/v1/fetch-spreadsheets`, {
			method: "GET",
			headers: {'Content-Type': 'application/json'},
		});
		(window as any).hulk_epfgsc_settings.sheets = sheets;
		if (button) {
			button.innerText = 'Successfully fetched!';
		}
		const editor = elementor.getPanelView().getCurrentPageView();
		const selectedSpreadsheetId = renderSpreadsheetOptions(sheets, editor);
		if (select1 && select2 && selectedSpreadsheetId) {
			renderSheetOptions(sheets, editor, selectedSpreadsheetId);
		}
	} catch (err) {
		if (typeof err?.message === "string" && apiError) {
			apiError.classList.add('apiError');
			apiError.innerHTML = err.message;
		} else if (typeof err === 'string' && apiError) {
			apiError.classList.add('apiError');
			apiError.innerHTML = err;
		} else if (apiError) {
			apiError.classList.add('apiError');
			apiError.innerHTML = JSON.stringify(err);
		}
		if (select1) {
			select1.innerHTML = '';
		}
		if (select2) {
			select2.innerHTML = '';
		}
		if (authError) {
			authError.style.display = 'block';
		}
	} finally {
		if (button) {
			button.disabled = false;
			setTimeout(() => {
				button.innerText = 'Click here to fetch Google Sheets';
			}, 4000);
		}
	}
}

export default fetchSheet;
