import "./index.scss";
import jQuery from 'jquery';
import createNew from "./createNew";
import renderFieldsOptions from "./renderFieldsOptions";
import renderSpreadsheetOptions from "./renderSpreadsheetOptions";
import renderSheetOptions from "./renderSheetOptions";
import widgetPanel from "./widgetPanel";
import viewSheet from "./viewSheet";
import fetchSheet from "./fetchSheet";
import localizeSettings from "../admin/settings/types/localizeSettings";
import authErrorControl from "./authErrorControl";
import store from "./store";

const PREFIX = localizeSettings.PREFIX;

jQuery(function () {
	const elementor = (window as any).elementor;

	/**
	 * Run when widget section is activated/open
	 * const view = editor.getOption('editedElementView');
	 * const model = editor.getOption('editedElementView').getEditModel();
	 * const widgetId = model.get('elType');
	 * const settings = model?.get('settings')?.toJSON();
	 * const formFields = settings?.form_fields ?? [];
	 * const widgetId = editor.model.get('id');
	 * @param id
	 * @param editor
	 */
	function sectionActivated(id: string, editor: any) {
		if (id !== 'hulk_epfgsc_gsheetcasection') {
			return;
		}
		const model = editor.getOption('editedElementView').getEditModel();
		const settings = model?.get('settings');
		const settingsJSON = settings?.toJSON();

		// Set initial values
		const spreadsheetIdKey = `${PREFIX}gsheetcasheetName`;
		const tabIdKey = `${PREFIX}gsheetcasheetTabName`;
		const formFieldsHeadersKey = `${PREFIX}gsheetcaformHeaders`;
		store.set('spreadsheetId', settings?.changed?.[spreadsheetIdKey] ?? settingsJSON?.[spreadsheetIdKey]);
		store.set('tabId', settings?.changed?.[tabIdKey] ?? settingsJSON?.[tabIdKey]);
		store.set('formFieldsHeaders', settings?.changed?.[formFieldsHeadersKey] ?? settingsJSON?.[formFieldsHeadersKey]);

		authErrorControl(editor);
		renderFieldsOptions(editor, settingsJSON);
		const sheets = localizeSettings.sheets;
		const selectedSpreadsheetId = renderSpreadsheetOptions(sheets, editor);
		if (selectedSpreadsheetId) {
			renderSheetOptions(sheets, editor, selectedSpreadsheetId);
		}
	}

	elementor.channels.editor.on('namespace:editor:hulk_epfgsc_createNew', createNew);
	elementor.channels.editor.on('namespace:editor:hulk_epfgsc_sheetFetch', fetchSheet);
	elementor.channels.editor.on('namespace:editor:hulk_epfgsc_sheetView', viewSheet);
	elementor.channels.editor.on('section:activated', sectionActivated);
	elementor.hooks.addAction('panel/open_editor/widget/form', widgetPanel);
});
