import store from "./store";

const exclude = ['honeypot', 'recaptcha', 'recaptcha_v3', 'html', 'step'];

function renderFieldsOptions(editor: any, settings: any) {
	const formFields = (settings?.form_fields ?? []) as {
		custom_id: string;
		field_label: string;
		field_type: string;
	}[];
	if (formFields.length <= 0) {
		return;
	}
	const select2: HTMLSelectElement | null = editor.el.querySelector('.elementor-control-hulk_epfgsc_gsheetcaformHeaders .elementor-select2');
	if (!select2) {
		return;
	}
	const $select2 = jQuery(select2);
	const previousSelectedVal = store.get('formFieldsHeaders');
	select2.innerHTML = '';
	formFields.forEach((field) => {
		const customId = field.custom_id?.trim();
		const label = field.field_label?.trim();
		if (customId && label && !exclude.includes(field.field_type)) {
			const newOption = new Option(label, customId, false, false);
			select2.appendChild(newOption);
		}
	});
	if (previousSelectedVal) {
		$select2.val(previousSelectedVal);
	}
	select2.dispatchEvent(new Event('change', {bubbles: true}));
	store.set('formFieldsHeaders', $select2.val());
}

export default renderFieldsOptions
