import localizeSettings, {SheetsPops} from "../admin/settings/types/localizeSettings";
import store from "./store";

const PREFIX = localizeSettings.PREFIX;

/**
 * Select Sheet Tab Name (options)
 * @param sheets
 * @param editor
 * @param selectedSpreadsheetId
 */
function renderSheetOptions(sheets: SheetsPops, editor: any, selectedSpreadsheetId: string) {
	const container: HTMLDivElement | null = editor.el;
	const select2 = container?.querySelector(`[data-setting="${PREFIX}gsheetcasheetTabName"]`) as HTMLSelectElement | null;
	if (!select2) {
		return;
	}
	const selectedTabId = store.get('tabId');
	select2.innerHTML = '';
	const select2Options = sheets?.[selectedSpreadsheetId as string]?.options ?? {};
	Object.entries(select2Options).forEach(([key, title]) => {
		const newOption = new Option(title, key, false, false);
		select2.appendChild(newOption);
	});
	if (selectedTabId) {
		select2.value = selectedTabId;
		if (!select2.value) {
			select2.selectedIndex = 0;
		}
	} else if (!select2.value) {
		select2.selectedIndex = 0;
	}
	select2.dispatchEvent(new Event('change', {bubbles: true}));
	store.set('tabId', select2.value);
}

export default renderSheetOptions
