import localizeSettings, {SheetsPops} from "../admin/settings/types/localizeSettings";
import store from "./store";

const PREFIX = localizeSettings.PREFIX;

/**
 * Select Sheet Name (options)
 * @param sheets
 * @param editor
 */
function renderSpreadsheetOptions(sheets: SheetsPops, editor: any) {
	const container: HTMLDivElement | null = editor.el;
	const select1 = container?.querySelector(`[data-setting="${PREFIX}gsheetcasheetName"]`) as HTMLSelectElement | null;
	if (!select1) {
		return;
	}
	const selectedSpreadsheetId = store.get('spreadsheetId');
	select1.innerHTML = '';
	Object.entries(sheets).forEach(([key, item]) => {
		const newOption = new Option(item.title, key, false, false);
		select1.appendChild(newOption);
	});
	if (selectedSpreadsheetId) {
		select1.value = selectedSpreadsheetId;
		if (!select1.value) {
			select1.selectedIndex = 0;
		}
	} else if (!select1.value) {
		select1.selectedIndex = 0;
	}
	select1.dispatchEvent(new Event('change', {bubbles: true}));
	store.set('spreadsheetId', select1.value);
	return select1.value;
}

export default renderSpreadsheetOptions
