import localizeSettings from "../admin/settings/types/localizeSettings";

const PREFIX = localizeSettings.PREFIX;

/**
 * View Google Sheet
 * @param element
 */
function viewSheet(element: any) {
	const container: HTMLDivElement = element.el.closest('#elementor-controls');
	const select1: HTMLSelectElement | null = container?.querySelector(`[data-setting="${PREFIX}gsheetcasheetName"]`);
	const select1Val = select1?.value?.trim();
	if (!select1Val) {
		// eslint-disable-next-line no-alert
		window.alert('Please select a sheet name');
		return;
	}
	const select2: HTMLSelectElement | null = container?.querySelector(`[data-setting="${PREFIX}gsheetcasheetTabName"]`);
	const select2Val = select2?.value?.trim();
	if (!select2Val) {
		// eslint-disable-next-line no-alert
		window.alert('Please select a sheet tab name');
		return;
	}
	const url = `https://docs.google.com/spreadsheets/d/${select1Val}/edit#gid=${select2Val}`
	window.open(url, '_blank');
}

export default viewSheet;
