import localizeSettings from "../admin/settings/types/localizeSettings";
import renderSheetOptions from "./renderSheetOptions";
import store from "./store";

const PREFIX = localizeSettings.PREFIX;

/**
 * Hook into the widget's editor panel opening event
 * @param panel
 * @param model
 */
function widgetPanel(panel: any, model: any) {
	// Access the widget's settings model
	const settingsModel = model.get('settings');
	// Listen for changes in the settings model
	settingsModel.on('change', function (changedModel: any) {
		// Retrieve the changed setting's name and value
		const changedSetting = changedModel?.changed;
		const settingName = Object.keys(changedSetting)?.[0];

		// Check if the changed setting is the specific select control
		if (settingName === `${PREFIX}gsheetcasheetName`) {
			const settingValue = changedSetting?.[settingName];
			const sheets = localizeSettings.sheets;
			store.set('spreadsheetId', settingValue);
			renderSheetOptions(sheets, panel, settingValue);
		} else if (settingName === `${PREFIX}gsheetcasheetTabName`) {
			store.set('tabId', changedSetting?.[settingName]);
		} else if (settingName === `${PREFIX}gsheetcaformHeaders`) {
			store.set('formFieldsHeaders', changedSetting?.[settingName]);
		}
	});
}

export default widgetPanel;
