let timeoutId: NodeJS.Timeout | null = null;

function delay(ms: number = 2000): Promise<void> {
	// Clear any existing timeout if this function is called again
	if (timeoutId) {
		clearTimeout(timeoutId);
	}

	return new Promise(resolve => {
		// Set a new timeout and store its ID
		timeoutId = setTimeout(() => {
			resolve();
			timeoutId = null; // Reset timeout ID after resolve
		}, ms);
	});
}

export default delay;
