const fetcher = async (input: string | URL | globalThis.Request, init?: RequestInit,): Promise<any> => {
	const res = await fetch(input, {
		method: "GET",
		redirect: "follow",
		headers: {
			'Content-Type': 'application/json',
		},
		...init
	});

	if (!res.ok) {
		const json = await res.json();
		// Reload current page is nonce is invalid
		if (json?.code === 'rest_cookie_invalid_nonce') {
			window.location.reload();
		}
		throw json;
	}

	return res.json();
}

export default fetcher;
