/**
 * Generate Unique ID
 */
function uuid(): string {
	let dt = new Date().getTime();
	return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
		const r = Math.floor((dt + Math.random() * 16) % 16);
		dt = Math.floor(dt / 16);
		if (c === 'x') {
			return r.toString(16);
		}
		return ((r % 4) + 8).toString(16); // Ensures the 'y' character gets values 8, 9, A, or B
	});
}

export default uuid;
