<?php
/**
 * Assets class
 *
 * @package InventSlider
 */
namespace DynamicLayers\InventSlider\Classes;

defined( 'ABSPATH' ) || die();

class Assets {

    /**
     * Init
     */
    function __construct() {

        add_action( "elementor/editor/after_enqueue_styles", [$this, 'el_editor_styles'] );
        add_action( "elementor/frontend/after_enqueue_styles", [$this, 'register_styles'] );
        add_action( "elementor/frontend/after_register_scripts", [$this, 'register_scripts'], 100 );

    }

    /**
     * Elementor Editor Styles
     *
     * @return void
     */
    public function el_editor_styles() {
        wp_register_style( 'invent-el-editor-style', INVENT_SLIDER_ASSETS . '/admin/css/el-editor.css', false, INVENT_SLIDER_VERSION );
        wp_enqueue_style( 'invent-el-editor-style' );
    }

    /**
     * Register styles
     *
     * @return void
     */
    public function register_styles() {

        $min = ( WP_DEBUG === true ) ? '' : '.min';
        wp_register_style( 'splitting', INVENT_SLIDER_ASSETS . '/css/lib/splitting.min.css', false, '1.0' );
        wp_register_style( 'invent-slider-style', INVENT_SLIDER_ASSETS . '/css/widgets/slider' . $min . '.css', false, INVENT_SLIDER_VERSION );

    }

    /**
     * Register Scripts
     *
     * @return void
     */
    public function register_scripts() {
        $min = ( WP_DEBUG === true ) ? '' : '.min';
        wp_register_script( 'splitting', INVENT_SLIDER_ASSETS . '/js/lib/splitting.min.js', [], '1.0', true );
        wp_register_script( 'invent-slider-script', INVENT_SLIDER_ASSETS . '/js/slider'. $min .'.js', ['jquery', 'elementor-frontend'], INVENT_SLIDER_VERSION, true );
    }

}