<?php
/**
 * License Config
 *
 * @package InventSlider
 */
namespace DynamicLayers\InventSlider\Classes\License;

use \DynamicLayers\InventSlider\Classes\License\Base;
defined( 'ABSPATH' ) || die();

class Config {
    public $plugin_file=__FILE__;
    public $responseObj;
    public $licenseMessage;
    public $showMessage=false;
    public $slug="invent-slider-for-elementor";
    function __construct() {
        add_action( 'admin_print_styles', [ $this, 'SetAdminStyle' ] );
        $licenseKey=get_option("InventSliderforElementor_lic_Key","");
        $liceEmail=get_option( "InventSliderforElementor_lic_email","");
        Base::addOnDelete(function(){
            delete_option("InventSliderforElementor_lic_Key");
        });
        if(Base::CheckWPPlugin($licenseKey,$liceEmail,$this->licenseMessage,$this->responseObj,__FILE__)){
            add_action( 'admin_menu', [$this,'ActiveAdminMenu'],99999);
            add_action( 'admin_post_InventSliderforElementor_el_deactivate_license', [ $this, 'action_deactivate_license' ] );
        }else{
            if(!empty($licenseKey) && !empty($this->licenseMessage)){
                $this->showMessage=true;
            }
            update_option("InventSliderforElementor_lic_Key","") || add_option("InventSliderforElementor_lic_Key","");
            add_action( 'admin_post_InventSliderforElementor_el_activate_license', [ $this, 'action_activate_license' ] );
            add_action( 'admin_menu', [$this,'InactiveMenu']);
        }
    }

    function SetAdminStyle() {
        wp_register_style( 'invent-slider-lc-style', INVENT_SLIDER_ASSETS . '/admin/css/lc-style.css', false, '1.0' );
        wp_enqueue_style( "invent-slider-lc-style" );
    }

    function ActiveAdminMenu(){
        //admin.php?page=elementor-tools
		// add_menu_page (  "InventSliderforElementor", "Invent Slider for Elementor", "activate_plugins", $this->slug, [$this,"Activated"], " dashicons-star-filled ");
		add_submenu_page(  'options-general.php', "Invent Slider Activation Details", "Invent Slider Activation", "activate_plugins",  $this->slug, [$this,"Activated"] );

    }

    function InactiveMenu() {
        add_action( 'admin_notices', [$this, 'admin_notice_active_theme'] );
        add_action( 'admin_footer', [ $this, 'custom_admin_notice_script' ] );
        // add_menu_page( "InventSliderforElementor", "Invent Slider for Elementor", 'activate_plugins', $this->slug,  [$this,"LicenseForm"], " dashicons-star-filled " );
        add_submenu_page( 'options-general.php', "Invent Slider Activation", "Invent Slider Activation", "activate_plugins",  $this->slug, [$this,"LicenseForm"] );
        // add_menu_page( "InventSliderforElementor", "Invent Slider for Elementor", 'activate_plugins', $this->slug,  [$this,"LicenseForm"], " dashicons-star-filled " );
    }

    function action_activate_license(){
        check_admin_referer( 'el-license' );
        $licenseKey=!empty($_POST['el_license_key'])?$_POST['el_license_key']:"";
        $licenseEmail=!empty($_POST['el_license_email'])?$_POST['el_license_email']:"";
        update_option("InventSliderforElementor_lic_Key",$licenseKey) || add_option("InventSliderforElementor_lic_Key",$licenseKey);
        update_option("InventSliderforElementor_lic_email",$licenseEmail) || add_option("InventSliderforElementor_lic_email",$licenseEmail);
        update_option('_site_transient_update_plugins','');
        wp_safe_redirect(admin_url( 'admin.php?page='.$this->slug));
    }

    function action_deactivate_license() {
        check_admin_referer( 'el-license' );
        $message="";
        if(Base::RemoveLicenseKey(__FILE__,$message)){
            update_option("InventSliderforElementor_lic_Key","") || add_option("InventSliderforElementor_lic_Key","");
            update_option('_site_transient_update_plugins','');
        }
        wp_safe_redirect(admin_url( 'admin.php?page='.$this->slug));
    }

    function Activated(){
        ?>
        <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
            <input type="hidden" name="action" value="InventSliderforElementor_el_deactivate_license"/>
            <div class="el-license-container">
                <h3 class="el-license-title"> <img src="<?php echo INVENT_SLIDER_ASSETS; ?>/img/icon.png" alt="Invent Slider"> Invent Slider Activation Info</h3>
                <hr>
                <ul class="el-license-info">
                <li>
                    <div>
                        <span class="el-license-info-title"><?php _e("Status",$this->slug);?></span>

                        <?php if ( $this->responseObj->is_valid ) : ?>
                            <span class="el-license-valid"><?php _e("Valid",$this->slug);?></span>
                        <?php else : ?>
                            <span class="el-license-valid"><?php _e("Invalid",$this->slug);?></span>
                        <?php endif; ?>
                    </div>
                </li>

                <li>
                    <div>
                        <span class="el-license-info-title"><?php _e("License Type",$this->slug);?></span>
                        <?php echo $this->responseObj->license_title; ?>
                    </div>
                </li>

               <li>
                   <div>
                       <span class="el-license-info-title"><?php _e("License Expired on",$this->slug);?></span>
                       <?php echo $this->responseObj->expire_date;
                       if(!empty($this->responseObj->expire_renew_link)){
                           ?>
                           <a target="_blank" class="el-blue-btn" href="<?php echo $this->responseObj->expire_renew_link; ?>">Renew</a>
                           <?php
                       }
                       ?>
                   </div>
               </li>
                <li>
                    <div>
                        <span class="el-license-info-title"><?php _e("Your License Key",$this->slug);?></span>
                        <span class="el-license-key"><?php echo esc_attr( substr($this->responseObj->license_key,0,9)."XXXXXXXX-XXXXXXXX".substr($this->responseObj->license_key,-9) ); ?></span>
                    </div>
                </li>
                </ul>
                <div class="el-license-active-btn">
                    <?php wp_nonce_field( 'el-license' ); ?>
                    <?php submit_button('Deactivate'); ?>
                </div>
            </div>
        </form>
    <?php
    }

    function LicenseForm() {
        ?>
    <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
        <input type="hidden" name="action" value="InventSliderforElementor_el_activate_license"/>
        <div class="el-license-container">
        <h3 class="el-license-title"> <img src="<?php echo INVENT_SLIDER_ASSETS; ?>/img/icon.png" alt="arkid"> Invent Slider Activation</h3>
            <hr>
            <?php
            if(!empty($this->showMessage) && !empty($this->licenseMessage)){
                ?>
                <div class="notice notice-error is-dismissible">
                    <p><?php echo _e($this->licenseMessage,$this->slug); ?></p>
                </div>
                <?php
            }
            ?>
            <div class="el-license-field">
                <label for="el_license_key"><?php _e("License code",$this->slug);?></label>
                <input type="text" class="regular-text code" name="el_license_key" size="50" placeholder="xxxxxxxx-xxxxxxxx-xxxxxxxx-xxxxxxxx" required="required">
            </div>
            <div class="el-license-field">
                <label for="el_license_key"><?php _e("Email Address",$this->slug);?></label>
                <?php
                    $purchaseEmail   = get_option( "InventSliderforElementor_lic_email", get_bloginfo( 'admin_email' ));
                ?>
                <input type="text" class="regular-text code" name="el_license_email" size="50" value="<?php echo $purchaseEmail; ?>" placeholder="" required="required">
                <div><small><?php _e("We will send update news of this product by this email address, don't worry, we hate spam",$this->slug);?></small></div>
            </div>
            <div class="el-license-active-btn">
                <?php wp_nonce_field( 'el-license' ); ?>
                <?php submit_button('Activate'); ?>
            </div>
        </div>
    </form>
        <?php
    }

    function admin_notice_active_theme() {
        $dismissed = isset( $_COOKIE['dl_lc_dismissed_notice'] ) ? $_COOKIE['dl_lc_dismissed_notice'] : false;
        if( !$dismissed ) {
            $message = __( 'To unlock Invent Slider updates, please activate the plugin from ', 'arkid' ) . '<a href="' . admin_url( 'admin.php?page='.$this->slug ) . '">' . __( 'here', 'arkid' ) . '</a>.';
            printf( '<div id="dl-lc-notice" class="notice notice-warning is-dismissible"><p>%1$s</p><button type="button" class="notice-dismiss" aria-label="Dismiss"></button></div>', $message );
        }
    }

    function custom_admin_notice_script() {
        ?>
        <script>
            jQuery(document).ready(function ($) {
                var date = new Date(),
                expires = 'expires=';
                date.setDate(date.getDate() + 10);
            // Check if the notice has been dismissed
            if (document.cookie.includes('dl_lc_dismissed_notice=true')) {
                $('#dl-lc-notice').hide();
            }

            // Handle dismissal
            $('#dl-lc-notice .notice-dismiss').on('click', function () {
                // Set a cookie to remember the dismissal for the session
                document.cookie = 'dl_lc_dismissed_notice=true;expires='+date.toGMTString()+'; path=/';

                // Hide the notice
                $('#dl-lc-notice').hide();
            });
        });
        </script>
        <?php
    }

    
}