<?php
/**
 * Plugin Name: Invent Slider for Elementor
 * Description: It is a Elementor addon with awesome useful slider widgets to create nice looking slider using Elementor.
 * Plugin URI: https://addons.dynamiclayers.net/invent-slider
 * Author: DynamicLayers
 * Author URI: https://codecanyon.net/user/dynamiclayers/portfolio
 * Version: 1.0.6
 * Requires at least: 5.0
 * Tested up to: 6.7
 * Requires PHP: 7.3
 * Elementor tested up to: 3.26.3
 * License: GPL2 or later
 * Text Domain: invent-slider
 * Domain Path: /languages
 * @package InventSlider
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

require_once __DIR__ . '/vendor/autoload.php';

/**
 * The main plugin class
 */
final class InventSlider {

    /**
     * Plugin version
     *
     * @var string
     */
    const version = '1.0.6';

    /**
     * Class construcotr
     */
    private function __construct() {
        $this->define_constants();

        register_activation_hook( __FILE__, [ $this, 'activate' ] );

        add_action( 'init', [ $this, 'load_textdomain' ] );

        add_action( 'plugins_loaded', [ $this, 'init_plugin' ] );

        add_action( 'elementor/init', [ $this, 'elementor_init' ] );
    }

    /**
     * Initializes a singleton instance
     *
     * @return \InventSlider
     */
    public static function init() {
        static $instance = false;

        if ( ! $instance ) {
            $instance = new self();
        }

        return $instance;
    }

    /**
     * Define the required plugin constants
     *
     * @return void
     */
    public function define_constants() {
        define( 'INVENT_SLIDER_VERSION', self::version );
        define( 'INVENT_SLIDER_FILE', __FILE__ );
        define( 'INVENT_SLIDER_PATH', __DIR__ );
        define( 'INVENT_SLIDER_URL', plugins_url( '', INVENT_SLIDER_FILE ) );
        define( 'INVENT_SLIDER_ASSETS', INVENT_SLIDER_URL . '/assets' );
    }

    /**
     * Load TextDomain
     *
     * @return void
     */
    public function load_textdomain() {
        load_plugin_textdomain( 'invent-slider', false, basename( dirname( __FILE__ ) ) . '/languages' );
    }

    /**
     * Initialize the plugin
     *
     * @return void
     */
    public function init_plugin() {

        if ( is_admin() ) {
            new \DynamicLayers\InventSlider\Classes\Elementor();
            new \DynamicLayers\InventSlider\Classes\License\Config();
        }

        new \DynamicLayers\InventSlider\Classes\Assets();

    }

    /**
     * Elementor Initialize
     *
     * @return void
     */
    public function elementor_init(){
        
        new \DynamicLayers\InventSlider\Classes\Widgets();
    }

    /**
     * Do stuff upon plugin activation
     *
     * @return void
     */
    public function activate() {
        $installer = new \DynamicLayers\InventSlider\Classes\Installer();
        $installer->run();
    }
}

/**
 * Initializes the main plugin
 *
 * @return \InventSlider
 */
function invent_slider_init() {
    return InventSlider::init();
}

// kick-off the plugin
invent_slider_init();
