<?php

/**
 * Plugin Name: Meeek Link in Bio Creator (For Elementor)
 * Description: The creator of your personal designed website. This is not the SaaS version. To get the SaaS Meeek version please go to CodeCanyon. When the Meeek SaaS is activated, this Elementor version should be disabled.
 * Plugin URI:  https://meeek.modeltheme.com/
 * Version:     1.1
 * Author:      Modeltheme
 * Author URI:  https://modeltheme.com/
 * Text Domain: meeek
 *
 * Elementor tested up to: 3.13.0
 * Elementor Pro tested up to: 3.13.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}



function meeek_bio_links_styles() {
    wp_enqueue_style( 'meeek-bio-links', plugins_url( 'assets/css/meeek-bio-links.css', __FILE__ ), array(), '1.0.0', 'all' );
    wp_enqueue_style( 'meeek-about-me', plugins_url( 'assets/css/meeek-about-me.css', __FILE__ ), array(), '1.0.0', 'all' );
    wp_enqueue_style( 'meeek-social-media-links', plugins_url( 'assets/css/meeek-social-media-links.css', __FILE__ ), array(), '1.0.0', 'all' );
}
add_action( 'wp_enqueue_scripts', 'meeek_bio_links_styles' );

require_once( __DIR__ . '/inc/functions-admin.php' );

add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), 'meeek_add_plugin_action_links' );
function meeek_add_plugin_action_links($links){
    $links['go_meeekdocs'] = '<a href="https://docs.modeltheme.com/meeek-plugin/" target="_blank" style="color: #00a32a;">'.__('Docs', 'meeek').'</a>';
    $links['go_meeeksaas'] = '<a href="https://1.envato.market/meeek-saas" target="_blank" style="color: #F7345E; font-weight: 700;">'.__('Upgrade to Meeek SaaS', 'meeek').'</a>';

    return $links;
}
/**
||-> Function: LOAD PLUGIN TEXTDOMAIN
*/
function meeek_load_textdomain(){
    $domain = 'meeek';
    $locale = apply_filters( 'plugin_locale', get_locale(), $domain );

    load_textdomain( $domain, trailingslashit( WP_LANG_DIR ) . $domain . '/' . $domain . '-' . $locale . '.mo' );
    load_plugin_textdomain( $domain, FALSE, basename( plugin_dir_path( dirname( __FILE__ ) ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'meeek_load_textdomain' );



if ( class_exists('Elementor\Core\Admin\Admin') ) {
    
    /**
     * Register Widgets.
     *
     * Include widget file and register widget class.
     *
     * @since 1.0.0
     * @param \Elementor\Widgets_Manager $widgets_manager Elementor widgets manager.
     * @return void
     */

    function meeek_register_custom_widgets( $widgets_manager ) {

        require_once( __DIR__ . '/widgets/meeek-about-me.php' );
        require_once( __DIR__ . '/widgets/meeek-social-media-links.php' );
        require_once( __DIR__ . '/widgets/meeek-bio-links.php' );
        
        $widgets_manager->register( new \Meeek_About_Me() );
        $widgets_manager->register( new \Meeek_Social_Media_Links() );
        $widgets_manager->register( new \Meeek_Bio_Links() );
    }
    add_action( 'elementor/widgets/register', 'meeek_register_custom_widgets' );
    
    // Elementor Widgets Category
    function meeek_widget_categories( $elements_manager ) {
        $elements_manager->add_category(
            'meeek-elementor-plugin',
            [
                'title' => esc_html__( 'Meeek (Bio Links)', 'emaf' ),
                'icon' => 'fas fa-plug',
            ]
        );
    }
    add_action( 'elementor/elements/categories_registered', 'meeek_widget_categories' );
}
