<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Meeek_About_Me extends \Elementor\Widget_Base { 
   /**
	 * Get widget name.
	 *
	 * Retrieve Card widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */

	public function get_name() {
		return 'about me';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Card widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Meeek - About Me', 'meeek' );
	}

    /**
	 * Get widget icon.
	 *
	 * Retrieve Card widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter-bold';
	}

    /**
	 * Get custom help URL.
	 *
	 * Retrieve a URL where the user can get more information about the widget.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget help URL.
	 */
	public function get_custom_help_url() {
		return 'https://www.modeltheme.com/';
	}

    /**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Card widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'meeek-elementor-plugin' ];
	}

    /**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the Card widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'about', 'me', 'meeek' ];
	}

	public function get_link() {
		return 'link';
	}
    /**
	 * Register Card widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */

	protected function register_controls() { 
		// our control function code goes here.

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content Section', 'meeek' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'about_us_image',
			[
				'label' => esc_html__( 'Choose Image', 'meeek' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
	  	'image_dimensions',
		  [
		    'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
		    'label' => __( 'Image Dimensions', 'meeek' ),
		    'default' => [
		      'width' => '200',
		      'height' => '200',
		      'unit' => 'px',
		    ],
		  ]
		);

		$this->add_control(
			'image_alignment',
			[
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'label' => esc_html__( 'Image Alignment', 'meeek' ),
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'meeek' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'meeek' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'meeek' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
			]
		);

		$this->add_control(
			'about_us_title',
			[
				'label' => esc_html__( 'Title', 'meeek' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Your main title goes here.', 'meeek' ),
				'default' => 'Jenn',
			],
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .meeek-about-me-title',
			]
		);

		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Title Color', 'meeek' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .meeek-about-me-title' => 'color: {{VALUE}}',
				],
				'default' => '#000',
			]
		);

		$this->add_control(
			'title_alignment',
			[
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'label' => esc_html__( 'Title Alignment', 'meeek' ),
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'meeek' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'meeek' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'meeek' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
			]
		);

		$this->add_control(
            'padding_title',
            [
                'label' => esc_html__( 'Title Padding', 'meeek' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .meeek-about-me-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'unit' => 'px',
                'size' => 150,
            ],
         ]
       );

		$this->add_control(
			'about_us_description',
			[
				'label' => esc_html__( 'Description', 'meeek' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'label_block'   => true,
				'default' => 'Curating all things home decor, fashion, food and travel',
				'placeholder' => esc_html__( 'Your description goes here.', 'meeek' ),
				'default' => 'Curating all things home decor, fashion, food and travel',
			],
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'selector' => '{{WRAPPER}} .meeek-about-me-description',
			]
		);	

		$this->add_control(
			'description_color',
			[
				'label' => esc_html__( 'Description Color', 'meeek' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .meeek-about-me-description' => 'color: {{VALUE}}',
				],
				'default' => '#000',
			]
		);

		$this->add_control(
			'description_alignment',
			[
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'label' => esc_html__( 'Description Alignment', 'meeek' ),
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'meeek' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'meeek' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'meeek' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
			]
		);

		$this->add_control(
            'padding_description',
            [
                'label' => esc_html__( 'Description Padding', 'meeek' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .meeek-about-me-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'unit' => 'px',
                'size' => 150,
            ],
         ]
       	);
		$this->end_controls_section();

		$this->start_controls_section(
			'widget_promotion_section',
			array(
				'label' => esc_html__( 'Meeek SaaS (Upgrade)', 'meeek' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'widget_promotion',
			array(
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				/* translators: %s admin link */
				'raw'             => sprintf( esc_html__( ' %1$sMeeek SaaS for WordPress %2$s is now available options to monetize your bio links website and sell subscriptions to users.', 'meeek' ), '<a href="https://codecanyon.net/item/meeek-bio-links-saas-wordpress/46935773?utm_source=getmore&utm_medium=meeek-elementor-builder&utm_campaign=gopremium" target="_blank" rel="noopener">', '</a>' ),
				'content_classes' => 'meeek-elementor-admin-widget-promotion',
			)
		);
			

		$this->end_controls_section();

	}

    /**
	 * Render Card widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() { 
		// get our input from the widget settings.
		$settings = $this->get_settings_for_display();
		// get the individual values of the input
		$about_us_image = $settings['about_us_image']['url'];
		$about_us_title = $settings['about_us_title'];
		$about_us_description = $settings['about_us_description'];
		$title_alignment = $settings['title_alignment'];
		$description_alignment = $settings['description_alignment'];
		$image_alignment = $settings['image_alignment'];

		$image_dimensions = $this->get_settings_for_display( 'image_dimensions' );
		$image_width = $image_dimensions['width'];
		$image_height = $image_dimensions['height'];

		echo do_shortcode('[meeek-about-me settings="'.$settings.'" about_us_image="'.$about_us_image.'" about_us_title="'.$about_us_title.'" about_us_description="'.$about_us_description.'" title_alignment="'.$title_alignment.'" description_alignment="'.$description_alignment.'" image_alignment="'.$image_alignment.'" image_width="'.$image_width.'" image_height="'.$image_height.'"]');
	}						
}


function meeek_about_me_shortcode($params, $content) {
    extract( shortcode_atts( 
      array(
        'settings'            => '',
        'about_us_image'        => '',
        'about_us_title'             =>'',
        'about_us_description'              =>'',
        'title_alignment'              =>'',
        'description_alignment'              =>'',
        'image_alignment'              =>'',
        'image_width'              =>'',
        'image_height'              =>'',
      ), $params ) );

    ob_start(); ?>

		<div class="meeek-about-me-container">
		    <div class="meeek-about-me-img-holder" style="text-align:<?php echo esc_attr($image_alignment); ?>">
		        <img src="<?php echo esc_url( $about_us_image ) ?>" width="<?php echo esc_attr( $image_width ); ?>px" height="<?php echo esc_attr( $image_height ); ?>px">
		    </div>
		    <div class="meeek-about-me-content">
		        <div class="meeek-about-me-inner-content">
		            <h2 class="meeek-about-me-title" style="text-align:<?php echo esc_attr($title_alignment); ?>">
		                <?php echo esc_html( $about_us_title, 'meeek');  ?>
		            </h2>
		            <p class="meeek-about-me-description" style="text-align:<?php echo esc_attr($description_alignment); ?>">
		                <?php echo esc_html( $about_us_description, 'meeek');  ?>
		            </p>
		        </div>
		    </div>
		</div>

    <?php
    return ob_get_clean();
}
add_shortcode('meeek-about-me', 'meeek_about_me_shortcode');