<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Meeek_Bio_Links extends \Elementor\Widget_Base { 
   /**
	 * Get widget name.
	 *
	 * Retrieve Card widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */

	public function get_name() {
		return 'bio links';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Card widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Meeek - Bio Links', 'meeek' );
	}

    /**
	 * Get widget icon.
	 *
	 * Retrieve Card widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-theme-builder';
	}

    /**
	 * Get custom help URL.
	 *
	 * Retrieve a URL where the user can get more information about the widget.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget help URL.
	 */
	public function get_custom_help_url() {
		return 'https://www.modeltheme.com/';
	}

    /**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Card widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'meeek-elementor-plugin' ];
	}

    /**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the Card widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'meeek', 'bio', 'links' ];
	}

	public function get_link() {
		return 'link';
	}
    /**
	 * Register Card widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */

	protected function register_controls() { 
		// our control function code goes here.

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content Section', 'meeek' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'version',
			[
				'label' => esc_html__( 'Version', 'meeek' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'v1',
				'options' => [
					'v1' => esc_html__( 'v1', 'meeek' ),
					'v2'  => esc_html__( 'v2', 'meeek' ),
					'v3' => esc_html__( 'v3', 'meeek' ),
					'v4' => esc_html__( 'v4', 'meeek' ),
					'v5' => esc_html__( 'v5', 'meeek' ),
					'v6' => esc_html__( 'v6', 'meeek' ),
					'v7' => esc_html__( 'v7', 'meeek' ),
					'v8' => esc_html__( 'v8', 'meeek' ),
				],
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'card_color',
			[
				'label' => esc_html__( 'Card Color', 'meeek' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .meeek-bio-links-inner-container-v5' => 'color: {{VALUE}}',
				],
			]
		);

		$repeater->add_control(
			'bio_links_image',
			[
				'label' => esc_html__( 'Image', 'meeek' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'meeek' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'meeek' ),
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'bio_links_description',
			[
				'label' => esc_html__( 'Description', 'meeek' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Your description goes here.', 'meeek' ),
				'default' => 'Basic Description and More',
			],
		);	

		$repeater->add_control(
            'padding_description',
            [
                'label' => esc_html__( 'Description Padding', 'meeek' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .meeek-bio-links-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'unit' => 'px',
                'size' => 150,
            ],
         ]
       );

		$repeater->add_control(
			'btn_title',
			[
				'label' => esc_html__( 'Button Text', 'meeek' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Button',
				'placeholder' => esc_html__( 'Type your title here', 'meeek' ),
			]
		);

		$repeater->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Button Color', 'meeek' ),
				'type' => \Elementor\Controls_Manager::COLOR,
			]
		);

		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'meeek' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'fa4compatibility' => 'social',
			]
		);

		$repeater->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'meeek' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#1e2330',
			]
		);

		$this->add_control( 
	        'list',
	        [
	            'label' => esc_html__('Menu Items', 'meeek'),
	            'type' => \Elementor\Controls_Manager::REPEATER,
	            'fields' => $repeater->get_controls(),
	            'default' => [
					[
						'bio_links_description' => esc_html__( 'Basic Description and More', 'meeek' ),
					],
					[
						'bio_links_description' => esc_html__( 'The Best Capussino Blends', 'meeek' ),
					],
					[
						'bio_links_description' => esc_html__( 'Arts: Sailing Rivers Painting', 'meeek' ),
					],
					[
						'bio_links_description' => esc_html__( 'One of the Fine Diamond', 'meeek' ),
					],
				],
	        ]
	    );

		$this->end_controls_section();
		
		$this->start_controls_section(
			'widget_promotion_section',
			array(
				'label' => esc_html__( 'Meeek SaaS (Upgrade)', 'meeek' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'widget_promotion',
			array(
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				/* translators: %s admin link */
				'raw'             => sprintf( esc_html__( ' %1$sMeeek SaaS for WordPress %2$s is now available options to monetize your bio links website and sell subscriptions to users.', 'meeek' ), '<a href="https://codecanyon.net/item/meeek-bio-links-saas-wordpress/46935773?utm_source=getmore&utm_medium=meeek-elementor-builder&utm_campaign=gopremium" target="_blank" rel="noopener">', '</a>' ),
				'content_classes' => 'meeek-elementor-admin-widget-promotion',
			)
		);
			

		$this->end_controls_section();
	}

    /**
	 * Render Card widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() { 

		// get our input from the widget settings.
		$settings = $this->get_settings_for_display();
		// get the individual values of the input
		$list = $settings['list'];
		$version = $settings['version'];
		?>

	<!-- Start rendering the output -->
		<?php if($version == "v1"){?>
			<div class="meeek-bio-links-container">
				<?php if ($list) {
					foreach ( $list as $item ) {
						$card_color = $item['card_color'];
						$bio_links_image = $item['bio_links_image'];
						$bio_links_description = $item['bio_links_description'];
		                $icon = $item['icon'];
		                $link = $item['link']['url'];
		                $btn_url = $item['btn_url'];
		                $btn_title = $item['btn_title'];
		                $icon_color = $item['icon_color'];
		                $button_color = $item['button_color'];

		                ?>   
		                <div class="meeek-bio-links-inner-container" style="background-color:<?php echo esc_attr($card_color)?>">
						    <div class="meeek-bio-links-img-holder">
						        <?php echo '<img src="' . esc_url( $item['bio_links_image']['url'] ) . '" alt="my-image">'; ?>
						    </div>
					        <div class="meeek-bio-links-description">
				                <?php echo esc_html($bio_links_description);  ?>
					        </div>
					        <div class="meeek-bio-links-inner-content ">				        	
					            <div class="meeek-bio-links-button" style="background:<?php echo esc_attr($button_color)?>">
					            	<?php if(!empty($btn_title)){ ?>
					                	<?php echo esc_html($btn_title) ?>
					                <?php } ?>
					                <?php if(!empty($icon)){ ?>
					                <div class="meeek-bio-links-icon" style="color:<?php echo esc_attr($icon_color)?>">   	
					            		<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
						            </div>
						            <?php } ?>
					            </div>				        	
					        </div>
					        <a target="_blank" href="<?php echo esc_url($link); ?>">
					        </a>
					    </div>
		        	<?php } ?>
				<?php } ?>
			</div>
		<?php } ?>
		<?php if($version == "v2"){?>
			<div class="meeek-bio-links-container meeek-bio-links-container-v2">
				<?php if ($list) {
					foreach ( $list as $item ) {
						$card_color = $item['card_color'];
						$bio_links_image = $item['bio_links_image'];
						$bio_links_description = $item['bio_links_description'];
		                $icon = $item['icon'];
		                $link = $item['link']['url'];
		                $btn_url = $item['btn_url'];
		                $btn_title = $item['btn_title'];
		                $icon_color = $item['icon_color'];
		                $button_color = $item['button_color'];

		                ?>   
		                <div class="meeek-bio-links-inner-container" style="background-color:<?php echo esc_attr($card_color)?>">
					        <div class="meeek-bio-links-description">
				                <?php echo esc_html($bio_links_description);  ?>
					        </div>
					        <div class="meeek-bio-links-inner-content">				        	
					            <div class="meeek-bio-links-button">
					                <div class="meeek-bio-links-icon" style="color:<?php echo esc_attr($icon_color)?>">   	
					            		<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
						            </div>
					            </div>				        	
					        </div>
					        <a class="meeek-bio-links-hover" target="_blank" href="<?php echo esc_url($link); ?>">
					        </a>
					    </div>
		        	<?php } ?>
				<?php } ?>
			</div>
		<?php } ?>
		<?php if($version == "v3"){?>
			<div class="meeek-bio-links-container meeek-bio-links-container-v3">
				<?php if ($list) {
					foreach ( $list as $item ) {
						$card_color = $item['card_color'];
						$bio_links_image = $item['bio_links_image'];
						$bio_links_description = $item['bio_links_description'];
		                $icon = $item['icon'];
		                $link = $item['link']['url'];
		                $btn_url = $item['btn_url'];
		                $btn_title = $item['btn_title'];
		                $icon_color = $item['icon_color'];
		                $button_color = $item['button_color'];

		                ?>   
		                <div class="meeek-bio-links-inner-container" style="background-color:<?php echo esc_attr($card_color)?>">
					        <div class="meeek-bio-links-inner-content">				        	
					            <div class="meeek-bio-links-button">
					                <div class="meeek-bio-links-icon" style="color:<?php echo esc_attr($icon_color)?>">   	
					            		<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
						            </div>
					            </div>				        	
					        </div>
					        <div class="meeek-bio-links-description">
				                <?php echo esc_html($bio_links_description);  ?>
					        </div>
					        <a class="meeek-bio-links-hover" target="_blank" href="<?php echo esc_url($link); ?>">
					        </a>
					    </div>
		        	<?php } ?>
				<?php } ?>
			</div>
		<?php } ?>
		<?php if($version == "v4"){?>
			<div class="meeek-bio-links-container meeek-bio-links-container-v4">
				<?php if ($list) {
					foreach ( $list as $item ) {
						$card_color = $item['card_color'];
						$bio_links_image = $item['bio_links_image'];
						$bio_links_description = $item['bio_links_description'];
		                $icon = $item['icon'];
		                $link = $item['link']['url'];
		                $btn_url = $item['btn_url'];
		                $btn_title = $item['btn_title'];
		                $icon_color = $item['icon_color'];
		                $button_color = $item['button_color'];

		                ?>   
		                <div class="meeek-bio-links-inner-container" style="background-color:<?php echo esc_attr($card_color)?>">
					        <div class="meeek-bio-links-description">
				                <?php echo esc_html($bio_links_description);  ?>
					        </div>
					        <div class="meeek-bio-links-inner-content">				        	
					            <div class="meeek-bio-links-button">
					                <div class="meeek-bio-links-icon" style="color:<?php echo esc_attr($icon_color)?>">   	
					            		<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
						            </div>
					            </div>				        	
					        </div>
					        <a class="meeek-bio-links-hover" target="_blank" href="<?php echo esc_url($link); ?>">
					        </a>
					    </div>
		        	<?php } ?>
				<?php } ?>
			</div>
		<?php } ?>
		<?php if($version == "v5"){?>
			<div class="meeek-bio-links-container meeek-bio-links-container-v5">
				<?php if ($list) {
					foreach ( $list as $item ) {
						$card_color = $item['card_color'];
						$bio_links_image = $item['bio_links_image'];
						$bio_links_description = $item['bio_links_description'];
		                $icon = $item['icon'];
		                $link = $item['link']['url'];
		                $btn_url = $item['btn_url'];
		                $btn_title = $item['btn_title'];
		                $icon_color = $item['icon_color'];
		                $button_color = $item['button_color'];

		                ?>   
		                <div class="meeek-bio-links-inner-container" style="background-color:<?php echo esc_attr($card_color)?>">
					        <div class="meeek-bio-links-description">
				                <?php echo esc_html($bio_links_description);  ?>
					        </div>
					        <div class="meeek-bio-links-inner-content">				        	
					            <div class="meeek-bio-links-button">
					                <div class="meeek-bio-links-icon" style="color:<?php echo esc_attr($icon_color)?>">   	
					            		<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
						            </div>
					            </div>				        	
					        </div>
					        <a class="meeek-bio-links-hover" target="_blank" href="<?php echo esc_url($link); ?>">
					        </a>
					    </div>
		        	<?php } ?>
				<?php } ?>
			</div>
		<?php } ?>
		<?php if($version == "v6"){?>
			<div class="meeek-bio-links-container meeek-bio-links-container-v6">
				<?php if ($list) {
					foreach ( $list as $item ) {
						$card_color = $item['card_color'];
						$bio_links_image = $item['bio_links_image'];
						$bio_links_description = $item['bio_links_description'];
		                $icon = $item['icon'];
		                $link = $item['link']['url'];
		                $btn_url = $item['btn_url'];
		                $btn_title = $item['btn_title'];
		                $icon_color = $item['icon_color'];
		                $button_color = $item['button_color'];

		                ?>   
		                <div class="meeek-bio-links-inner-container" style="background-color:<?php echo esc_attr($card_color)?>">
					        <div class="meeek-bio-links-description">
				                <?php echo esc_html($bio_links_description);  ?>
					        </div>
					        <div class="meeek-bio-links-inner-content">				        	
					            <div class="meeek-bio-links-button">
					                <div class="meeek-bio-links-icon" style="color:<?php echo esc_attr($icon_color)?>">   	
					            		<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
						            </div>
					            </div>				        	
					        </div>
					        <a class="meeek-bio-links-hover" target="_blank" href="<?php echo esc_url($link); ?>">
					        </a>
					    </div>
		        	<?php } ?>
				<?php } ?>
			</div>
		<?php } ?>
		<?php if($version == "v7"){?>
			<div class="meeek-bio-links-container meeek-bio-links-container-v7">
				<?php if ($list) {
					foreach ( $list as $item ) {
						$card_color = $item['card_color'];
						$bio_links_image = $item['bio_links_image'];
						$bio_links_description = $item['bio_links_description'];
		                $icon = $item['icon'];
		                $link = $item['link']['url'];
		                $btn_url = $item['btn_url'];
		                $btn_title = $item['btn_title'];
		                $icon_color = $item['icon_color'];
		                $button_color = $item['button_color'];

		                ?>   
		                <div class="meeek-bio-links-inner-container" style="background-color:<?php echo esc_attr($card_color)?>">
		                	<div class="meeek-bio-links-inner-content">				        	
					            <div class="meeek-bio-links-button">
					                <div class="meeek-bio-links-icon" style="color:<?php echo esc_attr($icon_color)?>">   	
					            		<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
						            </div>
					            </div>				        	
					        </div>
					        <div class="meeek-bio-links-description">
				                <?php echo esc_html($bio_links_description);  ?>
					        </div>
					        <a class="meeek-bio-links-hover" target="_blank" href="<?php echo esc_url($link); ?>">
					        </a>
					    </div>
		        	<?php } ?>
				<?php } ?>
			</div>
		<?php } ?>
		<?php if($version == "v8"){?>
			<div class="meeek-bio-links-container meeek-bio-links-container-v8">
				<?php if ($list) {
					foreach ( $list as $item ) {
						$card_color = $item['card_color'];
						$bio_links_image = $item['bio_links_image'];
						$bio_links_description = $item['bio_links_description'];
		                $icon = $item['icon'];
		                $link = $item['link']['url'];
		                $btn_url = $item['btn_url'];
		                $btn_title = $item['btn_title'];
		                $icon_color = $item['icon_color'];
		                $button_color = $item['button_color'];

		                ?>   
		                <div class="meeek-bio-links-inner-container" style="background-color:<?php echo esc_attr($card_color)?>">
						    <div class="meeek-bio-links-img-holder">
						        <?php echo '<img src="' . esc_url( $item['bio_links_image']['url'] ) . '" alt="my-image">'; ?>
						    </div>
					        <div class="meeek-bio-links-description">
				                <?php echo esc_html( $bio_links_description);  ?>
					        </div>
					        <div class="meeek-bio-links-inner-content">				        	
					            <div class="meeek-bio-links-button" style="background:<?php echo esc_attr($button_color)?>">
					            	<?php if(!empty($btn_title)){ ?>
					                	<?php echo esc_html($btn_title) ?>
					                <?php } ?>
					                <?php if(!empty($icon)){ ?>
					                <div class="meeek-bio-links-icon" style="color:<?php echo esc_attr($icon_color)?>">   	
					            		<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
						            </div>
						            <?php } ?>
					            </div>				        	
					        </div>
					        <a target="_blank" href="<?php echo esc_url($link); ?>">
					        </a>
					    </div>
		        	<?php } ?>
				<?php } ?>
			</div>
		<?php } ?>
	<!-- End rendering the output finally-->

<?php
	}						
}