<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Meeek_Social_Media_Links extends \Elementor\Widget_Base { 
   /**
	 * Get widget name.
	 *
	 * Retrieve Card widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */

	public function get_name() {
		return 'social media links';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Card widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Meeek - Social Media Links', 'meeek' );
	}

    /**
	 * Get widget icon.
	 *
	 * Retrieve Card widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-shape';
	}

    /**
	 * Get custom help URL.
	 *
	 * Retrieve a URL where the user can get more information about the widget.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget help URL.
	 */
	public function get_custom_help_url() {
		return 'https://www.modeltheme.com/';
	}

    /**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Card widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'meeek-elementor-plugin' ];
	}

    /**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the Card widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'meeek', 'social', 'media', 'links' ];
	}

	public function get_link() {
		return 'link';
	}
    /**
	 * Register Card widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */

	protected function register_controls() { 
		// our control function code goes here.

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Social Links', 'meeek' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Color', 'meeek' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .meeek-icon-link' => 'color: {{VALUE}}',
				],
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'meeek' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'fa4compatibility' => 'social',
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
			]
		);

		$this->add_control(
			'icons_alignment',
			[
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'label' => esc_html__( 'Icons Alignment', 'meeek' ),
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'meeek' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'meeek' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'meeek' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
			]
		);

	  $repeater->add_control(
            'link',
            [
                'label' => esc_html__( 'Link', 'meeek' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'meeek' ),
                'options' => [ 'url', 'is_external', 'nofollow' ],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

		$this->add_control( 
	        'list',
	        [
	            'label' => esc_html__('Add Social Links', 'meeek'),
	            'type' => \Elementor\Controls_Manager::REPEATER,
	            'fields' => $repeater->get_controls(),
	            'default' => [
					[
						'text' => esc_html__( 'List Item #1', 'meeek' ),
						'icon' => [
							'value' => 'fab fa-facebook',
							'library' => 'fa-solid',
						],
					],
					[
						'text' => esc_html__( 'List Item #2', 'meeek' ),
						'icon' => [
							'value' => 'fab fa-instagram',
							'library' => 'fa-solid',
						],
					],
					[
						'text' => esc_html__( 'List Item #3', 'meeek' ),
						'icon' => [
							'value' => 'fab fa-youtube',
							'library' => 'fa-solid',
						],
					],
					[
						'text' => esc_html__( 'List Item #4', 'meeek' ),
						'icon' => [
							'value' => 'fab fa-spotify',
							'library' => 'fa-solid',
						],
					],
					[
						'text' => esc_html__( 'List Item #5', 'meeek' ),
						'icon' => [
							'value' => 'fab fa-snapchat',
							'library' => 'fa-solid',
						],
					],
					[
						'text' => esc_html__( 'List Item #6', 'meeek' ),
						'icon' => [
							'value' => 'fab fa-linkedin',
							'library' => 'fa-solid',
						],
					],
					[
						'text' => esc_html__( 'List Item #7', 'meeek' ),
						'icon' => [
							'value' => 'fab fa-steam',
							'library' => 'fa-solid',
						],
					],
				],
	        ]
	    );
		
		$this->end_controls_section();

		$this->start_controls_section(
			'widget_promotion_section',
			array(
				'label' => esc_html__( 'Meeek SaaS (Upgrade)', 'meeek' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'widget_promotion',
			array(
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				/* translators: %s admin link */
				'raw'             => sprintf( esc_html__( ' %1$sMeeek SaaS for WordPress %2$s is now available options to monetize your bio links website and sell subscriptions to users.', 'meeek' ), '<a href="https://codecanyon.net/item/meeek-bio-links-saas-wordpress/46935773?utm_source=getmore&utm_medium=meeek-elementor-builder&utm_campaign=gopremium" target="_blank" rel="noopener">', '</a>' ),
				'content_classes' => 'meeek-elementor-admin-widget-promotion',
			)
		);
			

		$this->end_controls_section();

	}

    /**
	 * Render Card widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() { 

		// get our input from the widget settings.
		$settings = $this->get_settings_for_display();
		$list = $settings['list'];
		$icons_alignment = $settings['icons_alignment'];
		// get the individual values of the input
		
		?>

	<!-- Start rendering the output -->
		<div class="meeek-social-media-links-alignment" style="text-align:<?php echo esc_attr($icons_alignment); ?>">
			<div class="meeek-social-media-links-container">
			    <?php if ($list) {
					foreach ( $list as $item ) {
		                $icon = $item['icon'];
		                $link = $item['link']['url'];
		                ?>   
						<div class="meeek-social-media-links-inner-container">
							<a class="meeek-icon-link" target="_blank" href="<?php echo esc_url($link); ?>">
								<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
							</a>
						</div>
					<?php } ?>
				<?php } ?>
			</div>
		</div>
	<!-- End rendering the output finally-->

<?php
	}						
}