(function($){
    "use strict";

	window.addEventListener( 'elementor/init', () => {

		let newsFilters = elementor.modules.controls.BaseData.extend({

			optValue: {
				included: [],
				terms: [],
			},
			
			elValue: {
				filter: '',
				terms: [],
			},
			
			doAction: false,

			onReady() {
				console.log(this);
				console.log(this.getControlValue());
				console.log(this.getCurrentValue());

				this.reset();

				const dbValue = this.getCurrentValue();

				if ( typeof dbValue.filter !== "undefined" ) {
					this.elValue.filter = dbValue.filter;
				}

				if ( typeof dbValue.terms !== "undefined" ) {
					this.elValue.terms = dbValue.terms;

					this.startTermGet();
				}

				this.buildControls();
			},

			buildControls() {
				this.buildRender();
				this.buildSelect();
				this.buildFind();
				this.buildDisplay();
			},

			buildSelect() {
				let that = this;

				const selectEl = $('<select id="xelnews-filters-'+this.model.cid+'" class="xelnews-filters" />');
				const filtersOpt = this.model.get('filters');
				for (let i in filtersOpt) {
					if (filtersOpt.hasOwnProperty(i)) {
						const optionEl = $('<option value="'+i+'"'+(this.elValue.filter===i?" selected":"")+'>'+filtersOpt[i]+'</option>')
						selectEl.append(optionEl);
					}
				}
				selectEl.bind('change', (e,i) => {
					that.reset();

					that.elValue.filter = selectEl.val();
					that.emptyAfterSelect();
				});
				this.$el.find('.elementor-control-input-wrapper:first').append(selectEl);
			},

			emptyAfterSelect() {
				this.$el.find('.xelnews-render').empty();
				this.$el.find('.xelnews-find-terms').val('');
				this.$el.find('.xelnews-display').empty();
			},

			buildFind() {
				let that = this;

				const findEl = $('<input id="xelnews-find-terms-'+this.model.cid+'" class="xelnews-find-terms" type="text" placeholder="Search terms" />');
				findEl.bind('keyup', () => {
					if ( that.doAction ) {
						clearTimeout( that.doAction );
					}

					this.doAction = setTimeout( function() {
						that.startTermFind();
					}, 250 );
				});
				const findControl =  $('<div class="elementor-control-field" />').append(findEl);

				this.$el.find('.elementor-control-content:first').append(findControl);
			},

			buildDisplay() {
				const displayEl = $('<div id="xelnews-display-'+this.model.cid+'" class="xelnews-display" />');
				const displayControl =  $('<div class="elementor-control-field" />').append(displayEl);

				this.$el.find('.elementor-control-content:first').append(displayControl);
			},

			buildRender() {
				const renderEl = $('<div id="xelnews-render-'+this.model.cid+'" class="xelnews-render" />');
				const renderControl =  $('<div class="elementor-control-field" />').append(renderEl);

				this.$el.find('.elementor-control-content:first').append(renderControl);
			},

			reset() {

				this.optValue =  {
					included: [],
					terms: [],
				};
				
				this.elValue = {
					filter: '',
					terms: [],
				};
			},

			addTerm(id,name) {
				if ( !this.optValue.included.includes(id) ) {
					this.optValue.included.push(id);
					this.optValue.terms.push({
						'id' : id,
						'name' : name,
						'operation' : 'include',
					});
				}

				this.rebuild();
				this.saveValue();
			},

			rebuildElValue() {
				console.log(this.elValue);
				this.elValue.terms = [];
				for (let i in this.optValue.terms) {
					if (this.optValue.terms.hasOwnProperty(i)) {
						this.elValue.terms.push((this.optValue.terms[i].operation==='exclude'?-1:1)*this.optValue.terms[i].id);
					}
				}
			},

			buildOptValues(r) {
				this.optValue.terms = [];
				for (let i in this.elValue.terms) {
					if (this.elValue.terms.hasOwnProperty(i)) {
						const id = Math.abs(this.elValue.terms[i]);
						this.optValue.included.push(id),
						this.optValue.terms.push({
							'id': id,
							'name': r.terms[id],
							'operation': this.elValue.terms[i][0] === '-' ? 'exclude': 'include',
						});
					}
				}
			},

			renderTerms() {
				let renderContainer = this.$el.find('.xelnews-render');
				renderContainer.empty();

				for (let i in this.optValue.terms) {
					if (this.optValue.terms.hasOwnProperty(i)) {
						let entry = $('<div />');

						entry.append(this.optValue.terms[i].name);
						
						const includeButton = this.getTermIncludeButton(this.optValue.terms[i].id, this.optValue.terms[i].operation);
						const excludeButton = this.getTermExcludeButton(this.optValue.terms[i].id, this.optValue.terms[i].operation);
						const removeButton = this.getTermRemoveButton(this.optValue.terms[i].id);

						includeButton.bind( 'click', () => {
							return this.includeTerm(this.optValue.terms[i].id);
						});
						
						excludeButton.bind( 'click', () => {
							return this.excludeTerm(this.optValue.terms[i].id);
						});

						removeButton.bind( 'click', () => {
							return this.removeTerm(this.optValue.terms[i].id);
						});

						entry.append(includeButton);
						entry.append(excludeButton);
						entry.append(removeButton);
						
						renderContainer.append(entry);
					}
				}
			},

			includeTerm(id) {
				const index = this.optValue.included.indexOf(id);
				if ( index > -1 ) {
					this.optValue.terms[index].operation = 'include';

					this.rebuild();
					this.saveValue();
				}
			},

			excludeTerm(id) {
				const index = this.optValue.included.indexOf(id);
				if ( index > -1 ) {
					this.optValue.terms[index].operation = 'exclude';

					this.rebuild();
					this.saveValue();
				}
			},
			
			removeTerm(id) {
				const index = this.optValue.included.indexOf(id);
				if ( index > -1 ) {
					this.optValue.included.splice(index, 1);
					this.optValue.terms.splice(index, 1);

					this.rebuild();
					this.saveValue();
				}
			},

			rebuild() {
				this.rebuildElValue();
				this.renderTerms();	
			},

			startTermGet() {
				console.log('finding');
				this.ajaxOn = 'active';

				const s = {
					action: 'get',
					filter: this.elValue.filter,
					terms: this.elValue.terms,
				}

				let that = this;
				$.when( this._ajax(s) ).done( function(r) {
					console.log(r);
					that.buildOptValues(r);
					that.renderTerms();
				} );
			},

			startTermFind() {
				console.log('searching');
				this.ajaxOn = 'active';

				const s = {
					action: 'find',
					filter: this.$el.find('.xelnews-filters').val(),
					input: this.$el.find('.xelnews-find-terms').val(),
				}

				let that = this;
				$.when( this._ajax(s) ).done( function(r) {
					console.log(r);
					that.buildResults(r);
				} );
			},

			getTermAddButton(id) {
				return $('<a href="javascript:void(0)" class="xelnews-add-term" data-term="'+id+'">+</a>');
			},

			getTermIncludeButton(id,operation) {
				const addClass = 'include' === operation ? " xelnews-active" : "";
				return $('<a href="javascript:void(0)" class="xelnews-include-term'+addClass+'" data-term="'+id+'">Include</a>');
			},
			
			getTermExcludeButton(id,operation) {
				const addClass = 'exclude' === operation ? " xelnews-active" : "";
				return $('<a href="javascript:void(0)" class="xelnews-exclude-term'+addClass+'" data-term="'+id+'">Exclude</a>');
			},

			getTermRemoveButton(id) {
				return $('<a href="javascript:void(0)" class="xelnews-remove-term" data-term="'+id+'">X</a>');
			},

			buildResults(r) {
				let displayContainer = this.$el.find('.xelnews-display');
				displayContainer.empty();

				let elements = [];
				for (let i in r.terms) {
					if (r.terms.hasOwnProperty(i)) {
						let add = $('<div />');
						add.append(r.terms[i]);
						const addButton = this.getTermAddButton(i);
						addButton.bind('click', () => {
							this.addTerm(i,r.terms[i])
						});
						add.append(addButton);

						elements.push(add);
					}
				}
				displayContainer.append(elements);
			},

			buildValues() {
				this.$el.find('.xelnews-filters').val(this.elValue.filter).change();
			},

			saveValue() {
				console.log(this.elValue);
				this.setValue(this.elValue);
			},

			onBeforeDestroy() {
				this.saveValue();
			},

			ajaxOn : false,

			_ajax(s) {
				var data = {
					action: 'xelnews_respond',
					nonce: xelnews.nonce,
					xelnews: s,
				};
		
				return $.ajax( {
					type: 'POST',
					url: xelnews.ajax,
					data: data,
					success: function(r) {
						this.ajaxOn = false;
					},
					error: function() {
						alert( 'AJAX Error!' );
						this.ajaxOn = false;
					}
				} );
			}
		});

		elementor.addControlView( 'xelnews_filter', newsFilters );
	} );

})(jQuery);