<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Repeater;

class XElNews_Core {

	// Get Elementor widget controls
	public static function get_elementor_settings( &$_this ) {
		if ( ! empty( $_this ) ) {
			switch ( $_this->get_name() ) {
				case 'xel-news-grid':
					self::news_grid_setup( $_this );
					break;
				case 'xel-news-list':
					self::news_list_setup( $_this );
					break;
				case 'xel-news-list-featured':
					self::news_list_featured_setup( $_this );
					break;
				case 'xel-news-inline':
					self::news_inline_setup( $_this );
					break;
				case 'xel-news-poster':
					self::news_poster_setup( $_this );
					break;
				case 'xel-news-text':
					self::news_text_setup( $_this );
					break;
				case 'xel-news-ticker':
					self::news_ticker_setup( $_this );
					break;
				case 'xel-news-carousel':
					self::news_carousel_setup( $_this );
					break;
				case 'xel-news-slider':
					self::news_slider_setup( $_this );
					break;
				case 'xel-news-tabs':
					self::news_tabs_setup( $_this );
					break;
				default:
					break;
			}
		}
	}

	/* xel-news-grid
	 * Add controls to XElNews Grid Elementor widget.
	 */
	static function news_grid_setup( &$_this ) {
		self::get_columns_controls( $_this );
		self::get_posts_query_controls( $_this );
		self::get_posts_filter_controls( $_this );
		self::get_pagination_controls( $_this );
		self::get_extra_controls( $_this );

		self::get_post_style_controls( $_this );
		self::get_pagination_style_controls( $_this );
		self::get_container_style_controls( $_this );
	}

	/* xel-news-list
	 * Add controls to XElNews List Elementor widget.
	 */
	static function news_list_setup( &$_this ) {
		self::get_posts_query_controls( $_this );
		self::get_posts_filter_controls( $_this );
		self::get_pagination_controls( $_this );
		self::get_extra_controls( $_this );

		self::get_post_style_controls( $_this );
		self::get_pagination_style_controls( $_this );
		self::get_container_style_controls( $_this );
	}

	/* xel-news-list-featured
	 * Add controls to XElNews List Elementor widget.
	 */
	static function news_list_featured_setup( &$_this ) {
		self::get_posts_query_controls( $_this );
		self::get_posts_filter_controls( $_this );
		self::get_extra_controls( $_this );

		self::get_post_style_controls( $_this );
		self::get_post2_style_controls( $_this );
		self::get_container_style_controls( $_this );
	}

	/* xel-news-inline
	 * Add controls to XElNews List Elementor widget.
	 */
	static function news_inline_setup( &$_this ) {
		self::get_posts_query_controls( $_this );
		self::get_posts_filter_controls( $_this );
		self::get_pagination_controls( $_this );
		self::get_extra_controls( $_this );

		self::get_post_style_controls( $_this );
		self::get_pagination_style_controls( $_this );
		self::get_container_style_controls( $_this );
	}

	/* xel-news-poster
	 * Add controls to XElNews Poster Elementor widget.
	 */
	static function news_poster_setup( &$_this ) {
		self::get_posts_query_controls( $_this );
		self::get_posts_filter_controls( $_this );
		self::get_extra_controls( $_this );

		self::get_post_style_controls( $_this );
		self::get_container_style_controls( $_this );
	}
	/* xel-news-text
	* Add controls to XElNews Text Elementor widget.
	*/
	static function news_text_setup( &$_this ) {
		self::get_posts_query_controls( $_this );
		self::get_posts_filter_controls( $_this );
		self::get_pagination_controls( $_this );
		self::get_extra_controls( $_this );

		self::get_post_text_style_controls( $_this );
		self::get_pagination_style_controls( $_this );
		self::get_container_style_controls( $_this );
	}

	/* xel-news-ticker
		* Add controls to XElNews Ticker Elementor widget.
		*/
	static function news_ticker_setup( &$_this ) {
		self::get_ticker_controls( $_this );
		self::get_posts_query_controls( $_this );
		self::get_posts_filter_controls( $_this );
		self::get_extra_controls( $_this );

		self::get_post_style_controls( $_this );
		self::get_container_style_controls( $_this );
	}

	/* xel-news-carousel
		* Add controls to XElNews Carousel Elementor widget.
		*/
	static function news_carousel_setup( &$_this ) {
		self::get_posts_query_controls( $_this );
		self::get_posts_filter_controls( $_this );
		self::get_extra_controls( $_this );

		self::get_post_style_controls( $_this );
		self::get_nav_style_controls( $_this );
		self::get_container_style_controls( $_this );
	}

	/* xel-news-slider
	* Add controls to XElNews Slider Elementor widget.
	*/
	static function news_slider_setup( &$_this ) {
		self::get_slider_controls( $_this );
		self::get_posts_query_controls( $_this );
		self::get_posts_filter_controls( $_this );
		self::get_extra_controls( $_this );

		self::get_post_style_controls( $_this );
		self::get_nav_alt_style_controls( $_this );
		self::get_container_style_controls( $_this );
	}

	/* xel-news-tabs
	* Add controls to XElNews Tabs Elementor widget.
	*/
	static function news_tabs_setup( &$_this ) {
		self::get_tab_controls( $_this );
		self::get_extra_controls( $_this );

		self::get_post_style_controls( $_this );
		self::get_nav_style_controls( $_this );
		self::get_container_style_controls( $_this );
	}

	// Get element style controls
	static function get_item_style_controls_tab( &$_this, $n = '' ) {
		$_this->start_controls_tab(
			'xelnews_styles_item' . $n,
			array(
				'label' => esc_html__( 'Item', 'xel-news' ),
			)
		);

		self::get_gap_controls( $_this, 'item' . $n );
		self::get_dimensions_controls( $_this, 'item' . $n );
		self::get_divider( $_this, 'before_item_background' . $n );
		self::get_background( $_this, 'item' . $n );
		self::get_divider( $_this, 'before_item_border' . $n );
		self::get_border( $_this, 'item' . $n );
		self::get_divider( $_this, 'before_item_shadow' . $n );
		self::get_shadow( $_this, 'item' . $n );

		$_this->end_controls_tab();
	}

	// Get element style controls
	static function get_post_style_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_post',
			array(
				'label' => esc_html__( 'Post', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$_this->start_controls_tabs( 'xelnews_post_styles' );

		self::get_item_style_controls_tab( $_this );
		self::get_heading_style_controls_tab( $_this );
		self::get_excerpt_style_controls_tab( $_this );
		self::get_meta_style_controls_tab( $_this );
		self::get_image_style_controls_tab( $_this );

		$_this->end_controls_tabs();

		$_this->end_controls_section();
	}

	// Get element text style controls
	static function get_post_text_style_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_post',
			array(
				'label' => esc_html__( 'Post', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$_this->start_controls_tabs( 'xelnews_post_styles' );

		self::get_item_style_controls_tab( $_this );
		self::get_heading_style_controls_tab( $_this );

		$_this->end_controls_tabs();

		$_this->end_controls_section();
	}

	// Get element style controls
	static function get_post2_style_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_post2',
			array(
				'label' => esc_html__( 'Post alt', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$_this->start_controls_tabs( 'xelnews_post2_styles' );

		self::get_item_style_controls_tab( $_this, 2 );
		self::get_heading_style_controls_tab( $_this, 2 );
		self::get_excerpt_style_controls_tab( $_this, 2 );
		self::get_meta_style_controls_tab( $_this, 2 );
		self::get_image_style_controls_tab( $_this, 2 );

		$_this->end_controls_tabs();

		$_this->end_controls_section();
	}

	// Get controls divider
	static function get_divider( &$_this, $name ) {
		$_this->add_control(
			'xelnews_' . $name,
			array(
				'type' => \Elementor\Controls_Manager::DIVIDER,
			)
		);
	}

	// Get background controls
	static function get_background( &$_this, $placement ) {
		$_this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			array(
				'name'     => 'xelnews_' . $placement . '_background',
				'label'    => esc_html__( 'Background', 'xel-news' ),
				'types'    => array( 'classic', 'gradient', 'video' ),
				'selector' => self::get_placement_selector( $placement ),
			)
		);
	}

	// Get shadow controls
	static function get_shadow( &$_this, $placement ) {
		$_this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'xelnews_' . $placement . '_box_shadow',
				'selector' => self::get_placement_selector( $placement ),
			)
		);
	}

	// Get border controls
	static function get_border( &$_this, $placement ) {
		$_this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			array(
				'name'     => 'xelnews_' . $placement . '_border',
				'label'    => esc_html__( 'Border', 'xel-news' ),
				'selector' => self::get_placement_selector( $placement ),
			)
		);

		$_this->add_responsive_control(
			'xelnews_' . $placement . '_border_radius',
			array(
				'label'      => esc_html__( 'Border radius', 'xel-news' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					self::get_placement_selector( $placement ) => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
	}

	// Get shadow controls
	static function get_shadow_image( &$_this, $placement ) {
		$_this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'xelnews_' . $placement . '_box_shadow_image',
				'selector' => self::get_placement_selector( $placement, '.xelnews-image' ),
			)
		);
	}

	// Get border controls
	static function get_border_image( &$_this, $placement ) {
		$_this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			array(
				'name'     => 'xelnews_' . $placement . '_border_image',
				'label'    => esc_html__( 'Border', 'xel-news' ),
				'selector' => self::get_placement_selector( $placement, '.xelnews-image' ),
			)
		);

		$_this->add_responsive_control(
			'xelnews_' . $placement . '_border_radius_image',
			array(
				'label'      => esc_html__( 'Border radius', 'xel-news' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					self::get_placement_selector( $placement, '.xelnews-image' ) => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
	}

	// Get nav style controls
	static function get_nav_alt_style_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_nav',
			array(
				'label' => esc_html__( 'Nav', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$_this->start_controls_tabs( 'nav_styles' );

		$_this->start_controls_tab(
			'xelnews_styles_nav_button',
			array(
				'label' => esc_html__( 'Button', 'xel-news' ),
			)
		);

		self::get_buttons_style_controls( $_this, 'nav' );

		$_this->end_controls_tab();

		$_this->end_controls_tabs();

		$_this->end_controls_section();
	}

	// Get nav style controls
	static function get_nav_style_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_nav',
			array(
				'label' => esc_html__( 'Nav', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$_this->start_controls_tabs( 'nav_styles' );

		$_this->start_controls_tab(
			'xelnews_styles_nav_container',
			array(
				'label' => esc_html__( 'Container', 'xel-news' ),
			)
		);

		self::get_custom_container_style_controls( $_this, 'nav' );

		$_this->end_controls_tab();

		$_this->start_controls_tab(
			'xelnews_styles_nav_button',
			array(
				'label' => esc_html__( 'Button', 'xel-news' ),
			)
		);

		self::get_buttons_style_controls( $_this, 'nav' );

		$_this->end_controls_tab();

		$_this->end_controls_tabs();

		$_this->end_controls_section();
	}

	// Get nav style controls
	static function get_pagination_style_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_pagination_section',
			array(
				'label' => esc_html__( 'Pagination', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$_this->start_controls_tabs( 'pagination_styles' );

		$_this->start_controls_tab(
			'xelnews_styles_pagination_container',
			array(
				'label' => esc_html__( 'Container', 'xel-news' ),
			)
		);

		// Alignment
		$_this->add_responsive_control(
			'xelnews_pagination_button_align',
			array(
				'label'       => esc_html__( 'Alignment', 'xel-news' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'flex-start' => array(
						'title' => esc_html__( 'Left', 'xel-news' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center'     => array(
						'title' => esc_html__( 'Center', 'xel-news' ),
						'icon'  => 'eicon-text-align-center',
					),
					'flex-end'   => array(
						'title' => esc_html__( 'Right', 'xel-news' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'selectors'   => array(
					self::get_placement_selector( 'pagination' ) => 'justify-content: {{xelnews_pagination_button_align}};',
				),
				'toggle'      => true,
				'label_block' => false,
			)
		);

		self::get_custom_container_style_controls( $_this, 'pagination' );

		$_this->end_controls_tab();

		$_this->start_controls_tab(
			'xelnews_styles_pagination_buttons',
			array(
				'label' => esc_html__( 'Buttons', 'xel-news' ),
			)
		);

		self::get_buttons_style_controls( $_this, 'pagination' );

		$_this->end_controls_tab();

		$_this->end_controls_tabs();

		$_this->end_controls_section();
	}

	// Get container style controls
	static function get_custom_container_style_controls( &$_this, $placement ) {
		self::get_background( $_this, $placement );
		self::get_border( $_this, $placement );
		self::get_shadow( $_this, $placement );
		self::get_dimensions_controls( $_this, $placement );
	}

	// Get container style controls
	static function get_buttons_style_controls( &$_this, $placement ) {
		// Color
		$_this->add_control(
			'xelnews_' . $placement . '_button_color',
			array(
				'label'     => esc_html__( 'Color', 'xel-news' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					self::get_placement_selector( $placement . '_button' ) => 'color: {{VALUE}}',
				),
			)
		);

		// Hover
		$_this->add_control(
			'xelnews_' . $placement . '_button_color_hover',
			array(
				'label'     => esc_html__( 'Hover', 'xel-news' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					self::get_placement_selector( $placement . '_button', ':hover' ) => 'color: {{VALUE}}',
					self::get_placement_selector( $placement . '_button_active' ) => 'color: {{VALUE}}',
				),
			)
		);

		// Typography
		$_this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'xelnews_' . $placement . '_button_typography',
				'label'    => esc_html__( 'Typography', 'xel-news' ),
				'selector' => self::get_placement_selector( $placement . '_button' ),
			)
		);

		// Shadow
		$_this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			array(
				'name'     => 'xelnews_' . $placement . '_button_shadow',
				'label'    => esc_html__( 'Shadow', 'xel-news' ),
				'selector' => self::get_placement_selector( $placement . '_button' ),
			)
		);

		// Background
		$_this->add_control(
			'xelnews_' . $placement . '_button_background_color',
			array(
				'label'     => esc_html__( 'Background', 'xel-news' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					self::get_placement_selector( $placement . '_button' ) => 'background-color: {{VALUE}}',
				),
			)
		);

			// Background
			$_this->add_control(
				'xelnews_' . $placement . '_button_background_hover_color',
				array(
					'label'     => esc_html__( 'Hover', 'xel-news' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						self::get_placement_selector( $placement . '_button', ':hover' ) => 'background-color: {{VALUE}}',
						self::get_placement_selector( $placement . '_button_active' ) => 'background-color: {{VALUE}}',
					),
				)
			);

		self::get_border( $_this, $placement . '_button' );
		self::get_shadow( $_this, $placement . '_button' );
		self::get_dimensions_controls( $_this, $placement . '_button' );
	}

	// Get container style controls
	static function get_container_style_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_container',
			array(
				'label' => esc_html__( 'Container', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$_this->start_controls_tabs( 'container_styles' );

		self::get_dimensions_controls( $_this, 'posts_container' );
		self::get_divider( $_this, 'before_background' );
		self::get_background( $_this, 'posts_container' );
		self::get_divider( $_this, 'before_border' );
		self::get_border( $_this, 'posts_container' );
		self::get_divider( $_this, 'before_shadow' );
		self::get_shadow( $_this, 'posts_container' );

		$_this->end_controls_tabs();

		$_this->end_controls_section();
	}

	// Get style heading controls
	static function get_heading_style_controls_tab( &$_this, $n = '' ) {
		$_this->start_controls_tab(
			'xelnews_styles_heading' . $n,
			array(
				'label' => esc_html__( 'H2', 'xel-news' ),
			)
		);

		self::get_text_heading_style_controls( $_this, 'heading' . $n );

		$_this->end_controls_tab();
	}

	// Get style excerpt controls
	static function get_excerpt_style_controls_tab( &$_this, $n = '' ) {
		$_this->start_controls_tab(
			'xelnews_styles_excerpt' . $n,
			array(
				'label' => esc_html__( 'Exc', 'xel-news' ),
			)
		);

		self::get_excerpt_style_controls( $_this, 'excerpt' . $n );

		$_this->end_controls_tab();
	}

	// Get style meta controls
	static function get_meta_style_controls_tab( &$_this, $n = '' ) {
		$_this->start_controls_tab(
			'xelnews_styles_meta' . $n,
			array(
				'label' => esc_html__( 'Meta', 'xel-news' ),
			)
		);

		self::get_meta_style_controls( $_this, 'meta' . $n );

		$_this->end_controls_tab();
	}

	// Get style image controls
	static function get_image_style_controls_tab( &$_this, $n = '' ) {
		$_this->start_controls_tab(
			'xelnews_styles_image' . $n,
			array(
				'label' => esc_html__( 'Img', 'xel-news' ),
			)
		);

		if ( 'xel-news-list' === $_this->get_name() ) {
			$_this->add_responsive_control(
				'xelnews_image_width' . $n,
				array(
					'label'     => esc_html__( 'Image width', 'xel-news' ),
					'type'      => \Elementor\Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 640,
							'step' => 1,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
						'em' => array(
							'min'  => 0,
							'max'  => 40,
							'step' => 0.1,
						),
					),
					'default'   => array(
						'unit' => 'px',
						'size' => 240,
					),
					'selectors' => array(
						'{{WRAPPER}} .xelnews-image-wrapper' => 'min-width: {{SIZE}}{{UNIT}};max-width:none;',
					),
				),
			);
		}

		$_this->add_control(
			'xelnews_image_ratio' . $n,
			array(
				'label'       => esc_html__( 'Ratio', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => self::get_image_ratio_array(),
				'default'     => '4-3',
				'description' => esc_html__( 'Set image ratio', 'xel-news' ),
			)
		);

		$_this->add_control(
			'xelnews_image_size' . $n,
			array(
				'label'       => esc_html__( 'Size', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => self::get_image_sizes_array(),
				'description' => esc_html__( 'Set image size to use (file)', 'xel-news' ),
			)
		);

		self::get_dimensions_controls( $_this, 'image' . $n );
		self::get_background( $_this, 'image' . $n );
		self::get_border( $_this, 'image' . $n );
		self::get_shadow( $_this, 'image' . $n );
		//self::get_divider( $_this, 'before_image_inner_controls' );

		// Margin
		$_this->add_responsive_control(
			'xelnews_image' . $n . '_margin_image',
			array(
				'label'      => esc_html__( 'Margin', 'xel-news' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					self::get_placement_selector( 'image' . $n, '.xelnews-image' ) => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		self::get_border_image( $_this, 'image' . $n );
		self::get_shadow_image( $_this, 'image' . $n );

		$_this->end_controls_tab();
	}

	// Get meta compares
	static function get_meta_compares() {
		return array(
			'='           => '=',
			'!='          => '!=',
			'>'           => '>',
			'>='          => '>=',
			'<'           => '<',
			'<='          => '<=',
			'LIKE'        => 'LIKE',
			'NOT LIKE'    => 'NOT LIKE',
			'IN'          => 'IN',
			'NOT IN'      => 'NOT IN',
			'BETWEEN'     => 'BETWEEN',
			'NOT BETWEEN' => 'NOT BETWEEN',
			'EXISTS'      => 'EXISTS',
			'NOT EXISTS'  => 'NOT EXISTS',
		);
	}

	// Get meta types
	static function get_meta_types() {
		return array(
			'NUMERIC'  => 'NUMERIC',
			'BINARY'   => 'BINARY',
			'CHAR'     => 'CHAR',
			'DATE'     => 'DATE',
			'DATETIME' => 'DATETIME',
			'DECIMAL'  => 'DECIMAL',
			'SIGNED'   => 'SIGNED',
			'TIME'     => 'TIME',
			'UNSIGNED' => 'UNSIGNED',
		);
	}

	// Get image ratio array
	static function get_image_ratio_array() {
		return array(
			'1-1'  => '1 : 1',
			'2-1'  => '2 : 1',
			'1-2'  => '1 : 2',
			'3-1'  => '3 : 1',
			'1-3'  => '1 : 3',
			'4-3'  => '4 : 3',
			'3-4'  => '3 : 4',
			'16-9' => '16 : 9',
			'9-16' => '9 : 16',
			'5-3'  => '5 : 3',
			'3-5'  => '3 : 5',
		);
	}

	// Get image size array
	static function get_image_sizes_array() {
		$choices_image_size = array(
			''     => esc_html__( 'Default', 'xel-news' ),
			'full' => esc_html__( 'Full', 'xel-news' ),
		);

		$image_sizes = get_intermediate_image_sizes();

		foreach ( $image_sizes as $image_size ) {
			$choices_image_size[ $image_size ] = $image_size;
		}

		return $choices_image_size;
	}

	static function get_placement_selector( $placement, $add = '' ) {
		$selector = '';
		if ( ! empty( $add ) ) {
			$add = ':' === $add[0] ? $add : ' ' . $add;
		}
		switch ( $placement ) {
			case 'meta':
				$selector = '.xelnews-meta';
				break;
			case 'meta2':
				$selector = '.xelnews-meta2';
				break;
			case 'nav':
				$selector = '.xelnews-nav';
				break;
			case 'nav_button':
				$selector = '.xelnews-navitem';
				break;
			case 'nav_button_active':
				$selector = '.xelnews-navitem.xelnews-active';
				break;
			case 'item':
				$selector = '.xelnews-item';
				break;
			case 'item2':
				$selector = '.xelnews-item2';
				break;
			case 'posts_container':
				$selector = '.xelnews-container';
				break;
			case 'image':
				$selector = '.xelnews-image-wrapper';
				break;
			case 'image2':
				$selector = '.xelnews-image-wrapper2';
				break;
			case 'heading':
				$selector = '.xelnews-heading';
				break;
			case 'heading2':
				$selector = '.xelnews-heading2';
				break;
			case 'excerpt2':
				$selector = '.xelnews-excerpt2';
				break;
			case 'pagination':
				$selector = '.xelnews-pagination';
				break;
			case 'pagination_button':
				$selector = '.xelnews-pagination span';
				break;
			case 'pagination_button_active':
				$selector = '.xelnews-pagination span.xelnews-current';
				break;
			case 'excerpt':
			default:
				$selector = '.xelnews-excerpt';
				break;
		}

		return '{{WRAPPER}} ' . $selector . $add;
	}

	static function get_excerpt_style_controls( &$_this, $placement ) {
		// Color
		$_this->add_control(
			'xelnews_' . $placement . '_color',
			array(
				'label'     => esc_html__( 'Color', 'xel-news' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					self::get_placement_selector( $placement ) => 'color: {{VALUE}}',
				),
			)
		);

		// Typography
		$_this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'xelnews_' . $placement . '_typography',
				'label'    => esc_html__( 'Typography', 'xel-news' ),
				'selector' => self::get_placement_selector( $placement ),
			)
		);

		// Shadow
		$_this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			array(
				'name'     => 'xelnews_' . $placement . '_shadow',
				'label'    => esc_html__( 'Shadow', 'xel-news' ),
				'selector' => self::get_placement_selector( $placement ),
			)
		);

		// Alignment
		$_this->add_responsive_control(
			'xelnews_' . $placement . '_align',
			array(
				'label'       => esc_html__( 'Alignment', 'xel-news' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'xel-news' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'xel-news' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'xel-news' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'selectors'   => array(
					self::get_placement_selector( $placement ) => 'text-align: {{xelnews_' . $placement . '_align}};',
				),
				'toggle'      => true,
				'label_block' => false,
			)
		);

		self::get_dimensions_controls( $_this, $placement );
	}

	static function get_meta_style_controls( &$_this, $placement ) {
		// Color
		$_this->add_control(
			'xelnews_' . $placement . '_color',
			array(
				'label'     => esc_html__( 'Color', 'xel-news' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					self::get_placement_selector( $placement ) => 'color: {{VALUE}}',
				),
			)
		);

		// Typography
		$_this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'xelnews_' . $placement . '_typography',
				'label'    => esc_html__( 'Typography', 'xel-news' ),
				'selector' => self::get_placement_selector( $placement ),
			)
		);

		// Shadow
		$_this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			array(
				'name'     => 'xelnews_' . $placement . '_shadow',
				'label'    => esc_html__( 'Shadow', 'xel-news' ),
				'selector' => self::get_placement_selector( $placement ),
			)
		);

		// Alignment
		$_this->add_responsive_control(
			'xelnews_' . $placement . '_align',
			array(
				'label'       => esc_html__( 'Alignment', 'xel-news' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'flex-start' => array(
						'title' => esc_html__( 'Left', 'xel-news' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center'     => array(
						'title' => esc_html__( 'Center', 'xel-news' ),
						'icon'  => 'eicon-text-align-center',
					),
					'flex-end'   => array(
						'title' => esc_html__( 'Right', 'xel-news' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'selectors'   => array(
					self::get_placement_selector( $placement ) => 'justify-content: {{xelnews_' . $placement . '_align}};',
				),
				'toggle'      => true,
				'label_block' => false,
			)
		);

		self::get_dimensions_controls( $_this, $placement );
	}

	static function get_text_heading_style_controls( &$_this, $placement ) {
		// Color
		$_this->add_control(
			'xelnews_' . $placement . '_color',
			array(
				'label'     => esc_html__( 'Color', 'xel-news' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					self::get_placement_selector( $placement, 'a' ) => 'color: {{VALUE}}',
				),
			)
		);

		// Hover
		$_this->add_control(
			'xelnews_' . $placement . '_color_hover',
			array(
				'label'     => esc_html__( 'Hover', 'xel-news' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					self::get_placement_selector( $placement, 'a:hover' ) => 'color: {{VALUE}}',
				),
			)
		);

		// Typography
		$_this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'xelnews_' . $placement . '_typography',
				'label'    => esc_html__( 'Typography', 'xel-news' ),
				'selector' => self::get_placement_selector( $placement ),
			)
		);

		// Shadow
		$_this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			array(
				'name'     => 'xelnews_' . $placement . '_shadow',
				'label'    => esc_html__( 'Shadow', 'xel-news' ),
				'selector' => self::get_placement_selector( $placement, 'a' ),
			)
		);

		// Alignment
		$_this->add_responsive_control(
			'xelnews_' . $placement . '_align',
			array(
				'label'       => esc_html__( 'Alignment', 'xel-news' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'xel-news' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'xel-news' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'xel-news' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'selectors'   => array(
					self::get_placement_selector( $placement ) => 'text-align: {{xelnews_' . $placement . '_align}};',
				),
				'toggle'      => true,
				'label_block' => false,
			)
		);

		self::get_dimensions_controls( $_this, $placement );
	}

	// Get gap controls
	static function get_gap_controls( &$_this, $placement ) {
		if ( 'xel-news-grid' === $_this->get_name() ) {
			$_this->add_responsive_control(
				'xelnews_' . $placement . '_gap_column',
				array(
					'label'     => esc_html__( 'Column gap', 'xel-news' ),
					'type'      => \Elementor\Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 160,
							'step' => 1,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
						'em' => array(
							'min'  => 0,
							'max'  => 10,
							'step' => 0.1,
						),
					),
					'default'   => array(
						'unit' => 'px',
						'size' => 20,
					),
					'selectors' => array(
						'{{WRAPPER}} .xelnews-article-container' => 'column-gap: {{SIZE}}{{UNIT}};',
					),
				),
			);
		}

		$_this->add_responsive_control(
			'xelnews_' . $placement . '_gap_row',
			array(
				'label'     => esc_html__( 'Row gap', 'xel-news' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min'  => 0,
						'max'  => 160,
						'step' => 1,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
					'em' => array(
						'min'  => 0,
						'max'  => 10,
						'step' => 0.1,
					),
				),
				'default'   => array(
					'unit' => 'px',
					'size' => 20,
				),
				'selectors' => array(
					'{{WRAPPER}} .xelnews-article-container' => 'row-gap: {{SIZE}}{{UNIT}};',
				),
			),
		);
	}

	// Get post filter controls
	static function get_dimensions_controls( &$_this, $placement ) {
		// Margin
		$_this->add_responsive_control(
			'xelnews_' . $placement . '_margin',
			array(
				'label'      => esc_html__( 'Margin', 'xel-news' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					self::get_placement_selector( $placement ) => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		// Padding
		$_this->add_responsive_control(
			'xelnews_' . $placement . '_padding',
			array(
				'label'      => esc_html__( 'Padding', 'xel-news' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					self::get_placement_selector( $placement ) => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
	}

	// Get post filter controls
	static function get_posts_filter_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_tab_advanced',
			array(
				'label' => esc_html__( 'Filters', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		self::get_posts_filter_controls_no_section( $_this );

		$_this->end_controls_section();
	}
	static function get_posts_filter_controls_no_section( &$_this ) {
		self::add_control_post_type( $_this );
		self::add_control_post_status( $_this );

		self::get_filter_controls( $_this );

		self::add_control_post__in( $_this );
		self::add_control_post__not_in( $_this );
		self::add_control_offset( $_this );

		self::get_meta_controls( $_this );
	}

	// Get slider controls
	static function get_slider_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_tab_slider',
			array(
				'label' => esc_html__( 'Slider', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		self::add_control_slider( $_this );
		//self::add_control_columns( $_this );

		$_this->end_controls_section();
	}

	// Get ticker controls
	static function get_ticker_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_tab_ticker',
			array(
				'label' => esc_html__( 'Ticker', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		self::add_control_ticker( $_this );
		//self::add_control_columns( $_this );

		$_this->end_controls_section();
	}

	// Get columns controls
	static function get_columns_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_tab_columns',
			array(
				'label' => esc_html__( 'Columns', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		self::add_control_columns( $_this );
		//self::add_control_rows( $_this );

		$_this->end_controls_section();
	}

	// Get extra controls section
	static function get_extra_controls( &$_this ) {
		self::get_extra_heading_controls( $_this );
		self::get_extra_excerpt_controls( $_this );
		self::get_extra_meta_controls( $_this );
	}

	// Get extra meta controls
	static function get_extra_heading_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_tab_heading',
			array(
				'label' => esc_html__( 'Heading', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$_this->add_control(
			'xelnews_heading_ellipsis',
			array(
				'label'        => esc_html__( 'One row', 'xel-news' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'xel-news' ),
				'label_off'    => esc_html__( 'No', 'xel-news' ),
				'return_value' => 'yes',
				'default'      => 'no',
			)
		);

		$_this->add_control(
			'xelnews_heading_tag',
			array(
				'label'       => esc_html__( 'HTML tag', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => array(
					'h1'  => 'H1',
					'h2'  => 'H2',
					'h3'  => 'H3',
					'h4'  => 'H4',
					'h5'  => 'H5',
					'h6'  => 'H6',
					'div' => 'div',
				),
				'default'     => 'h2',
				'description' => esc_html__( 'Select heading HTML tag', 'xel-news' ),
			)
		);

		$_this->end_controls_section();
	}

	// Get extra meta controls
	static function get_extra_meta_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_tab_meta',
			array(
				'label' => esc_html__( 'Meta', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$_this->add_control(
			'xelnews_meta_switch',
			array(
				'label'        => esc_html__( 'Show meta', 'xel-news' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'xel-news' ),
				'label_off'    => esc_html__( 'No', 'xel-news' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);

		$_this->add_control(
			'xelnews_meta_hidden',
			array(
				'label'       => esc_html__( 'Hide meta', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple'    => true,
				'options'     => array(
					'format'   => esc_html__( 'Format (Video)', 'xel-news' ),
					'terms'    => esc_html__( 'Terms', 'xel-news' ),
					'time'     => esc_html__( 'Time', 'xel-news' ),
					'date'     => esc_html__( 'Date', 'xel-news' ),
					'author'   => esc_html__( 'Author', 'xel-news' ),
					'comments' => esc_html__( 'Comments', 'xel-news' ),
				),
				'default'     => array(),
			)
		);

		$_this->end_controls_section();
	}

	// Get extra excerpt controls
	static function get_extra_excerpt_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_tab_excerpt',
			array(
				'label' => esc_html__( 'Excerpt', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$_this->add_control(
			'xelnews_excerpt_switch',
			array(
				'label'        => esc_html__( 'Show excerpt', 'xel-news' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'xel-news' ),
				'label_off'    => esc_html__( 'No', 'xel-news' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);

		$_this->add_control(
			'xelnews_excerpt_length',
			array(
				'label'              => esc_html__( 'Excerpt length', 'xel-news' ),
				'type'               => \Elementor\Controls_Manager::NUMBER,
				'default'            => 20,
				'description'        => esc_html__( 'Number of words', 'xel-news' ),
				'frontend_available' => true,
			)
		);

		$_this->end_controls_section();
	}


	// Get pagination controls
	static function get_pagination_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_tab_pagination',
			array(
				'label' => esc_html__( 'Pagination', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		self::add_control_pagination_switch( $_this );
		self::add_control_pagination( $_this );

		$_this->end_controls_section();
	}

	// Get post query controls
	static function get_posts_query_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_tab_basic',
			array(
				'label' => esc_html__( 'Basic', 'xel-news' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		self::get_posts_query_controls_no_section( $_this );

		$_this->end_controls_section();
	}

	static function get_posts_query_controls_no_section( &$_this ) {
		self::add_control_limit( $_this );
		self::add_control_orderby( $_this );
		self::add_control_order( $_this );
	}

	// Get post types
	public static function get_post_type() {
		$choices_post_type = array();

		$args = array(
			'publicly_queryable' => true,
		);

		$post_types = get_post_types( $args, 'objects' );

		foreach ( $post_types as $v ) {
			$choices_post_type[ $v->name ] = $v->labels->name;
		}

		return apply_filters(
			'xelnews_control_post_types',
			$choices_post_type
		);
	}

	// Get taxonomies
	public static function get_taxonomies() {
		$choices = array();

		foreach ( self::get_post_type() as $k ) {
			$post_taxonomies = get_object_taxonomies( $k->name );

			foreach ( $post_taxonomies as $v ) {
				$choices[] = array(
					'value' => $v,
					'label' => $v,
				);
			}
		}

		return apply_filters(
			'xelnews_control_taxonomies',
			$choices
		);
	}

	// Add post type control
	static function add_control_post_type( &$_this ) {
		$_this->add_control(
			'xelnews_post_type',
			array(
				'label'       => esc_html__( 'Post type', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => self::get_post_type(),
				'default'     => 'post',
				'description' => esc_html__( 'Get which post type? default: post', 'xel-news' ),
			)
		);
	}

	// Get post statuses
	public static function get_post_status() {
		return apply_filters(
			'xelnews_control_post_status',
			array(
				'publish' => esc_html__( 'Published', 'xel-news' ),
				'pending' => esc_html__( 'Pending', 'xel-news' ),
				'draft'   => esc_html__( 'Draft', 'xel-news' ),
				'future'  => esc_html__( 'Future', 'xel-news' ),
				'private' => esc_html__( 'Private', 'xel-news' ),
				'trash'   => esc_html__( 'Trash', 'xel-news' ),
				'any'     => esc_html__( 'Any', 'xel-news' ),
			)
		);
	}

	// Add post status control
	static function add_control_post_status( &$_this ) {
		$_this->add_control(
			'xelnews_post_status',
			array(
				'label'       => esc_html__( 'Post status', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => self::get_post_status(),
				'default'     => 'publish',
				'description' => esc_html__( 'Get which post status? default: published', 'xel-news' ),
			)
		);
	}

	// Add slider controls
	static function add_control_slider( &$_this ) {
		$_this->add_control(
			'xelnews_slider',
			array(
				'label'              => esc_html__( 'Slider', 'xel-news' ),
				'type'               => \Elementor\Controls_Manager::SELECT,
				'options'            => array(
					'xel-news-grid'   => esc_html__( 'News Grid', 'xel-news' ),
					'xel-news-list'   => esc_html__( 'News List', 'xel-news' ),
					'xel-news-inline' => esc_html__( 'News Inline', 'xel-news' ),
					'xel-news-text'   => esc_html__( 'News Text', 'xel-news' ),
					'xel-news-poster' => esc_html__( 'News Poster', 'xel-news' ),
				),
				'default'            => 'xel-news-grid',
				'description'        => esc_html__( 'Select slider layout', 'xel-news' ),
				'frontend_available' => true,
			)
		);

		$_this->add_control(
			'xelnews_slider_visible',
			array(
				'label'              => esc_html__( 'Visible', 'xel-news' ),
				'type'               => \Elementor\Controls_Manager::NUMBER,
				'default'            => 3,
				'description'        => esc_html__( 'Number of items visible in slider', 'xel-news' ),
				'frontend_available' => true,
			)
		);
	}

	// Add ticker controls
	static function add_control_ticker( &$_this ) {
		$_this->add_control(
			'xelnews_ticker',
			array(
				'label'              => esc_html__( 'Ticker', 'xel-news' ),
				'type'               => \Elementor\Controls_Manager::SELECT,
				'options'            => array(
					'xel-news-list'   => esc_html__( 'News List', 'xel-news' ),
					'xel-news-inline' => esc_html__( 'News Inline', 'xel-news' ),
					'xel-news-text'   => esc_html__( 'News Text', 'xel-news' ),
				),
				'default'            => 'xel-news-list',
				'description'        => esc_html__( 'Select ticker layout', 'xel-news' ),
				'frontend_available' => true,
			)
		);

		$_this->add_control(
			'xelnews_ticker_visible',
			array(
				'label'              => esc_html__( 'Visible', 'xel-news' ),
				'type'               => \Elementor\Controls_Manager::NUMBER,
				'default'            => 3,
				'description'        => esc_html__( 'Number of items visible in ticker', 'xel-news' ),
				'frontend_available' => true,
			)
		);
	}

	// Add grid columns control
	static function add_control_columns( &$_this ) {
		$_this->add_control(
			'xelnews_columns',
			array(
				'label'       => esc_html__( 'Columns', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				),
				'default'     => '3',
				'description' => esc_html__( 'How many columns to display', 'xel-news' ),
			)
		);
	}

	// Add grid rows control
	static function add_control_rows( &$_this ) {
		$_this->add_control(
			'xelnews_rows',
			array(
				'label'       => esc_html__( 'Rows', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'default'     => 6,
				'description' => esc_html__( 'How many rows to display', 'xel-news' ),
			)
		);
	}

	// Add posts limit control
	static function add_control_limit( &$_this ) {
		$_this->add_control(
			'xelnews_limit',
			array(
				'label'       => esc_html__( 'Limit', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'default'     => 6,
				'description' => esc_html__( 'Limit number of posts to show', 'xel-news' ),
			)
		);
	}

	// Add post offset control
	static function add_control_offset( &$_this ) {
		$_this->add_control(
			'xelnews_offset',
			array(
				'label'       => esc_html__( 'Post offset', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'description' => esc_html__( 'Offset post query by N number of posts', 'xel-news' ),
			)
		);
	}

	// Add post order control
	static function add_control_orderby( &$_this ) {
		$_this->add_control(
			'xelnews_orderby',
			array(
				'label'       => esc_html__( 'Order by', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => self::get_post_orderby(),
				'default'     => 'date',
				'description' => esc_html__( 'Order by posts', 'xel-news' ),
			)
		);
	}

	// Get post order
	public static function get_post_orderby() {
		return apply_filters(
			'xelnews_control_post_orderby',
			array(
				'ID'            => esc_html__( 'ID', 'xel-news' ),
				'author'        => esc_html__( 'Author', 'xel-news' ),
				'title'         => esc_html__( 'Title', 'xel-news' ),
				'name'          => esc_html__( 'Name', 'xel-news' ),
				'date'          => esc_html__( 'Date', 'xel-news' ),
				'modified'      => esc_html__( 'Modified', 'xel-news' ),
				'rand'          => esc_html__( 'Random', 'xel-news' ),
				'comment_count' => esc_html__( 'Comment Count', 'xel-news' ),
				'menu_order'    => esc_html__( 'Menu Order', 'xel-news' ),
				'post__in'      => esc_html__( 'Post In', 'xel-news' ),
			)
		);
	}

	// Add post order control
	public static function add_control_order( &$_this ) {
		$_this->add_control(
			'xelnews_order',
			array(
				'label'       => esc_html__( 'Order', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => self::get_post_order(),
				'default'     => 'DESC',
				'description' => esc_html__( 'Order posts', 'xel-news' ),
			)
		);
	}

	// Get post order
	static function get_post_order() {
		return apply_filters(
			'xelnews_control_post_order',
			array(
				'DESC' => esc_html__( 'Descending', 'xel-news' ),
				'ASC'  => esc_html__( 'Ascending', 'xel-news' ),
			)
		);
	}

	// Add post paginaiton control
	static function add_control_pagination_switch( &$_this ) {
		$_this->add_control(
			'xelnews_pagination_switch',
			array(
				'label'        => esc_html__( 'Paginate posts', 'xel-news' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'xel-news' ),
				'label_off'    => esc_html__( 'No', 'xel-news' ),
				'return_value' => 'yes',
				'default'      => 'no',
			)
		);
	}

	// Add post paginaiton control
	static function add_control_pagination( &$_this ) {
		$_this->add_control(
			'xelnews_pagination',
			array(
				'label'       => esc_html__( 'Pagination', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => array(
					'page_numbers' => esc_html__( 'Page numbers', 'xel-news' ),
					'nav_buttons'  => esc_html__( 'Back/forward', 'xel-news' ),
					'load_more'    => esc_html__( 'Load more', 'xel-news' ),
				),
				'default'     => 'page_numbers',
				'description' => esc_html__( 'Select pagination function', 'xel-news' ),
			)
		);
	}

	// Get post__in control
	static function add_control_post__in( &$_this ) {
		$_this->add_control(
			'xelnews_post__in',
			array(
				'label'       => esc_html__( 'Post in', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter post IDs show e.g. 1|123|525', 'xel-news' ),
			)
		);
	}

	// Get post__not_in control
	static function add_control_post__not_in( &$_this ) {
		$_this->add_control(
			'xelnews_post__not_in',
			array(
				'label'       => esc_html__( 'Post not in', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter post IDs to hide e.g. 12|42|21', 'xel-news' ),
			)
		);
	}

	// Get filter control
	static function add_control_filter( &$_this ) {
		$_this->add_control(
			'xelnews_filter',
			array(
				'label'       => esc_html__( 'Filter', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter taxonomy e.g. category', 'xel-news' ),
			)
		);
	}

	// Get filter terms control
	static function add_control_filter_terms( &$_this ) {
		$_this->add_control(
			'xelnews_filter_terms',
			array(
				'label'       => esc_html__( 'Filter terms', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter taxonomy term IDs e.g. 23|25', 'xel-news' ),
			)
		);
	}

	// Get meta key control
	static function add_control_meta_key( &$_this ) {
		$_this->add_control(
			'xelnews_meta_key',
			array(
				'label'       => esc_html__( 'Meta key', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter meta key e.g. my_custom_metakey', 'xel-news' ),
			)
		);
	}

	// Get meta values control
	static function add_control_meta_value( &$_this ) {
		$_this->add_control(
			'xelnews_meta_value',
			array(
				'label'       => esc_html__( 'Meta value', 'xel-news' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter meta value e.g. yes', 'xel-news' ),
			)
		);
	}

	// Get element tab controls
	static function get_tab_controls( &$_this ) {
		$_this->start_controls_section(
			'xelnews_section_tabs',
			array(
				'label' => esc_html__( 'Tabs', 'xel-news' ),
			)
		);

		$_this->add_control(
			'xelnews_tabs',
			array(
				'label'              => esc_html__( 'Tabs', 'xel-news' ),
				'type'               => \Elementor\Controls_Manager::SELECT,
				'options'            => array(
					'xel-news-grid'   => esc_html__( 'News Grid', 'xel-news' ),
					'xel-news-list'   => esc_html__( 'News List', 'xel-news' ),
					'xel-news-inline' => esc_html__( 'News Inline', 'xel-news' ),
					'xel-news-text'   => esc_html__( 'News Text', 'xel-news' ),
				),
				'default'            => 'xel-news-text',
				'description'        => esc_html__( 'Select tabs layout', 'xel-news' ),
				'frontend_available' => true,
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'xelnews_tab_title',
			array(
				'label'       => esc_html__( 'Title', 'xel-news' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Tab Title', 'xel-news' ),
				'placeholder' => esc_html__( 'Tab Title', 'xel-news' ),
				'label_block' => true,
			)
		);

		self::get_posts_query_controls_no_section( $repeater );
		self::get_posts_filter_controls_no_section( $repeater );

		$_this->add_control(
			'xelnews_tabs_items',
			array(
				'label'       => esc_html__( 'Tabs Items', 'xel-news' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => array(
					array(
						'xelnews_tab_title' => esc_html__( 'Latest', 'xel-news' ),
					),
					array(
						'xelnews_tab_title' => esc_html__( 'Comments', 'xel-news' ),
					),
				),
				'title_field' => '{{{ xelnews_tab_title }}}',
			)
		);

		$_this->end_controls_section();

	}

	// Get element filter controls
	static function get_filter_controls( &$_this ) {
		$repeater = new Repeater();

		$repeater->add_control(
			'xelnews_filter_title',
			array(
				'label'       => esc_html__( 'Title (optional)', 'xel-news' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Filter', 'xel-news' ),
				'placeholder' => esc_html__( 'Enter title', 'xel-news' ),
			)
		);

		$repeater->add_control(
			'xelnews_filter',
			array(
				'label'   => esc_html__( 'Filter', 'xel-news' ),
				'type'    => 'xelnews_filter',
				'default' => '',
			)
		);

		$_this->add_control(
			'xelnews_filter_items',
			array(
				'label'       => esc_html__( 'Filters', 'xel-news' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => array(
					array(
						'xelnews_filter_title' => esc_html__( 'Filter 1', 'xel-news' ),
					),
				),
				'title_field' => '{{{ xelnews_filter_title }}}',
			)
		);

	}

	// Get element filter controls
	static function get_meta_controls( &$_this ) {
		$repeater = new Repeater();

		$repeater->add_control(
			'xelnews_meta_title',
			array(
				'label'       => esc_html__( 'Title (optional)', 'xel-news' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Meta', 'xel-news' ),
				'placeholder' => esc_html__( 'Enter title', 'xel-news' ),
			)
		);

		$repeater->add_control(
			'xelnews_meta_key',
			array(
				'label'       => esc_html__( 'Key', 'xel-news' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => '',
				'placeholder' => esc_html__( 'Enter meta key', 'xel-news' ),
			)
		);

		$repeater->add_control(
			'xelnews_meta_value',
			array(
				'label'       => esc_html__( 'Value', 'xel-news' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => '',
				'placeholder' => esc_html__( 'Enter meta value', 'xel-news' ),
			)
		);

		$repeater->add_control(
			'xelnews_meta_compare',
			array(
				'label'       => esc_html__( 'Compare', 'xel-news' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => self::get_meta_compares(),
				'default'     => '=',
				'placeholder' => esc_html__( 'Enter meta compare', 'xel-news' ),
			)
		);

		$repeater->add_control(
			'xelnews_meta_type',
			array(
				'label'       => esc_html__( 'Type', 'xel-news' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => self::get_meta_types(),
				'default'     => 'CHAR',
				'placeholder' => esc_html__( 'Enter meta type', 'xel-news' ),
			)
		);

		$_this->add_control(
			'xelnews_meta_items',
			array(
				'label'       => esc_html__( 'Meta', 'xel-news' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => array(
					array(
						'xelnews_meta_title'   => esc_html__( 'Meta 1', 'xel-news' ),
						'xelnews_meta_key'     => '',
						'xelnews_meta_value'   => '',
						'xelnews_meta_compare' => '=',
						'xelnews_meta_type'    => 'CHAR',
					),
				),
				'title_field' => '{{{ xelnews_meta_title }}}',
			)
		);

	}

}
