<?php

class XElNews_Print {

	public static function init() {
		add_filter( 'xelnews_query', __CLASS__ . '::query_filter', 10, 2 );
		add_action( 'wp_footer', __CLASS__ . '::localize_scripts' );

		add_action( 'wp_ajax_nopriv_xelnews_posts', __CLASS__ . '::respond' );
		add_action( 'wp_ajax_xelnews_posts', __CLASS__ . '::respond' );
	}

	// Print widget
	static function get_default_atts_array() {
		return array(
			'xelnews_columns'           => '',
			'xelnews_image_ratio'       => '',
			'xelnews_image_ratio2'      => '',
			'xelnews_image_size'        => '',
			'xelnews_image_size2'       => '',
			'xelnews_limit'             => '',
			'xelnews_offset'            => '',
			'xelnews_post_type'         => '',
			'xelnews_post_status'       => '',
			'xelnews_orderby'           => '',
			'xelnews_order'             => '',
			'xelnews_post__in'          => '',
			'xelnews_post__not_in'      => '',
			'xelnews_ticker'            => '',
			'xelnews_ticker_visible'    => '',
			'xelnews_slider'            => '',
			'xelnews_tabs'              => '',
			'xelnews_tabs_items'        => '',
			'xelnews_filter_items'      => '',
			'xelnews_meta_items'        => '',
			'xelnews_pagination_switch' => '',
			'xelnews_pagination'        => '',
			'xelnews_excerpt_switch'    => '',
			'xelnews_excerpt_length'    => '',
			'xelnews_meta_switch'       => '',
			'xelnews_meta_hidden'       => '',
			'xelnews_heading_ellipsis'  => '',
			'xelnews_heading_tag'       => '',
		);
	}

	// Print news element
	static function print_element( $_this ) {
		$atts                   = shortcode_atts( self::get_default_atts_array(), $_this->get_settings_for_display(), 'xelnews' );
		$atts['xelnews']        = $_this->get_name();
		$atts['xelnews_widget'] = $atts['xelnews'];

		//error_log( print_r( $atts, true ) );
		if ( 'xel-news-tabs' === $atts['xelnews_widget'] ) {
			self::print_tabbed_element( $_this, $atts );
		} else {
			self::print_standard_element( $_this, $atts );
		}

	}

	// Print standard element
	static function print_standard_element( &$_this, $atts ) {
		self::switch_selected_loop( $atts );

		?>
			<div id="<?php echo esc_attr( 'xelnews-' . $_this->get_id() ); ?>" class="<?php echo esc_attr( self::get_widget_class( $atts ) ); ?>" data-element="<?php echo esc_attr( $atts['xelnews_widget'] ); ?>">
				<?php self::get_loop( $atts ); ?>
			</div>
		<?php
	}

	// Print tabbed element
	static function print_tabbed_element( &$_this, $atts ) {
		if ( ! empty( $atts['xelnews_tabs_items'] ) && is_array( $atts['xelnews_tabs_items'] ) ) {
			$tabs = $atts['xelnews_tabs_items'];
			self::switch_selected_loop( $atts );
			?>
				<div id="<?php echo esc_attr( 'xelnews-' . $_this->get_id() ); ?>" class="<?php echo esc_attr( self::get_widget_class( $atts ) ); ?>" data-element="<?php echo esc_attr( $atts['xelnews_widget'] ); ?>">
			<?php
			foreach ( $tabs as $i => $tab ) {
				?>
				<div class="xelnews-tab">
					<h2 class="xelnews-tab-title"><?php echo esc_html( $tab['xelnews_tab_title'] ); ?></h2>
					<?php self::get_loop( self::build_tab_atts( $atts, $tab ) ); ?>
				</div>
				<?php
			}
			?>
			</div>
			<?php
		}
	}

	static function build_tab_atts( $atts, $tab ) {
		unset( $tab['_id'] );

		return array_merge( $atts, $tab );
	}

	static function get_post_num( $atts ) {
		if ( 'xel-news-list-featured' !== $atts['xelnews_widget'] ) {
			return '';
		}

		return $atts['n'] > 1 ? '2' : '';
	}

	static function get_widget_class( $atts ) {
		$class[] = 'xelnews';

		if ( self::is_tabs( $atts ) ) {
			$class[] = 'xelnews-tabs';
		}

		if ( self::is_ticker( $atts ) ) {
			$class[] = 'xelnews-ticker';
		}

		if ( self::is_slider( $atts ) ) {
			$class[] = 'xelnews-slider';
		}

		return implode( ' ', $class );
	}
	static function get_article_class( $atts ) {
		$class[] = 'xelnews-item' . self::get_post_num( $atts );
		if ( has_post_format( 'video' ) ) {
			$class[] = 'xelnews-is-video';
			if ( ! in_array( 'format', $atts['xelnews_meta_hidden'], true ) ) {
				$class[] = 'xelnews-video-marker-visible';
			}
		}

		return implode( ' ', $class );
	}

	static function build_query_vars_from_atts( $atts ) {
		$query_vars = array();

		if ( '' !== $atts['xelnews_limit'] ) {
			$query_vars['posts_per_page'] = absint( $atts['xelnews_limit'] ) > 0 ? absint( $atts['xelnews_limit'] ) : 10;
		} else {
			$query_vars['posts_per_page'] = 10;
		}

		if ( '' !== $atts['xelnews_post_type'] ) {
			if ( array_key_exists( $atts['xelnews_post_type'], XElNews_Core::get_post_type() ) ) {
				$query_vars['post_type'] = $atts['xelnews_post_type'];
			}
		}

		if ( '' !== $atts['xelnews_post_status'] ) {
			if ( array_key_exists( $atts['xelnews_post_status'], XElNews_Core::get_post_status() ) ) {
				$query_vars['post_status'] = $atts['xelnews_post_status'];
			}
		}

		if ( '' !== $atts['xelnews_orderby'] ) {
			if ( array_key_exists( $atts['xelnews_orderby'], XElNews_Core::get_post_orderby() ) ) {
				$query_vars['orderby'] = $atts['xelnews_orderby'];
			}
		}

		if ( '' !== $atts['xelnews_order'] ) {
			if ( array_key_exists( $atts['xelnews_order'], XElNews_Core::get_post_order() ) ) {
				$query_vars['order'] = $atts['xelnews_orderby'];
			}
		}

		if ( '' !== $atts['xelnews_post__in'] ) {
			$query_vars['post__in'] = self::strip_all( $atts['xelnews_post__in'] );
		}

		if ( '' !== $atts['xelnews_post__not_in'] ) {
			$query_vars['post__not_in'] = self::strip_all( $atts['xelnews_post__not_in'] );
		}

		if ( ! empty( $atts['xelnews_filter_items'] ) && is_array( $atts['xelnews_filter_items'] ) ) {
			$tax_query    = array();
			$author_query = array();

			foreach ( $atts['xelnews_filter_items'] as $filter ) {
				$taxonomy = ! empty( $filter['xelnews_filter']['filter'] ) ? $filter['xelnews_filter']['filter'] : '';
				$terms    = ! empty( $filter['xelnews_filter']['terms'] ) && is_array( $filter['xelnews_filter']['terms'] ) ? $filter['xelnews_filter']['terms'] : array();

				if ( ! empty( $taxonomy ) && ! empty( $terms ) ) {
					if ( 'author' === $taxonomy ) {
						$author_query[] = implode( ',', $terms );
					} elseif ( taxonomy_exists( $taxonomy ) ) {
						$include_terms = array();
						$exclude_terms = array();

						foreach ( $terms as $id ) {
							if ( $id < 0 ) {
								$exclude_terms[] = absint( $id );
							} else {
								$include_terms[] = absint( $id );
							}
						}

						if ( ! empty( $include_terms ) ) {
							$tax_query[] = array(
								'taxonomy' => $taxonomy,
								'field'    => 'term_id',
								'terms'    => $include_terms,
							);
						}

						if ( ! empty( $exclude_terms ) ) {
							$tax_query[] = array(
								'taxonomy' => $taxonomy,
								'field'    => 'term_id',
								'terms'    => $exclude_terms,
								'operator' => 'NOT IN',
							);
						}
					}
				}
			}

			if ( ! empty( $tax_query ) ) {
				$query_vars['tax_query'] = $tax_query;
			}

			if ( ! empty( $author_query ) ) {
				$query_vars['author'] = implode( ',', $author_query );
			}
		}

		if ( ! empty( $atts['xelnews_meta_items'] ) && is_array( $atts['xelnews_meta_items'] ) ) {
			$meta_query = array();

			foreach ( $atts['xelnews_meta_items'] as $meta ) {
				$key     = isset( $meta['xelnews_meta_key'] ) && is_string( $meta['xelnews_meta_key'] ) && '' !== $meta['xelnews_meta_key'] ? $meta['xelnews_meta_key'] : '';
				$value   = isset( $meta['xelnews_meta_value'] ) && is_string( $meta['xelnews_meta_value'] ) && '' !== $meta['xelnews_meta_value'] ? $meta['xelnews_meta_value'] : '';
				$compare = isset( $meta['xelnews_meta_compare'] ) && is_string( $meta['xelnews_meta_compare'] ) && '' !== $meta['xelnews_meta_compare'] ? $meta['xelnews_meta_compare'] : '';
				$type    = isset( $meta['xelnews_meta_type'] ) && is_string( $meta['xelnews_meta_type'] ) && '' !== $meta['xelnews_meta_type'] ? $meta['xelnews_meta_type'] : '';

				if ( '' !== $key && '' !== $value && '' !== $compare && '' !== $type ) {
					$compare      = in_array( $compare, self::get_meta_compares(), true ) ? $compare : '=';
					$type         = in_array( $type, self::get_meta_types(), true ) ? $type : '=';
					$meta_query[] = array(
						'key'     => $key,
						'value'   => $value,
						'compare' => $compare,
						'type'    => $type,
					);
				}
			}

			if ( ! empty( $meta_query ) ) {
				$query_vars['meta_query'] = $meta_query;
			}
		}

		if ( isset( $atts['xelnews_page'] ) && 0 < absint( $atts['xelnews_page'] ) ) {
			$query_vars['paged'] = absint( $atts['xelnews_page'] );
		}

		if ( 0 < absint( $atts['xelnews_offset'] ) ) {
			if ( isset( $atts['xelnews_page'] ) && 1 < absint( $atts['xelnews_page'] ) ) {
				$query_vars['offset'] = absint( $atts['xelnews_offset'] ) + ( absint( $atts['xelnews_page'] ) - 1 ) * $query_vars['posts_per_page'];
			} else {
				$query_vars['offset'] = absint( $atts['xelnews_offset'] );
			}
		}

		return $query_vars;
	}

	// Get meta compares
	static function get_meta_compares() {
		return array(
			'='           => '=',
			'!='          => '!=',
			'>'           => '>',
			'>='          => '>=',
			'<'           => '<',
			'<='          => '<=',
			'LIKE'        => 'LIKE',
			'NOT LIKE'    => 'NOT LIKE',
			'IN'          => 'IN',
			'NOT IN'      => 'NOT IN',
			'BETWEEN'     => 'BETWEEN',
			'NOT BETWEEN' => 'NOT BETWEEN',
			'EXISTS'      => 'EXISTS',
			'NOT EXISTS'  => 'NOT EXISTS',
		);
	}

	// Get meta types
	static function get_meta_types() {
		return array(
			'NUMERIC'  => 'NUMERIC',
			'BINARY'   => 'BINARY',
			'CHAR'     => 'CHAR',
			'DATE'     => 'DATE',
			'DATETIME' => 'DATETIME',
			'DECIMAL'  => 'DECIMAL',
			'SIGNED'   => 'SIGNED',
			'TIME'     => 'TIME',
			'UNSIGNED' => 'UNSIGNED',
		);
	}

	static function strip_all( $string ) {
		return is_string( $string ) ? strip_shortcodes( strip_tags( preg_replace( '~(?:\[/?)(?)[^/\]]+/?\]~s', '', $string ) ) ) : '';
	}

	// Get posts loop
	static function get_loop( $atts ) {
		$args = apply_filters(
			'xelnews_query',
			array(),
			self::build_query_vars_from_atts( $atts )
		);

		$xelnews_posts = new WP_Query( $args );

		if ( $xelnews_posts->have_posts() ) :
			$atts['n'] = 1;
			?>
				<div class="xelnews-container">
					<div class="xelnews-article-container" data-columns="<?php echo absint( $atts['xelnews_columns'] ); ?>">
				<?php
				while ( $xelnews_posts->have_posts() ) :
					$xelnews_posts->the_post();
					?>
							<article class="xelnews-article">
								<div class="<?php echo esc_attr( self::get_article_class( $atts ) ); ?>">
								<?php self::switch_loop( $atts ); ?>
								</div>
							</article>
						<?php
						$atts['n']++;
					endwhile;
				?>
					</div>
				</div>
			<?php

			self::pagination( $xelnews_posts, $atts );

			wp_reset_postdata();

		endif;
	}

	// Has pagination
	static function has_pagination( $widget ) {
		return in_array(
			$widget,
			array( 'xel-news-grid', 'xel-news-list', 'xel-news-inline', 'xel-news-text' ),
			true
		);
	}

	// Pagination function
	static function pagination( $xelnews_posts, $atts ) {
		if ( false === self::has_pagination( $atts['xelnews'] ) ) {
			return;
		}

		if ( 'yes' !== $atts['xelnews_pagination_switch'] ) {
			return;
		}

		$total   = isset( $xelnews_posts->max_num_pages ) ? $xelnews_posts->max_num_pages : 1;
		$current = ! empty( $atts['xelnews_page'] ) ? (int) $atts['xelnews_page'] : 1;

		if ( 1 >= $total ) {
			return;
		}

		$id = isset( $atts['xelnews_id'] ) ? $atts['xelnews_id'] : self::cache_post_atts( $atts );

		?>
		<nav class="xelnews-pagination" data-id="<?php echo esc_attr( $id ); ?>" data-max="<?php echo esc_attr( $total ); ?>">
			<?php
			switch ( $atts['xelnews_pagination'] ) {
				case 'load_more':
						self::get_pagination_load_more( $total, $current );
					break;
				case 'nav_buttons':
						self::get_pagination_nav_buttons( $total, $current );
					break;
				case 'page_numbers':
				default:
					self::get_pagination_page_numbers( $total, $current );
					break;
			}
			?>
		</nav>
		<?php
	}

	static function cache_post_atts( $atts ) {
		$id = uniqid( 'xelnews' );

		self::$cached_elements[ $id ] = array( 'atts' => $atts );

		return $id;
	}

	static function get_pagination_load_more( $total, $current ) {
		$more = 1 + $current <= $total ? 1 + $current : $total;
		?>
		<span data-page="<?php echo esc_attr( $more ); ?>">
			<?php esc_html_e( 'Load more', 'xel-news' ); ?>
		</span>
		<?php
	}

	static function get_pagination_nav_buttons( $total, $current ) {
		$left  = 1 < $current ? $current - 1 : 0;
		$right = 1 + $current <= $total ? $current + 1 : $total;
		?>
		<span data-page="<?php echo esc_attr( $left ); ?>" data-type="left"><i class="xelnews--icon-arrow-left"></i></span><span data-page="<?php echo esc_attr( $right ); ?>" data-type="right"><i class="xelnews--icon-arrow-right"></i></span>
		<?php
	}

	static function get_pagination_page_numbers( $total, $current ) {
		$end_size = 3;
		$mid_size = 2;
		$dots     = false;

		if ( $current && 1 < $current ) {
			?>
			<span data-page="<?php echo esc_attr( $current - 1 ); ?>">&lt;</span>
			<?php
		}

		for ( $n = 1; $n <= $total; $n++ ) {
			if ( $n === $current ) {
				?>
					<span data-page="<?php echo esc_attr( $n ); ?>"><?php echo absint( $n ); ?></span>
				<?php
				$dots = true;
			} else {
				if ( $n <= $end_size || ( $current && $n >= $current - $mid_size && $n <= $current + $mid_size ) || $n > $total - $end_size ) {
					?>
						<span data-page="<?php echo esc_attr( $n ); ?>"><?php echo absint( $n ); ?></span>
					<?php
					$dots = true;
				} elseif ( $dots ) {
					?>
					<span>&hellip;</span>
					<?php
					$dots = false;
				}
			}
		}

		if ( $current && $current < $total ) {
			?>
			<span data-page="<?php echo esc_attr( $current + 1 ); ?>">&gt;</span>
			<?php
		}
	}

	static function is_slider( $atts ) {
		return in_array(
			$atts['xelnews_slider'],
			array(
				'xel-news-grid',
				'xel-news-text',
				'xel-news-inline',
				'xel-news-list',
				'xel-news-poster',
			),
			true
		);
	}

	static function is_ticker( $atts ) {
		return in_array(
			$atts['xelnews_ticker'],
			array(
				'xel-news-text',
				'xel-news-inline',
				'xel-news-list',
			),
			true
		);
	}

	static function is_tabs( $atts ) {
		return in_array(
			$atts['xelnews_tabs'],
			array(
				'xel-news-grid',
				'xel-news-text',
				'xel-news-inline',
				'xel-news-list',
			),
			true
		);
	}

	static function switch_selected_loop( &$atts ) {
		if ( self::is_tabs( $atts ) ) {
			$atts['xelnews_widget'] = $atts['xelnews_tabs'];
		}
		if ( self::is_ticker( $atts ) ) {
			$atts['xelnews_widget'] = $atts['xelnews_ticker'];
		}
		if ( self::is_slider( $atts ) ) {
			$atts['xelnews_widget'] = $atts['xelnews_slider'];
		}
	}

	static function switch_loop( $atts ) {
		switch ( $atts['xelnews_widget'] ) {
			case 'xel-news-carousel':
				self::call_news_carousel( $atts );
				break;
			case 'xel-news-text':
				self::call_news_text( $atts );
				break;
			case 'xel-news-poster':
				self::call_news_poster( $atts );
				break;
			case 'xel-news-inline':
				self::call_news_inline( $atts );
				break;
			case 'xel-news-list':
				self::call_news_list( $atts );
				break;
			case 'xel-news-list-featured':
					self::call_news_list_featured( $atts );
				break;
			case 'xel-news-grid':
			default:
					self::call_news_grid( $atts );
				break;
		}
	}

	static function the_carousel_category( $atts ) {
		$category = get_the_terms( get_the_ID(), 'category' );

		if ( ! empty( $category ) && ! is_wp_error( $category ) ) {
			?>
			<div class="xelnews-category"><?php echo esc_html( $category[0]->name ); ?></div>
			<?php
		}
	}

	static function call_news_carousel( $atts ) {
		self::the_image( $atts );
		?>
			<div class="xelnews-content">
		<?php
				self::the_title( $atts );
				self::the_excerpt( $atts );
				self::the_meta( $atts );
		?>
			</div>
					<div class="xelnews-hidden">
		<?php
				self::the_carousel_category( $atts );
		?>
			</div>
		<?php
	}

	static function call_news_text( $atts ) {
		self::the_title_text( $atts );
	}

	static function call_news_poster( $atts ) {
		self::the_image( $atts );
		?>
			<div class="xelnews-content">
		<?php
				self::the_title( $atts );
				self::the_excerpt( $atts );
				self::the_meta( $atts );
		?>
			</div>
		<?php
	}

	static function call_news_inline( $atts ) {
		self::the_image( $atts );
		self::the_title( $atts );
		self::the_meta( $atts );
		self::the_excerpt( $atts );
	}

	static function call_news_list( $atts ) {
		self::the_image( $atts );
		?>
			<div class="xelnews-content">
			<?php
				self::the_title( $atts );
				self::the_meta( $atts );
				self::the_excerpt( $atts );
			?>
			</div>
		<?php
	}

	static function call_news_list_featured( $atts ) {
		self::the_image( $atts );
		if ( $atts['n'] > 1 ) {
			?>
				<div class="xelnews-content">
			<?php
		}
			self::the_title( $atts );
			self::the_meta( $atts );
			self::the_excerpt( $atts );
		if ( $atts['n'] > 1 ) {
			?>
				</div>
			<?php
		}
	}

	static function call_news_grid( $atts ) {
		self::the_image( $atts );
		self::the_title( $atts );
		self::the_meta( $atts );
		self::the_excerpt( $atts );
	}

	static function the_meta( $atts, $wrap = true ) {
		if ( 'yes' === $atts['xelnews_meta_switch'] ) {
			$meta2 = self::get_post_num( $atts ) === '2' ? ' xelnews-meta' . self::get_post_num( $atts ) : '';

			if ( $wrap ) {
				?>
				<div class="<?php echo esc_attr( 'xelnews-meta' . $meta2 ); ?>">
					<?php self::the_meta_only( $atts ); ?>
				</div>
				<?php
			} else {
				self::the_meta_only( $atts );
			}
		}
	}

	static function the_meta_only( $atts ) {
		if ( ! in_array( 'format', $atts['xelnews_meta_hidden'], true ) ) {
			self::the_post_format();
		}
		if ( ! in_array( 'terms', $atts['xelnews_meta_hidden'], true ) ) {
			self::the_taxonomy_terms( $atts );
		}
		if ( ! in_array( 'time', $atts['xelnews_meta_hidden'], true ) ) {
			self::the_time( $atts );
		}
		if ( ! in_array( 'date', $atts['xelnews_meta_hidden'], true ) ) {
			self::the_date( $atts );
		}
		if ( ! in_array( 'author', $atts['xelnews_meta_hidden'], true ) ) {
			self::the_author( $atts );
		}
		if ( ! in_array( 'comments', $atts['xelnews_meta_hidden'], true ) ) {
			self::the_comment_count( $atts );
		}
	}

	static function the_comment_count( $atts ) {
		?>
			<span class="xelnews-comment-count"><?php echo get_comments_number(); ?><i class="xelnews--icon-comment"></i></span>
		<?php
	}

	static function the_time( $atts ) {
		?>
			<span class="xelnews-time"><?php the_time(); ?></span>
		<?php
	}

	static function the_date( $atts ) {
		?>
			<span class="xelnews-date"><?php the_date(); ?></span>
		<?php
	}

	static function the_author( $atts ) {
		?>
			<span class="xelnews-author"><?php esc_html_e( 'by', 'xel-news' ); ?> <?php the_author(); ?></span>
		<?php
	}

	static function the_post_format() {
		if ( has_post_format( 'video' ) ) {
			?>
			<span class="xelnews-format"><?php esc_html_e( 'Video', 'xel-news' ); ?> <i class="xelnews--icon-video"></i></span>
			<?php
		}
	}

	static function the_taxonomy_terms( $atts ) {
		$categories = get_the_terms( get_the_ID(), 'category' );

		if ( ! empty( $categories ) && ! is_wp_error( $categories ) ) {
			$n = 1;
			?>
			<span class="xelnews-article-terms">
				<?php
				foreach ( $categories as $category ) {
					$name = ( 1 < $n ? ', ' : '' ) . $category->name;
					echo esc_html( $name );
					$n++;
				}
				?>
			</span>
			<?php
		}
	}

	static function the_title( $atts ) {
		$heading2 = self::get_post_num( $atts ) === '2' ? ' xelnews-heading' . self::get_post_num( $atts ) : '';

		$tag      = in_array( $atts['xelnews_heading_tag'], array( 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'div' ), true ) ? $atts['xelnews_heading_tag'] : 'h2';
		$ellipsis = 'yes' === $atts['xelnews_heading_ellipsis'] ? 'xelnews-ellipsis' : '';
		?>
			<?php printf( '<%s class="%s %s">', esc_attr( $tag ), esc_attr( 'xelnews-heading' . $heading2 ), esc_attr( $ellipsis ) ); ?>
			<a href="<?php the_permalink(); ?>">
				<?php the_title(); ?>
			</a>
			<?php printf( '</%s>', esc_attr( $tag ) ); ?>
		<?php
	}

	static function the_title_text( $atts ) {
		?>
			<h2 class="xelnews-heading">
				<a href="<?php the_permalink(); ?>">
					<?php self::the_meta( $atts, false ); ?>
					<?php the_title(); ?>
					<?php self::the_excerpt( $atts, false ); ?>
				</a>
			</h2>
		<?php
	}

	static function the_image( $atts ) {
		if ( has_post_thumbnail() ) {
			$thumb_id = get_post_thumbnail_id();
		}

		$size = $atts[ 'xelnews_image_size' . self::get_post_num( $atts ) ];

		if ( ! isset( $thumb_id ) ) {
			$cache = wp_get_attachment_image_src( get_the_ID(), $size );
			if ( ! empty( $cache ) ) {
				$thumb_id = get_the_ID();
			} else {
				return;
			}
		}

		if ( isset( $thumb_id ) ) {
			$set = isset( $cache ) ? $cache : wp_get_attachment_image_src( $thumb_id, $size, true );

			$w = $set[1];
			$h = $set[2];

			$ratio = explode( '-', $atts[ 'xelnews_image_ratio' . self::get_post_num( $atts ) ] );

			$x = isset( $ratio[0] ) ? $ratio[0] : 4;
			$y = isset( $ratio[1] ) ? $ratio[1] : 3;

			if ( in_array( $atts[ 'xelnews_image_ratio' . self::get_post_num( $atts ) ], array( '2-1', '1-2', '3-1', '1-3' ), true ) ) {
				$orientation = $w / $h > $x / $y ? 'xelnews-image-y' : 'xelnews-image-x';
			} else {
				$orientation = $w / $h > $x / $y ? 'xelnews-image-x' : 'xelnews-image-y';
			}

			$img2 = self::get_post_num( $atts ) === '2' ? ' xelnews-image' . self::get_post_num( $atts ) : '';

			$class = 'xelnews-image' . $img2 . ' xelnews-image-ratio-' . $atts[ 'xelnews_image_ratio' . self::get_post_num( $atts ) ] . ' ' . $orientation;
			?>
				<div class="<?php echo esc_attr( 'xelnews-image-wrapper' . self::get_post_num( $atts ) ); ?>">
					<figure class="<?php echo esc_attr( $class ); ?>" style="background-image:url(<?php echo esc_url( $set[0] ); ?>);">
						<figcaption></figcaption>
						<a href="<?php the_permalink(); ?>"></a>
					</figure>
				</div>
			<?php
		}
		// Reminder maybe empty image option? NAJNOVIJA VEST (image placeholder e.g.)
	}

	static function the_excerpt( $atts, $wrap = true ) {
		if ( 'yes' === $atts['xelnews_excerpt_switch'] ) {
			$excerpt = strip_shortcodes( strip_tags( preg_replace( '~(?:\[/?)(?)[^/\]]+/?\]~s', '', get_the_excerpt() ) ) );
			$excerpt = implode( ' ', array_slice( explode( ' ', $excerpt ), 0, $atts['xelnews_excerpt_length'] ) );

			$excerpt2 = self::get_post_num( $atts ) === '2' ? ' xelnews-excerpt' . self::get_post_num( $atts ) : '';

			if ( '' !== $excerpt ) {
				if ( true === $wrap ) {
					?>
				<p class="<?php echo esc_attr( 'xelnews-excerpt' . $excerpt2 ); ?>">
					<?php echo wp_kses_post( $excerpt ); ?>
				</p>
					<?php
				} else {
					echo wp_kses_post( $excerpt );
				}
			}
		}
	}

	// Apply query filter based on widget options
	static function query_filter( $args, $atts ) {
		$args = array(
			'post_type'   => 'post',
			'post_status' => 'publish',
		);

		$allowed = array(
			'posts_per_page',
			'offset',
			'paged',
		);

		foreach ( $allowed as $key ) {
			if ( ! empty( $atts[ $key ] ) ) {
				$args[ $key ] = absint( $atts[ $key ] );
			}
		}

		$allowed = array(
			'post_type',
			'post_status',
			'orderby',
			'order',
		);

		foreach ( $allowed as $key ) {
			if ( ! empty( $atts[ $key ] ) ) {
				$args[ $key ] = $atts[ $key ];
			}
		}

		$allowed = array(
			'post__in',
			'post__not_in',
		);

		foreach ( $allowed as $key ) {
			if ( ! empty( $atts[ $key ] ) ) {
				$args[ $key ] = strpos( $atts[ $key ], '|' ) > 0 ? explode( '|', $atts[ $key ] ) : array( $atts[ $key ] );
			}
		}

		if ( ! empty( $atts['tax_query'] ) ) {
			$args['tax_query'] = $atts['tax_query'];
		}

		if ( ! empty( $atts['author'] ) ) {
			$args['author'] = $atts['author'];
		}

		if ( ! empty( $atts['meta_query'] ) ) {
			$args['meta_query'] = $atts['meta_query'];
		}

		return $args;
	}

	// Explode widget string value
	static function get_object_array( $object ) {
		return is_string( $object ) ? ( strpos( $object, '|' ) > 0 ? explode( '|', $object ) : array( $object ) ) : array();
	}

	// Alter args to match widget filter options
	static function get_filters( $atts, &$args ) {
		$tax_query = array();

		$taxonomies = self::get_object_array( $atts['filter'] );
		$terms      = self::get_object_array( $atts['filter_term'] );

		if ( ! empty( $taxonomies ) ) {
			if ( count( $taxonomies ) !== count( $terms ) ) {
				return;
			}

			for ( $i = 0; $i < count( $taxonomies ); $i++ ) {
				$tax_query[] = array(
					'taxonomy' => $taxonomies[ $i ],
					'field'    => 'term_id',
					'terms'    => $terms[ $i ],
				);
			}

			$args['tax_query'] = $tax_query;
		}
	}

	// Alter args to match widget meta options
	/*static function get_metas( $atts, &$args ) {
		$meta_query = array();

		$keys   = self::get_object_array( $atts['meta_key'] );
		$values = self::get_object_array( $atts['meta_value'] );

		if ( ! empty( $keys ) ) {
			if ( count( $keys ) !== count( $values ) ) {
				return;
			}

			for ( $i = 0; $i < count( $keys ); $i++ ) {
				$meta_query[] = array(
					'key'   => $keys[ $i ],
					'value' => $values[ $i ],
				);
			}

			$args['meta_query'] = $meta_query;
		}
	}*/

	static $cached_elements = array();

	static function localize_scripts() {
		if ( ! empty( self::$cached_elements ) ) {
			wp_localize_script(
				'xel-news-script',
				'xelnews',
				array(
					'ajax'  => admin_url( 'admin-ajax.php' ),
					'nonce' => wp_create_nonce( 'xelnews-nonce' ),
					'el'    => self::$cached_elements,
				)
			);
		}
	}

	static function respond() {
		check_ajax_referer( 'xelnews-nonce', 'nonce' );

		//error_log( 'RESPOND' );
		//error_log( print_r( $_POST, true ) );

		if ( ! isset( $_POST['xelnews'] ) ) {
			self::error_die();
		}

		if ( ! isset( $_POST['xelnews']['atts'] ) ) {
			self::error_die();
		}

		if ( ! is_array( $_POST['xelnews']['atts'] ) ) {
			self::error_die();
		}

		foreach ( self::get_default_atts_array() as $k => $v ) {
			if ( isset( $_POST['xelnews']['atts'][ $k ] ) ) {
				$atts[ $k ] = $_POST['xelnews']['atts'][ $k ];
			}
		}

		if ( isset( $_POST['xelnews']['atts']['xelnews_id'] ) ) {
			$atts['xelnews_id'] = $_POST['xelnews']['atts']['xelnews_id'];
		}

		if ( isset( $_POST['xelnews']['atts']['xelnews_page'] ) ) {
			$atts['xelnews_page'] = $_POST['xelnews']['atts']['xelnews_page'];
		}

		if ( isset( $_POST['xelnews']['atts']['xelnews'] ) ) {
			$atts['xelnews']        = $_POST['xelnews']['atts']['xelnews'];
			$atts['xelnews_widget'] = $atts['xelnews'];
		}

		if ( ! empty( $atts ) ) {
			ob_start();
			self::get_loop( $atts );
			$html = ob_get_clean();

			wp_send_json(
				array(
					'action' => 'posts',
					'html'   => $html,
				)
			);
			exit;
		}

		self::error_die();
	}

	static function error_die() {
		wp_die( 0 );
		exit;
	}

}

XElNews_Print::init();
