<?php

class XElNews_Respond {

	public static function init() {
		add_action( 'wp_ajax_nopriv_xelnews_respond', __CLASS__ . '::respond' );
		add_action( 'wp_ajax_xelnews_respond', __CLASS__ . '::respond' );
	}

	static function respond() {
		check_ajax_referer( 'xelnews-nonce', 'nonce' );

		//error_log( 'RESPOND' );
		//error_log( print_r( $_POST, true ) );

		if ( ! isset( $_POST['xelnews'] ) ) {
			self::error_die();
		}

		$action = isset( $_POST['xelnews']['action'] ) ? $_POST['xelnews']['action'] : false;
		$filter = isset( $_POST['xelnews']['filter'] ) ? $_POST['xelnews']['filter'] : false;
		$input  = isset( $_POST['xelnews']['input'] ) ? $_POST['xelnews']['input'] : false;
		$terms  = isset( $_POST['xelnews']['terms'] ) ? $_POST['xelnews']['terms'] : false;

		if ( $action && $filter ) {
			if ( 'get' === $action && $terms ) {
				$re_terms   = array();
				$temp_terms = array();

				foreach ( $terms as $id ) {
					if ( $id < 0 ) {
						$temp_terms[] = absint( $id );
					} else {
						$temp_terms[] = absint( $id );
					}
				}
				$terms = $temp_terms;

				if ( 'author' === $filter ) {
					$args = array(
						'include' => $terms,
						'fields'  => array( 'ID', 'display_name' ),
					);

					$users = get_users( $args );

					if ( ! empty( $users ) ) {
						foreach ( $users as $user ) {
							$re_terms[ $user->ID ] = $user->display_name;
						}
					}
				} elseif ( taxonomy_exists( $filter ) ) {
					$re_terms = get_terms(
						$filter,
						array(
							'include' => $terms,
							'fields'  => 'id=>name',
						)
					);
				}

				wp_send_json(
					array(
						'action' => 'get',
						'terms'  => $re_terms,
					)
				);
				exit;
			}

			if ( 'find' === $action && $input ) {
				$terms = array();

				if ( 'author' === $filter ) {
					$args = array(
						'search' => $input,
						'fields' => array( 'ID', 'display_name' ),
					);

					$users = get_users( $args );

					if ( ! empty( $users ) ) {
						foreach ( $users as $user ) {
							$terms[ $user->ID ] = $user->display_name;
						}
					}
				} elseif ( taxonomy_exists( $filter ) ) {
					$terms = get_terms(
						$filter,
						array(
							'name__like' => $input,
							'fields'     => 'id=>name',
						)
					);
				}

				wp_send_json(
					array(
						'action' => 'find',
						'terms'  => $terms,
					)
				);
				exit;
			}
		}

		self::error_die();
	}

	static function error_die() {
		wp_die( 0 );
		exit;
	}

}

XElNews_Respond::init();
