<?php

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * XElementor News Elementor Widget
 *
 * @since 1.0.0
 */

use Elementor\Controls_Manager;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use Elementor\Utils;

class Elementor_XElNews_Text extends \Elementor\Widget_Base {


	/**
	 * Load scripts.
	 *
	 * Load script and stylesheet for the plugin.
	 *
	 * @since 1.0.0
	 *
	 * @return string Widget name.
	 */
	public function __construct( $data = array(), $args = null ) {
		parent::__construct( $data, $args );

		wp_register_script( 'xel-news-script', XElNews()->plugin_url() . '/assets/js/scripts.js', array( 'elementor-frontend', 'jquery' ), XElNews()->version(), true );
		wp_register_style( 'xel-news-stylesheet', XElNews()->plugin_url() . '/assets/css/styles' . ( is_rtl() ? '-rtl' : '' ) . '.css', false, XElNews()->version() );
	}

	public function get_script_depends() {
		return array( 'xel-news-script' );
	}

	public function get_style_depends() {
		return array( 'xel-news-stylesheet' );
	}

	/**
	 * Get widget name.
	 *
	 * Retrieve this widget name.
	 *
	 * @since 1.0.0
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'xel-news-text';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve this widget title.
	 *
	 * @since 1.0.0
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'XE News Text', 'xel-news' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve this widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories this widget belongs to.
	 *
	 * @since 1.0.0
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'general' );
	}

	/**
	 * Register this widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 */
	protected function register_controls() {
		XElNews_Core::get_elementor_settings( $this );
	}

	/**
	 * Render this widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 */
	protected function render() {
		XElNews_Print::print_element( $this );
	}
}
