<?php

/**
 * Plugin Name: XElementor News
 * Plugin URI: https://xelementor.com
 * Description: News widgets for Elementor page builder for WordPress.
 * Version: 1.0.0
 * Author: XElementor
 * Author URI: https://xelementor.com
 * Text Domain: xel-news
 * Domain Path: /lang
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'XElNews' ) ) :

	final class XElNews {

		public static $version = '1.0.0';

		protected static $_instance = null;

		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		public function __construct() {
			$this->hooks();
		}

		public function activate() {
			if ( ! defined( 'ELEMENTOR_VERSION' ) ) {
				deactivate_plugins( plugin_basename( __FILE__ ) );

				wp_die( esc_html__( 'This plugin requires Elementor. Download it from Elementor Website Builder official website https://elementor.com', 'xel-news' ) );
				exit;
			}
		}

		private function is_request( $type ) {
			switch ( $type ) {

				case 'admin':
					return is_admin();

				case 'ajax':
					return defined( 'DOING_AJAX' );

				case 'cron':
					return defined( 'DOING_CRON' );

				case 'frontend':
					return ( ! is_admin() || defined( 'DOING_AJAX' ) ) && ! defined( 'DOING_CRON' );
			}
		}

		public function hooks() {
			register_activation_hook( __FILE__, array( $this, 'activate' ) );
			add_action( 'init', array( $this, 'load_plugin_textdomain' ), 0 );
			
			add_action( 'init', array( $this, 'include_core' ) );

			add_action( 'elementor/controls/register', array( $this, 'register_controls' ) );
			add_action( 'elementor/widgets/register', array( $this, 'register_widgets' ) );
		}

		public function include_core() {
			require_once( 'includes/class-print.php' );
			require_once( 'includes/class-core.php' );
			require_once( 'includes/class-respond.php' );
		}

		public function register_controls() {
			require_once( 'includes/controls/news-filter.php' );

			\Elementor\Plugin::instance()->controls_manager->register( new \Elementor_XElNews_Control_Filter() );
		}

		public function register_widgets() {
			require_once( 'includes/widgets/news-grid.php' );
			require_once( 'includes/widgets/news-list.php' );
			require_once( 'includes/widgets/news-list-featured.php' );
			require_once( 'includes/widgets/news-inline.php' );
			require_once( 'includes/widgets/news-poster.php' );
			require_once( 'includes/widgets/news-text.php' );
			require_once( 'includes/widgets/news-ticker.php' );
			require_once( 'includes/widgets/news-carousel.php' );
			require_once( 'includes/widgets/news-slider.php' );
			require_once( 'includes/widgets/news-tabs.php' );
			
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor_XElNews_Grid() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor_XElNews_List() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor_XElNews_List_Featured() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor_XElNews_Inline() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor_XElNews_Poster() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor_XElNews_Text() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor_XElNews_Ticker() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor_XElNews_Carousel() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor_XElNews_Slider() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor_XElNews_Tabs() );
		}

		public function load_plugin_textdomain() {
			$domain = 'xel-news';
			$dir    = untrailingslashit( WP_LANG_DIR );

			$locale = apply_filters( 'plugin_locale', get_locale(), $domain );
			$loaded = load_textdomain( $domain, $dir . '/plugins/' . $domain . '-' . $locale . '.mo' );

			if ( empty( $loaded ) ) {
				load_plugin_textdomain( $domain, false, plugin_dir_path( __FILE__ ) . '/lang' );
			}

			return $loaded;
		}

		public function plugin_url() {
			return untrailingslashit( plugins_url( '/', __FILE__ ) );
		}

		public function plugin_path() {
			return untrailingslashit( plugin_dir_path( __FILE__ ) );
		}

		public function plugin_basename() {
			return untrailingslashit( plugin_basename( __FILE__ ) );
		}

		public function ajax_url() {
			return admin_url( 'admin-ajax.php', 'relative' );
		}

		public function version() {
			return self::$version;
		}
	}

	function xelnews() {
		return XElNews::instance();
	}

	XElNews::instance();

endif;
