<?php
/*
Plugin Name: NEX-Forms ADD ON - Multi-Page Forms
Plugin URI: https://codecanyon.net/item/nexforms-the-ultimate-wordpress-form-builder/7103891?ref=Basix
Description: Enables multi-page forms allowing submitted form data to be sent from one form to the next. <strong>Requires at least: <a href="https://codecanyon.net/item/nexforms-the-ultimate-wordpress-form-builder/7103891?ref=Basix" target="_blank" style="display:block">NEX-Forms v8.8 and above</a></strong>
Author: Basix
Version: 1.0
Author URI: https://codecanyon.net/user/Basix/portfolio?ref=Basix
License: GPL
Text Domain: nex-forms-multi-page-forms
Domain Path: /languages
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function nex_forms_not_found_notice_mpf() {
    if ( ! function_exists( 'NEXForms_ui_output' ) ) {
        ?>
        <div class="error notice">
            <p>
                <?php 
                echo esc_html__( 
                    'NEX-Forms not installed! You just installed Multi-Page Forms Add-on for NEX-Forms. You need the NEX-Forms core plugin to run this add-on! Please get and install ', 
                    'nex-forms-multi-page-forms' 
                ); 
                ?>
                <a href="<?php echo esc_url( 'https://1.envato.market/zQ6de' ); ?>" target="_blank">
                    <?php echo esc_html__( 'NEX-Forms - The Ultimate WordPress Form Builder', 'nex-forms-multi-page-forms' ); ?>
                </a>
                <?php echo esc_html__( ' to enable the features of this add-on.', 'nex-forms-multi-page-forms' ); ?>
            </p>
        </div>
        <?php
    }
}

add_action( 'admin_notices', 'nex_forms_not_found_notice_mpf' );

function NEXForms_setup_multi_page_data($data_array){
	$output = '';
	foreach($data_array as $key => $val)
		{	
		if(get_option('nf_activated'))	
			{
			if( $key!='form_Id' &&
				$key!='nf_preview_id' &&
				$key!='paypal_invoice' &&
				$key!='paypal_return_url' &&
				$key!='math_result' &&
				$key!='set_file_ext' &&
				$key!='format_date' &&
				$key!='action' &&
				$key!='set_radio_items' &&
				$key!='change_button_layout' &&
				$key!='set_check_items' &&
				$key!='set_autocomplete_items' &&
				$key!='required' &&
				$key!='xform_submit' &&
				$key!='current_page' &&
				$key!='ajaxurl' &&
				$key!='page_id' &&
				$key!='page' &&
				$key!='ip' &&
				$key!='nf_page_id' &&
				$key!='nf_page_title' &&
				$key!='nex_forms_Id' &&
				$key!='company_url' &&
				$key!='submit' &&
				$key!='ms_current_step' &&
				!strstr($key,'real_val') &&
				!strstr($key,'_nomail') &&
				!strstr($key,'gu__')
				)
					{
					$output .= '<input type="hidden" name="'.$key.'"  data-original-value="'.wp_unslash(sanitize_text_field($val)).'" value="'.wp_unslash(sanitize_text_field($val)).'">';	
					}
			}
		}
	return $output;
}