<?php
namespace KissOnScrollMorph;

/**
 * Class Plugin
 *
 * Main Plugin class
 * @since 1.0.0
 */
class kiss_onscrollmorph_config {

	/**
	 * Instance
	 *
	 * @since 1.0.0
	 * @access private
	 * @static
	 *
	 * @var Plugin The single instance of the class.
	 */
	private static $_instance = null;

	/**
	 * Instance
	 *
	 * Ensures only one instance of the class is loaded or can be loaded.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return Plugin An instance of the class.
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * widget_scripts
	 *
	 * Load required plugin core files.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function kiss__onscroll_morph__widget_scripts() {

		wp_enqueue_script('jquery');

		wp_register_script('gsap', plugins_url('/assets/js/gsap.js',__FILE__), array(), false, true);
		wp_register_script('splitting', plugins_url('/assets/js/splitting.js',__FILE__), array(), false, true);
		wp_register_script('scrolltrigger', plugins_url('/assets/js/scrolltrigger.js',__FILE__),  array(), false, true);
		wp_register_script('lenis', plugins_url('/assets/js/lenis.js',__FILE__),  array(), false, true);
		wp_register_script('imagesloaded', plugins_url('/assets/js/imagesloaded.js',__FILE__),  array(), false, true);

		wp_register_script('kiss-morph', plugins_url('/assets/js/morph.js',__FILE__),  array(), false, true);
		
		
	}
	
	/**
	 * widget_styles
	 *
	 * Load required plugin core files.
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function kiss__onscroll_morph__widget_styles(){

		wp_register_style('on-scroll-morph',plugins_url('/assets/css/style.css',__FILE__));
		wp_enqueue_style( 'on-scroll-morph' );
	}	

	/**
	 * Include Widgets files
	 *
	 * Load widgets files
	 *
	 * @since 1.0.0
	 * @access private
	 */
	private function kiss__onscroll_morph__include_widgets_files() {
		
		require_once( __DIR__ . '/widgets/morph_perspective.php' );
		require_once( __DIR__ . '/widgets/morph_cinemascope.php' );

		
	}
	
	
	/**
	 * Register Widgets
	 *
	 * Register new Elementor widgets.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function kiss__onscroll_morph__register_widgets() {
		// Its is now safe to include Widgets files
		$this->kiss__onscroll_morph__include_widgets_files();

		// Register Widgets
		
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\kiss__onscroll_morph__perspective() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\kiss__onscroll_morph__cinemascope() );
		
	}
	
	//category registered
	public function kiss__onscroll_morph__add_elementor_categories( $elements_manager ) {

		$elements_manager->add_category(
			'kiss-on-scroll-morph-category',
			[
				'title' => esc_html__( 'On-Scroll Morph', 'on-scroll-morph' ),
				'icon' => 'fa fa-plug',
			]
		);
	}

	/**
	 *  Plugin class constructor
	 *
	 * Register plugin action hooks and filters
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function __construct() {

		// Enqueue widget styles
        add_action( 'elementor/frontend/after_register_styles', [ $this, 'kiss__onscroll_morph__widget_styles' ] , 100 );
        add_action( 'admin_enqueue_scripts', [ $this, 'kiss__onscroll_morph__widget_styles' ] , 100 );

		// Enqueue widget scripts
        add_action( 'elementor/frontend/after_register_scripts', [ $this, 'kiss__onscroll_morph__widget_scripts' ], 100 );

		// Register widgets
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'kiss__onscroll_morph__register_widgets' ] );
		
		//category registered
		add_action( 'elementor/elements/categories_registered',  [ $this,'kiss__onscroll_morph__add_elementor_categories' ]);

	}
}

// Instantiate Plugin Class
kiss_onscrollmorph_config::instance();
