<?php
/**
 * Plugin Name: On-Scroll Morph for Elementor
 * Description: Elementor On-Scroll Image Morph Elements.
 * Plugin URI: https://demo.krasotaiskusstva.com/elementor/on-scroll-morph
 * Author: Moskva Yigit
 * Version: 1.0.7
 * Author URI: https://codecanyon.net/user/ki-themes/
 *
 * Text Domain: on-scroll-morph
 * Elementor tested up to: 3.21.3
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
	
/**
 * Main venus wp Class
 *
 * The init class that runs the Hello World plugin.
 * Intended To make sure that the plugin's minimum requirements are met.
 *
 * You should only modify the constants to match your plugin's needs.
 *
 * Any custom code should go inside Plugin Class in the plugin.php file.
 */

final class kiss__onscroll_morph {
	
	/**
	 * Minimum Elementor Version
	 *
	 * @since 1.0.0
	 * @var string Minimum Elementor version required to run the plugin.
	 */
	const MINIMUM_ELEMENTOR_VERSION = '3.0.0';

	/**
	 * Minimum PHP Version
	 *
	 * @since 1.0.0
	 * @var string Minimum PHP version required to run the plugin.
	 */
	const MINIMUM_PHP_VERSION = '7.1';

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function __construct() {

		// Load translation
		add_action( 'init', array( $this, 'kiss__onscroll_morph__i18n' ) );

		// Init Plugin
		add_action( 'plugins_loaded', array( $this, 'kiss__onscroll_morph__init' ) );
		
		//Init Admin Menu
		add_action( 'admin_menu', array( $this, 'kiss__onscroll_morph__admin_menu' ) );
		
	}

	/**
	 * Load Textdomain
	 *
	 * Load plugin localization files.
	 * Fired by `init` action hook.
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function kiss__onscroll_morph__i18n() {
		load_plugin_textdomain( 'on-scroll-morph', false, dirname( __FILE__ ) . '/languages' );
	}

	/**
	 * Initialize the plugin
	 *
	 * Validates that Elementor is already loaded.
	 * Checks for basic plugin requirements, if one check fail don't continue,
	 * if all check have passed include the plugin class.
	 *
	 * Fired by `plugins_loaded` action hook.
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function kiss__onscroll_morph__init() {

		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', array( $this, 'kiss__onscroll_morph__admin_notice' ) );
			return;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', array( $this, 'kiss__onscroll_morph__minimum_elementor_version' ) );
			return;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', array( $this, 'kiss__onscroll_morph__minimum_php_version' ) );
			return;
		}
		
		// Check verify
		//add_action( 'admin_notices', array( $this, 'kiss__onscroll_morph__verify' ) );	
		
		// Require configuration file
		require_once( 'config.php' );
		require_once( 'updater.php' );

	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have Elementor installed or activated.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function kiss__onscroll_morph__admin_notice() {
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'on-scroll-morph' ),
			'<strong>' . esc_html__( 'On Scroll Morph', 'on-scroll-morph' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'on-scroll-morph' ) . '</strong>'
		);

		$html_message = sprintf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
		echo wp_kses_post( $html_message );
	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required Elementor version.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function kiss__onscroll_morph__minimum_elementor_version() {
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'on-scroll-morph' ),
			'<strong>' . esc_html__( 'On Scroll Morph', 'on-scroll-morph' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'on-scroll-morph' ) . '</strong>',
			self::MINIMUM_ELEMENTOR_VERSION
		);

		$html_message = sprintf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
		echo wp_kses_post( $html_message );
	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required PHP version.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function kiss__onscroll_morph__minimum_php_version() {
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}

		$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'on-scroll-morph' ),
			'<strong>' . esc_html__( 'On Scroll Morph', 'on-scroll-morph' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'on-scroll-morph' ) . '</strong>',
			self::MINIMUM_PHP_VERSION
		);

		$html_message = sprintf( '<div class="notice notice-warning"><p>%1$s</p></div>', $message );
		echo wp_kses_post( $html_message );
	}
	
	/**
	* Admin notice
	*
	* Warning when the site doesn't have a minimum required PHP version.
	*
	* @since 1.0.0
	* @access public
	*/
	public function kiss__onscroll_morph__verify() {
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}
		
		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( 'To start using the plugin and to get the auto updates, "%1$s" needs activation. %2$s to update the configuration. .', 'on-scroll-morph' ),
			'<strong>' . esc_html__( 'On Scroll Morph', 'on-scroll-morph' ) . '</strong>',
			'<strong><a href="options.php?page=on-scroll-morph">' . esc_html__( 'Click here', 'on-scroll-morph' ) . '</a></strong>'
		);
			
		$html_message = sprintf( '<div class="notice notice-warning"><p>%1$s</p></div>', $message );
		echo wp_kses_post( $html_message );

	}
	
	/**
	* Settings
	*
	* Registers a new settings page under Settings.
	*
	* @since 1.0.0
	* @access public
	*/
	public function kiss__onscroll_morph__admin_menu() {
		add_submenu_page(
			'options.php',
			esc_html__( 'Register', 'on-scroll-morph' ),
			esc_html__( 'Register', 'on-scroll-morph' ),
			'manage_options',
			'on-scroll-morph',
			array(
				$this,
				'settings_page'
			)
		);
	}
	
	/**
	* Callback
	*
	* Settings page display callback.
	*
	* @since 1.0.0
	* @access public
	*/
	public function settings_page() {

		// Require configuration file
		require_once( 'init.php' );
		new kiss__onscroll_morph__verifycode();
		
	}

}

/**
* Plugin settings
*
* Creates a link to the plugin details page
*
* @since 1.0.0
* @access public
*/
function kiss__onscroll_morph__settings( $links ) {
	$links[] = '<a href="' . admin_url( 'options.php?page=on-scroll-morph' ) .'">' . esc_html__('Register','on-scroll-morph') . '</a>';
	return $links;
}

//Init Settings
add_filter('plugin_action_links_'.plugin_basename(__FILE__), 'kiss__onscroll_morph__settings');

new kiss__onscroll_morph();
