<?php defined( 'ABSPATH' ) || exit;
/**
 * The template for displaying custom taxonomy content within loop
 *
 * This template can be overridden by copying it to yourtheme/ovabrw-templates/loop/taxonomy.php
 *
 */

global $product;
if ( !$product || !$product->is_type( OVABRW_RENTAL ) ) return;

// Get custom taxonomies
$taxonomies = $product->get_custom_taxonomies( 'archive' );

if ( ovabrw_array_exists( $taxonomies ) ): ?>
	<ul class="product_listing_custom_tax">
		<?php foreach ( $taxonomies as $slug => $tax ): ?>
			<li class="<?php echo esc_attr( 'tax_'.$slug ); ?> ">
				<?php echo esc_html( $tax['name'] ); ?>
			</li>
		<?php endforeach; ?>
	</ul>
<?php endif; ?>
