<?php if ( !defined( 'ABSPATH' ) ) exit();

// Add woocommerce class
add_filter( 'body_class', function( $classes ) {
	return array_merge( $classes, [ 'woocommerce' ] );
});

// Get products
$products = OVABRW()->options->get_available_items_from_search( $_GET );

// Get columns
$columns = wc_get_loop_prop( 'columns' );

// Get cart template
$card = ovabrw_get_card_template();
if ( 'modern' !== ovabrw_get_setting( 'search_template', 'modern' ) ) $card = '';
if ( in_array( $card , ['card5', 'card6'] ) ) $columns = 1;

// Get header
get_header('shop');

// Before main content
do_action( 'woocommerce_before_main_content' );

?>

<header class="woocommerce-products-header">
	<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
		<h1 class="woocommerce-products-header__title page-title">
			<?php esc_html_e( 'Search Results', 'ova-brw' ); ?>
		</h1>
	<?php endif;
		do_action( 'woocommerce_archive_description' );
	?>
</header>
<?php if ( $products && $products->have_posts() ): ?>
	<ul class="products columns-<?php echo esc_attr( $columns ); ?>">
		<?php while ( $products->have_posts() ) : $products->the_post();
			global $product;

			// Ensure visibility.
			if ( !$product || !$product->is_visible() ) continue;

			if ( $card ):
				$thumbnail_type = ovabrw_get_option( 'glb_'.$card.'_thumbnail_type', 'slider' );
			?>
				<li <?php wc_product_class( 'item', $product ); ?>>
					<?php ovabrw_get_template( 'modern/products/cards/ovabrw-'.$card.'.php', [
						'thumbnail_type' => $thumbnail_type
					]); ?>
				</li>
			<?php else:
				wc_get_template_part( 'content', 'product' );
			endif;
		endwhile; wp_reset_postdata(); ?>
	</ul>
<?php else:
	do_action( 'woocommerce_no_products_found' );
endif;

do_action( 'woocommerce_after_main_content' );
do_action( 'woocommerce_sidebar' );

// Get footer
get_footer('shop');