<?php
/*
Plugin Name: 	WhatsHelp Chat Support Pro
Plugin URI: 	https://wpchatplugins.com/plugins/click-to-whatsapp/
Description: 	Can easily create Bubble & buttons for reciving whatsapp message from useres in any WordPress site. Gutenberg, Elementor and shortcodes supported. 
Author: 		ThemeAtelier
Version: 		2.0.14
Author:         ThemeAtelier
Author URI:     https://themeatelier.net/
License:        GPL-2.0+
License URI:    https://www.gnu.org/licenses/gpl-2.0.html
Requirements:   PHP 7.0 or above, WordPress 4.0 or above.
Text Domain:    chat-whatsapp-pro
Domain Path:    /languages
*/

// Block Direct access
if (!defined('ABSPATH')) {
    die('You should not access this file directly!');
}
require_once __DIR__ . '/vendor/autoload.php';

use ThemeAtelier\ChatWhatsappPro\ChatWhatsappPro;

define('CHAT_WHATSAPP_PRO_VERSION', '2.0.14');
define('CHAT_WHATSAPP_PRO_FILE', __FILE__);
define('CHAT_WHATSAPP_PRO_ALERT_MSG', esc_html__('You should not access this file directly!', 'chat-whatsapp-pro'));
define('CHAT_WHATSAPP_PRO_DIRNAME', dirname(__FILE__));
define('CHAT_WHATSAPP_PRO_DIR_PATH', plugin_dir_path(__FILE__));
define('CHAT_WHATSAPP_PRO_DIR_URL', plugin_dir_url(__FILE__));
define('CHAT_WHATSAPP_PRO_BASENAME', plugin_basename(__FILE__));


function chat_whatsapp_pro_run()
{
    // Launch the plugin.
    $CHAT_WHATSAPP_PRO = new ChatWhatsappPro();
    $CHAT_WHATSAPP_PRO->run();
}

// kick-off the plugin
chat_whatsapp_pro_run();


// Register block
function create_block_whatsapp_block_init()
{
    register_block_type_from_metadata(CHAT_WHATSAPP_PRO_DIR_PATH . 'src/Frontend/blocks/');
}
add_action('init', 'create_block_whatsapp_block_init');


// Register block category 
function whatsapp_chat_plugin_block_categories($categories)
{
    return array_merge(
        $categories,
        [
            [
                'slug'  => 'whatsapp-block',
                'title' => __('Whatsapp block', 'chat-whatsapp-pro'),
            ],
        ]
    );
}
add_action('block_categories', 'whatsapp_chat_plugin_block_categories', 10, 2);

function chat_whatsapp_pro_deactivate_free_version()
{
    // Define the plugin slug for the free version
    $free_plugin_slug = 'chat-help/chat-whatsapp.php';

    // Check if the free version is active
    if (is_plugin_active($free_plugin_slug)) {
        // Deactivate the free version
        deactivate_plugins($free_plugin_slug);

        // Notify the user
        add_action('admin_notices', function () {
?>
            <div class="notice notice-warning is-dismissible">
                <p><?php esc_html_e('The free version of "Chat Whatsapp" has been deactivated because the pro version is active.', 'chat-whatsapp-pro'); ?></p>
            </div>
<?php
        });
    }
}
add_action('admin_init', 'chat_whatsapp_pro_deactivate_free_version');


/**
 * Initialize the plugin tracker
 *
 * @return void
 */
function chat_whatsapp_pro_appsero_init()
{

    if (!class_exists('WhatsHelpProAppSero\Insights')) {
        require_once CHAT_WHATSAPP_PRO_DIR_PATH . 'src/Admin/appsero/Client.php';
    }

    $client = new WhatsHelpProAppSero\Client('7f06837d-cc4d-442a-b8ad-1e7cf54b7d06', 'WhatsHelp Chat Support Pro', __FILE__);
    // Active insights
    $client->insights()->init();
}

chat_whatsapp_pro_appsero_init();