<?php

/**
 * Views class for Shortcode generator options.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package chat-whatsapp-pro
 * @subpackage chat-whatsapp-pro/src/Admin/Views/ChatWhatsappProCustomCode
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\ChatWhatsappPro\Admin\Views;

use ThemeAtelier\ChatWhatsappPro\Admin\Framework\Classes\CHAT_WHATSAPP_PRO;

class ChatWhatsappProCustomCode
{

    /**
     * Create Option fields for the setting options.
     *
     * @param string $prefix Option setting key prefix.
     * @return void
     */
    public static function options($prefix)
    {
        //
        // CUSTOM CODES
        //
        CHAT_WHATSAPP_PRO::createSection($prefix, array(
            'title'       => esc_html__('CUSTOM CODES', 'chat-whatsapp-pro'),
            'icon'        => 'icofont-vscode',
            'fields'      => array(
                array(
                    'id'       => 'whatsapp-custom-css',
                    'type'     => 'code_editor',
                    'title'    => esc_html__('Custom CSS', 'chat-whatsapp-pro'),
                    'settings' => array(
                        'theme'  => 'mbo',
                        'mode'   => 'css',
                    ),
                ),

                array(
                    'id'       => 'whatsapp-custom-js',
                    'type'     => 'code_editor',
                    'title'    => esc_html__('Custom JavaScript', 'chat-whatsapp-pro'),
                    'settings' => array(
                        'theme'  => 'mbo',
                        'mode'   => 'js',
                    ),
                ),

            )
        ));
    }
}
