<?php

/**
 * Views class for Shortcode generator options.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package chat-whatsapp-pro
 * @subpackage chat-whatsapp-pro/src/Admin/Views/ChatWhatsappProPopup
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\ChatWhatsappPro\Admin\Views;

use ThemeAtelier\ChatWhatsappPro\Admin\Framework\Classes\CHAT_WHATSAPP_PRO;

class ChatWhatsappProPopup
{

    /**
     * Create Option fields for the setting options.
     *
     * @param string $prefix Option setting key prefix.
     * @return void
     */
    public static function options($prefix, $timezones)
    {
        //
        // Create a section
        //
        CHAT_WHATSAPP_PRO::createSection($prefix, array(
            'title'  => esc_html__('FLOATING POPUP', 'chat-whatsapp-pro'),
            'icon'   => 'icofont-ui-text-chat',
            'fields' => array(
                array(
                    'type' => 'section_tab',
                    'tabs' => array(
                        array(
                            'title' => esc_html__('General', 'greet-bubble'),
                            'icon'  => 'icofont-gear',
                            'fields'    => array(
                                // changeing chat type
                                array(
                                    'id'         => 'opt-chat-type',
                                    'type'       => 'button_set',
                                    'title'      => esc_html__('Bubble type', 'chat-whatsapp-pro'),
                                    'default' => 'single',
                                    'options'    => array(
                                        'single'  => esc_html__('Single user', 'chat-whatsapp-pro'),
                                        'multi' => esc_html__('Multiple users', 'chat-whatsapp-pro'),
                                    ),
                                ),

                                // adding contact number
                                array(
                                    'id'    => 'opt-number',
                                    'type'  => 'text',
                                    'title' => esc_html__('WhatsApp Number', 'chat-whatsapp-pro'),
                                    'default'  => '+880123456189',
                                    'subtitle'  => esc_html__('Add your WhatsApp number including country code. eg: +880123456189', 'chat-whatsapp-pro'),
                                    'validate' => 'csf_validate_numeric',
                                    'dependency' => array('opt-chat-type', 'any', 'single'),
                                ),


                                // changeing timezone
                                array(
                                    'id'    => 'select-timezone',
                                    'type'  => 'select',
                                    'title' => esc_html__('Timezone', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('When using the date and time from the user browser you can transform it to your current timezone (in case your user is in a different timezone)', 'chat-whatsapp-pro'),
                                    'chosen'      => true,
                                    'placeholder' => esc_html__('Select timezone', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-chat-type', 'any', 'single'),
                                    'options' => $timezones,
                                ),

                                // Add availablity
                                array(
                                    'id'    => 'opt-availablity',
                                    'type'  => 'tabbed',
                                    'title' => esc_html__('Availablity', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('24-hour Time without PM:AM" eg: From 00:00 to 23:59. If you are offline for any specefic full day use 00:00 and 00:00 in From and To value.', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-chat-type', 'any', 'single'),
                                    // sunday
                                    'tabs'  => array(
                                        array(
                                            'title'  => esc_html__('Sunday', 'chat-whatsapp-pro'),
                                            'fields' => array(
                                                array(
                                                    'id'       => 'availablity-sunday',
                                                    'type'     => 'datetime',
                                                    'from_to'  => true,
                                                    'settings' => array(
                                                        'noCalendar' => true,
                                                        'enableTime' => true,
                                                        'dateFormat' => 'H:i',
                                                        'time_24hr'  => true,
                                                    ),
                                                ),
                                            ),
                                        ),
                                        // monday
                                        array(
                                            'title'  => esc_html__('Monday', 'chat-whatsapp-pro'),
                                            'fields' => array(
                                                array(
                                                    'id'       => 'availablity-monday',
                                                    'type'     => 'datetime',
                                                    'from_to'  => true,
                                                    'settings' => array(
                                                        'noCalendar' => true,
                                                        'enableTime' => true,
                                                        'dateFormat' => 'H:i',
                                                        'time_24hr'  => true,
                                                    ),
                                                ),
                                            ),
                                        ),
                                        // tuesday
                                        array(
                                            'title'  => esc_html__('Tuesday', 'chat-whatsapp-pro'),
                                            'fields' => array(
                                                array(
                                                    'id'       => 'availablity-tuesday',
                                                    'type'     => 'datetime',
                                                    'from_to'  => true,
                                                    'settings' => array(
                                                        'noCalendar' => true,
                                                        'enableTime' => true,
                                                        'dateFormat' => 'H:i',
                                                        'time_24hr'  => true,
                                                    ),
                                                ),
                                            ),
                                        ),
                                        // wednesday
                                        array(
                                            'title'  => esc_html__('Wednesday', 'chat-whatsapp-pro'),
                                            'fields' => array(
                                                array(
                                                    'id'       => 'availablity-wednesday',
                                                    'type'     => 'datetime',
                                                    'from_to'  => true,
                                                    'settings' => array(
                                                        'noCalendar' => true,
                                                        'enableTime' => true,
                                                        'dateFormat' => 'H:i',
                                                        'time_24hr'  => true,
                                                    ),
                                                ),
                                            ),
                                        ),

                                        // thursday
                                        array(
                                            'title'  => esc_html__('Thursday', 'chat-whatsapp-pro'),
                                            'fields' => array(
                                                array(
                                                    'id'       => 'availablity-thursday',
                                                    'type'     => 'datetime',
                                                    'from_to'  => true,
                                                    'settings' => array(
                                                        'noCalendar' => true,
                                                        'enableTime' => true,
                                                        'dateFormat' => 'H:i',
                                                        'time_24hr'  => true,
                                                    ),
                                                ),
                                            ),
                                        ),

                                        // friday
                                        array(
                                            'title'  => esc_html__('Friday', 'chat-whatsapp-pro'),
                                            'fields' => array(
                                                array(
                                                    'id'       => 'availablity-friday',
                                                    'type'     => 'datetime',
                                                    'from_to'  => true,
                                                    'settings' => array(
                                                        'noCalendar' => true,
                                                        'enableTime' => true,
                                                        'dateFormat' => 'H:i',
                                                        'time_24hr'  => true,
                                                    ),
                                                ),
                                            ),
                                        ),

                                        // thursday
                                        array(
                                            'title'  => esc_html__('Saturday', 'chat-whatsapp-pro'),
                                            'fields' => array(
                                                array(
                                                    'id'       => 'availablity-saturday',
                                                    'type'     => 'datetime',
                                                    'from_to'  => true,
                                                    'settings' => array(
                                                        'noCalendar' => true,
                                                        'enableTime' => true,
                                                        'dateFormat' => 'H:i',
                                                        'time_24hr'  => true,
                                                    ),
                                                ),
                                            ),
                                        ),

                                    ),
                                ),

                                // changeing layout type
                                array(
                                    'id'         => 'opt-layout-type',
                                    'type'       => 'button_set',
                                    'title'      => esc_html__('Layout type', 'chat-whatsapp-pro'),
                                    'default' => 'form',
                                    'options'    => array(
                                        'form'  => esc_html__('With form', 'chat-whatsapp-pro'),
                                        'agent' => esc_html__('With agent message', 'chat-whatsapp-pro'),
                                    ),
                                    'dependency' => array('opt-chat-type', '==', 'single', 'any'),
                                ),

                                // adding agent photo
                                array(
                                    'id'    => 'agent-photo',
                                    'type'    => 'media',
                                    'title'   => esc_html__('Agent photo', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Add agent photo to show in the bubble.', 'chat-whatsapp-pro'),
                                    'library' => 'image',
                                    'placeholder' => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/user.webp',
                                    'preview' => true,
                                    'dependency' => array('opt-chat-type', '==', 'single', 'any'),
                                    'default' => [
                                        'url' => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/user.webp',
                                    ],
                                ),

                                // agent name
                                array(
                                    'id'    => 'agent-name',
                                    'type'    => 'text',
                                    'title'   => esc_html__('Agent name', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Add your/agent name for shoing in bubble.', 'chat-whatsapp-pro'),
                                    'default' => esc_html__('John Doe', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-chat-type', '==', 'single', 'any'),
                                ),

                                // agent subtitle
                                array(
                                    'id'    => 'agent-subtitle',
                                    'type'    => 'text',
                                    'title'   => esc_html__('Subtitle', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Add subtitle to show under agent name', 'chat-whatsapp-pro'),
                                    'default' => esc_html__('Typically replies within a day', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-chat-type', '==', 'single', 'any'),
                                ),
                                array(
                                    'id'    => 'agent-name-placeholder-text',
                                    'type'    => 'text',
                                    'title'   => esc_html__('Agent name placeholder text', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Add agent name placeholder text', 'chat-whatsapp-pro'),
                                    'default' => esc_html__('Your name?', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-chat-type|opt-layout-type', '==|==', 'single|form', 'any'),
                                ),
                                array(
                                    'id'    => 'agent-message-placeholder-text',
                                    'type'    => 'text',
                                    'title'   => esc_html__('Agent message placeholder text', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Add agent message placeholder text', 'chat-whatsapp-pro'),
                                    'default' => esc_html__('Message', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-chat-type|opt-layout-type', '==|==', 'single|form', 'any'),
                                ),
                                array(
                                    'id'    => 'show_current_time',
                                    'type'    => 'switcher',
                                    'title'   => esc_html__('Current Time', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Show message before current time', 'chat-whatsapp-pro'),
                                    'default' => true,
                                    'dependency' => array('opt-chat-type|opt-layout-type', '==|==', 'single|agent', 'any'),
                                ),

                                // agent subtitle
                                array(
                                    'id'    => 'agent-message',
                                    'type'    => 'textarea',
                                    'title'   => esc_html__('Message from agent', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Add add custom message for shoing in message box.', 'chat-whatsapp-pro'),
                                    'default' => esc_html__('Hello, Welcome to the site. Please click below button for chating me throught WhatsApp.', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-layout-type', 'any', 'agent'),
                                ),

                                // before chat icon
                                array(
                                    'id'    => 'before-chat-icon',
                                    'type'  => 'icon',
                                    'title' => esc_html__('Icon for send message button', 'chat-whatsapp-pro'),
                                    'default' => 'icofont-brand-whatsapp',
                                    'subtitle' => esc_html__('Change icon for adding before send message button text.', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-chat-type', 'any', 'single'),
                                ),

                                // agent subtitle
                                array(
                                    'id'    => 'chat-button-text',
                                    'type'    => 'text',
                                    'title'   => esc_html__('Send message button text', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Add send message button text', 'chat-whatsapp-pro'),
                                    'default' => esc_html__('Send a message', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-chat-type', 'any', 'single'),
                                ),

                                array(
                                    'id'    => 'whatsapp_message_template',
                                    'type'  => 'textarea',
                                    'title' => esc_html__('Message Template', 'chat-whatsapp-pro'),
                                    'default' => esc_html__("Name: {name}.\n\n Message: {message}\n\nDate: {date}", 'chat-whatsapp-pro'),
                                    'desc'  => esc_html__("Available tags &ndash; {name}, {message}, {date}, {siteURL}", 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-layout-type', 'any', 'form'),
                                ),

                                /************************************
                                 * MULTI AGENTS SETTINGS
                                 *************************************/

                                // Bubble title
                                array(
                                    'id'    => 'bubble-title',
                                    'type'    => 'text',
                                    'title'   => esc_html__('Bubble title', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Add title to show as top main text of bubble.', 'chat-whatsapp-pro'),
                                    'default' => esc_html__('Need Help? Send a WhatsApp message now', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-chat-type', '==', 'multi', 'any'),
                                ),

                                // Bubble subtitle
                                array(
                                    'id'    => 'bubble-subtitle',
                                    'type'    => 'text',
                                    'title'   => esc_html__('Bubble subtitle', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Add subtitle to show below main title.', 'chat-whatsapp-pro'),
                                    'default' => esc_html__('Click one of our representatives below', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-chat-type', '==', 'multi', 'any'),
                                ),



                                // Chat agents
                                array(
                                    'id'     => 'opt-chat-agents',
                                    'type'   => 'group',
                                    'title'  => esc_html__('Chat agents', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-chat-type', '==', 'multi', 'any'),
                                    'fields' => array(
                                        array(
                                            'id'    => 'agent-name',
                                            'type'  => 'text',
                                            'title' => esc_html__('Agent name', 'chat-whatsapp-pro'),
                                        ),

                                        // adding agent photo
                                        array(
                                            'id'    => 'agent-photo',
                                            'type'    => 'media',
                                            'title'   => esc_html__('Agent photo', 'chat-whatsapp-pro'),
                                            'placeholder' => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/user.webp',
                                            'library' => 'image',
                                            'preview' => true,
                                        ),

                                        array(
                                            'id'    => 'agent-number',
                                            'type'  => 'text',
                                            'title' => esc_html__('Whatsapp number for agent', 'chat-whatsapp-pro'),
                                        ),

                                        // changeing timezone
                                        array(
                                            'id'    => 'agent-timezone',
                                            'type'  => 'select',
                                            'title' => esc_html__('Timezone', 'chat-whatsapp-pro'),
                                            'subtitle' => esc_html__('When using the date and time from the user browser you can transform it to your current timezone (in case your user is in a different timezone)', 'chat-whatsapp-pro'),
                                            'chosen'      => true,
                                            'placeholder' => esc_html__('Select timezone', 'chat-whatsapp-pro'),
                                            'options' => $timezones,
                                        ),

                                        // user avaialablity

                                        // Add availablity
                                        array(
                                            'id'    => 'opt-availablity',
                                            'type'  => 'tabbed',
                                            'title' => esc_html__('Availablity', 'chat-whatsapp-pro'),
                                            'subtitle' => esc_html__('24-hour Time without PM:AM" eg: From 00:00 to 23:59. If you are offline for any specefic full day use 00:00 and 00:00 in From and To value.', 'chat-whatsapp-pro'),
                                            // sunday
                                            'tabs'  => array(
                                                array(
                                                    'title'  => esc_html__('Sunday', 'chat-whatsapp-pro'),
                                                    'fields' => array(
                                                        array(
                                                            'id'       => 'availablity-sunday',
                                                            'type'     => 'datetime',
                                                            'from_to'  => true,
                                                            'settings' => array(
                                                                'noCalendar' => true,
                                                                'enableTime' => true,
                                                                'dateFormat' => 'H:i',
                                                                'time_24hr'  => true,
                                                            ),
                                                        ),
                                                    ),
                                                ),
                                                // monday
                                                array(
                                                    'title'  => esc_html__('Monday', 'chat-whatsapp-pro'),
                                                    'fields' => array(
                                                        array(
                                                            'id'       => 'availablity-monday',
                                                            'type'     => 'datetime',
                                                            'from_to'  => true,
                                                            'settings' => array(
                                                                'noCalendar' => true,
                                                                'enableTime' => true,
                                                                'dateFormat' => 'H:i',
                                                                'time_24hr'  => true,
                                                            ),
                                                        ),
                                                    ),
                                                ),
                                                // tuesday
                                                array(
                                                    'title'  => esc_html__('Tuesday', 'chat-whatsapp-pro'),
                                                    'fields' => array(
                                                        array(
                                                            'id'       => 'availablity-tuesday',
                                                            'type'     => 'datetime',
                                                            'from_to'  => true,
                                                            'settings' => array(
                                                                'noCalendar' => true,
                                                                'enableTime' => true,
                                                                'dateFormat' => 'H:i',
                                                                'time_24hr'  => true,
                                                            ),
                                                        ),
                                                    ),
                                                ),
                                                // wednesday
                                                array(
                                                    'title'  => esc_html__('Wednesday', 'chat-whatsapp-pro'),
                                                    'fields' => array(
                                                        array(
                                                            'id'       => 'availablity-wednesday',
                                                            'type'     => 'datetime',
                                                            'from_to'  => true,
                                                            'settings' => array(
                                                                'noCalendar' => true,
                                                                'enableTime' => true,
                                                                'dateFormat' => 'H:i',
                                                                'time_24hr'  => true,
                                                            ),
                                                        ),
                                                    ),
                                                ),

                                                // thursday
                                                array(
                                                    'title'  => esc_html__('Thursday', 'chat-whatsapp-pro'),
                                                    'fields' => array(
                                                        array(
                                                            'id'       => 'availablity-thursday',
                                                            'type'     => 'datetime',
                                                            'from_to'  => true,
                                                            'settings' => array(
                                                                'noCalendar' => true,
                                                                'enableTime' => true,
                                                                'dateFormat' => 'H:i',
                                                                'time_24hr'  => true,
                                                            ),
                                                        ),
                                                    ),
                                                ),

                                                // friday
                                                array(
                                                    'title'  => esc_html__('Friday', 'chat-whatsapp-pro'),
                                                    'fields' => array(
                                                        array(
                                                            'id'       => 'availablity-friday',
                                                            'type'     => 'datetime',
                                                            'from_to'  => true,
                                                            'settings' => array(
                                                                'noCalendar' => true,
                                                                'enableTime' => true,
                                                                'dateFormat' => 'H:i',
                                                                'time_24hr'  => true,
                                                            ),
                                                        ),
                                                    ),
                                                ),

                                                // thursday
                                                array(
                                                    'title'  => esc_html__('Saturday', 'chat-whatsapp-pro'),
                                                    'fields' => array(
                                                        array(
                                                            'id'       => 'availablity-saturday',
                                                            'type'     => 'datetime',
                                                            'from_to'  => true,
                                                            'settings' => array(
                                                                'noCalendar' => true,
                                                                'enableTime' => true,
                                                                'dateFormat' => 'H:i',
                                                                'time_24hr'  => true,
                                                            ),
                                                        ),
                                                    ),
                                                ),

                                            ),
                                        ),
                                        // agent designation

                                        array(
                                            'id'    => 'agent-designation',
                                            'type'  => 'text',
                                            'title' => esc_html__('Agent designation', 'chat-whatsapp-pro'),
                                        ),

                                        array(
                                            'id'    => 'agent-online-text',
                                            'type'  => 'text',
                                            'title' => esc_html__('Agent online text', 'chat-whatsapp-pro'),
                                        ),

                                        array(
                                            'id'    => 'agent-offline-text',
                                            'type'  => 'text',
                                            'title' => esc_html__('Agent offline text', 'chat-whatsapp-pro'),
                                        ),
                                    ),
                                    'default' => array(
                                        array(
                                            'agent-name'     => esc_html__('Sarah C. Patrick', 'chat-whatsapp-pro'),
                                            'agent-number'     => esc_html__('+8801123456588', 'chat-whatsapp-pro'),
                                            'agent-designation' => esc_html__('Technical support', 'chat-whatsapp-pro'),
                                            'agent-online-text' => esc_html__('I am online', 'chat-whatsapp-pro'),
                                            'agent-offline-text' => esc_html__('I am offline', 'chat-whatsapp-pro'),
                                            'agent-photo' => [
                                                "url" => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/user.webp',
                                            ]
                                        ),
                                        array(
                                            'agent-name'     => esc_html__('Patricia J. Hunt', 'chat-whatsapp-pro'),
                                            'agent-number'     => esc_html__('008801123456588', 'chat-whatsapp-pro'),
                                            'agent-designation' => esc_html__('Marketing support', 'chat-whatsapp-pro'),
                                            'agent-online-text' => esc_html__('I am online', 'chat-whatsapp-pro'),
                                            'agent-offline-text' => esc_html__('I am offline', 'chat-whatsapp-pro'),
                                            'agent-photo' => [
                                                "url" => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/agent1.webp',
                                            ]
                                        ),
                                        array(
                                            'agent-name'     =>  esc_html__('Frederic M. Tune', 'chat-whatsapp-pro'),
                                            'agent-number'     =>  esc_html__('+8801123456588', 'chat-whatsapp-pro'),
                                            'agent-designation' =>  esc_html__('Sales support', 'chat-whatsapp-pro'),
                                            'agent-online-text' =>  esc_html__('I am online', 'chat-whatsapp-pro'),
                                            'agent-offline-text' =>  esc_html__('I am offline', 'chat-whatsapp-pro'),
                                            'agent-photo' => [
                                                "url" => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/agent2.webp',
                                            ]
                                        ),
                                        array(
                                            'agent-name'     => esc_html__('Douglas A. Smith', 'chat-whatsapp-pro'),
                                            'agent-number'     => esc_html__('+8801123456588', 'chat-whatsapp-pro'),
                                            'agent-designation' => esc_html__('Product manager', 'chat-whatsapp-pro'),
                                            'agent-online-text' => esc_html__('I am online', 'chat-whatsapp-pro'),
                                            'agent-offline-text' => esc_html__('I am offline', 'chat-whatsapp-pro'),
                                            'agent-photo' => [
                                                "url" => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/agent3.webp',
                                            ]
                                        ),
                                        array(
                                            'agent-name'     => esc_html__('Douglas A. Smith', 'chat-whatsapp-pro'),
                                            'agent-number'     => esc_html__('+8801123456588', 'chat-whatsapp-pro'),
                                            'agent-designation' => esc_html__('Support Manager', 'chat-whatsapp-pro'),
                                            'agent-online-text' => esc_html__('I am online', 'chat-whatsapp-pro'),
                                            'agent-offline-text' => esc_html__('I am offline', 'chat-whatsapp-pro'),
                                            'agent-photo' => [
                                                "url" => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/agent4.webp',
                                            ]
                                        ),
                                        array(
                                            'agent-name'     => esc_html__('Garland D. Homer', 'chat-whatsapp-pro'),
                                            'agent-number'     => esc_html__('+8801123456588', 'chat-whatsapp-pro'),
                                            'agent-designation' => esc_html__('Technical support', 'chat-whatsapp-pro'),
                                            'agent-online-text' => esc_html__('I am online', 'chat-whatsapp-pro'),
                                            'agent-offline-text' => esc_html__('I am offline', 'chat-whatsapp-pro'),
                                            'agent-photo' => [
                                                "url" => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/agent1.webp',
                                            ]
                                        ),
                                    )
                                ),
                            ),
                        ),
                        array(
                            'title' => esc_html__('Advanced Settings', 'greet-bubble'),
                            'icon'  => 'icofont-settings',
                            'fields'    => array(
                                // Autometically show popup
                                array(
                                    'id'        => 'autoshow-popup',
                                    'type'      => 'switcher',
                                    'title'     => esc_html__('Auto open popup', 'chat-whatsapp-pro'),
                                    'subtitle'  => esc_html__('Turn ON for open popup automatically.', 'chat-whatsapp-pro'),
                                    'default'   => false,
                                ),

                                // Auto open popup timeout
                                array(
                                    'id'        => 'auto_open_popup_timeout',
                                    'type'      => 'slider',
                                    'title'     => esc_html__('Auto open popup timeout', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Timeout value for opening popup after second.', 'chat-whatsapp-pro'),
                                    'min'     => 0,
                                    'max'     => 100,
                                    'step'    => 1,
                                    'default' => 0,
                                    'dependency' => array('autoshow-popup', '==', 'true'),
                                ),

                                // GDPR compliance checkbox
                                array(
                                    'id'    => 'gdpr-enable',
                                    'type'    => 'switcher',
                                    'title'   => esc_html__('GDPR compliance', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Turn ON enabling GDPR compliance checkbox', 'chat-whatsapp-pro'),
                                    'default' => false,
                                ),
                                // GDPR compliance text
                                array(
                                    'id'    => 'gdpr-compliance-content',
                                    'type'    => 'wp_editor',
                                    'title'   => esc_html__('GDPR compliance message', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Change default GFPR compliance text', 'chat-whatsapp-pro'),
                                    'default' => esc_attr('Please accept our <a href="#">privacy policy</a> first to start a conversation.', 'chat-whatsapp-pro'),
                                    'dependency' => array('gdpr-enable', 'any', true),
                                ),

                                // Header content position
                                array(
                                    'id'      => 'bubble-style',
                                    'type'    => 'button_set',
                                    'title'   => esc_html__('Select bubble layout mode', 'chat-whatsapp-pro'),
                                    'default' => 'default',
                                    'options'    => array(
                                        'default'  => esc_html__('Light mode', 'chat-whatsapp-pro'),
                                        'dark' => esc_html__('Dark mode', 'chat-whatsapp-pro'),
                                        'night' => esc_html__('Night mode', 'chat-whatsapp-pro'),
                                    ),
                                ),

                                // Header content position
                                array(
                                    'id'      => 'header-content-position',
                                    'type'    => 'button_set',
                                    'title'   => esc_html__('Bubble header contnet position', 'chat-whatsapp-pro'),
                                    'default' => 'center',
                                    'options'    => array(
                                        'left'  => esc_html__('Left', 'chat-whatsapp-pro'),
                                        'center' => esc_html__('Center', 'chat-whatsapp-pro'),
                                    ),
                                    'dependency' => array('opt-chat-type', 'any', 'single'),
                                ),

                                // Show search field
                                array(
                                    'id'      => 'bubble-search',
                                    'type'    => 'switcher',
                                    'title'   => esc_html__('Show searh field?', 'chat-whatsapp-pro'),
                                    'default' => true,
                                    'text_on'  => esc_html__('Yes', 'chat-whatsapp-pro'),
                                    'text_off' => esc_html__('No', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-chat-type', '==', 'multi', 'any'),
                                ),

                                // Agent list or grid
                                array(
                                    'id'      => 'agent-listGrid',
                                    'type'    => 'button_set',
                                    'title'   => esc_html__('Agent listing style', 'chat-whatsapp-pro'),
                                    'default' => 'list',
                                    'options'    => array(
                                        'list'  => esc_html__('List', 'chat-whatsapp-pro'),
                                        'grid'  => esc_html__('Grid', 'chat-whatsapp-pro'),
                                    ),
                                    'dependency' => array('opt-chat-type', '==', 'multi', 'any'),
                                ),

                                // changeing bubble animations
                                array(
                                    'id'    => 'select-animation',
                                    'type'  => 'select',
                                    'title' => esc_html__('Select animation for bubble', 'chat-whatsapp-pro'),
                                    'options' => array(
                                        '1'     => esc_html__('Fade Right', 'chat-whatsapp-pro'),
                                        '2'     => esc_html__('Fade Down', 'chat-whatsapp-pro'),
                                        '4'     => esc_html__('Fade In Scale', 'chat-whatsapp-pro'),
                                        '5'     => esc_html__('Rotation', 'chat-whatsapp-pro'),
                                        '6'     => esc_html__('Slide Fall', 'chat-whatsapp-pro'),
                                        '7'     => esc_html__('Slide Down', 'chat-whatsapp-pro'),
                                        '3'     => esc_html__('Ease Down', 'chat-whatsapp-pro'),
                                        '8'     => esc_html__('Rotate Left', 'chat-whatsapp-pro'),
                                        '9'     => esc_html__('Flip Horizontal', 'chat-whatsapp-pro'),
                                        '10'    => esc_html__('Flip Vertical', 'chat-whatsapp-pro'),
                                        '11'    => esc_html__('Flip Up', 'chat-whatsapp-pro'),
                                        '12'    => esc_html__('Super Scaled', 'chat-whatsapp-pro'),
                                        '13'    => esc_html__('Slide Up', 'chat-whatsapp-pro'),
                                        'random' => esc_html__('Random', 'chat-whatsapp-pro'),
                                    ),
                                    'default'     => 'random',
                                ),
                            ),
                        ),
                    ),
                ),
            )
        ));
    }
}
