<?php

/**
 * Single Template Class
 *
 * This class handles the single template functionality for Chat WhatsApp Pro.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package    chat-whatsapp-pro
 * @subpackage chat-whatsapp-pro/src/Frontend
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\ChatWhatsappPro\Frontend\Templates;

/**
 * Class SingleTemplate
 *
 * Handles the rendering of single templates in the plugin.
 *
 * @since 1.0.0
 */
class SingleTemplate
{


	/**
	 * Handles single template logic.
	 *
	 * This method contains the logic to display or render single templates.
	 *
	 * @since 1.0.0
	 */
	public static function singleTemplate($options, $bubble_type, $random, $whatsapp_message_template, $whatsapp_number)
	{
		$optAvailablity = isset($options['opt-availablity']) ? $options['opt-availablity'] : '';
		$sunday_from    = $optAvailablity ? $optAvailablity['availablity-sunday']['from'] : '00:00';
		$sunday_to      = $optAvailablity ? $optAvailablity['availablity-sunday']['to'] : '23:59';
		$monday_from    = $optAvailablity ? $optAvailablity['availablity-monday']['from'] : '00:00';
		$monday_to      = $optAvailablity ? $optAvailablity['availablity-monday']['to'] : '23:59';

		$tuesday_from   = $optAvailablity ? $optAvailablity['availablity-tuesday']['from'] : '00:00';
		$tuesday_to     = $optAvailablity ? $optAvailablity['availablity-tuesday']['to'] : '23:59';

		$wednesday_from = $optAvailablity ? $optAvailablity['availablity-wednesday']['from'] : '00:00';
		$wednesday_to   = $optAvailablity ? $optAvailablity['availablity-wednesday']['to'] : '23:59';

		$thursday_from  = $optAvailablity ? $optAvailablity['availablity-thursday']['from'] : '00:00';
		$thursday_to    = $optAvailablity ? $optAvailablity['availablity-thursday']['to'] : '23:59';


		$friday_from    = $optAvailablity ? $optAvailablity['availablity-friday']['from'] : '00:00';
		$friday_to      = $optAvailablity ? $optAvailablity['availablity-friday']['to'] : '23:59';

		$saturday_from  = $optAvailablity ? $optAvailablity['availablity-saturday']['from'] : '00:00';
		$saturday_to    = $optAvailablity ? $optAvailablity['availablity-saturday']['to'] : '23:59';

		$sunday         = ($sunday_from ? $sunday_from : "0:00") . "-" . ($sunday_to ? $sunday_to : "23:59");
		$monday         = ($monday_from ? $monday_from : "0:00") . "-" . ($monday_to ? $monday_to : "23:59");
		$tuesday        = ($tuesday_from ? $tuesday_from : "0:00") . "-" . ($tuesday_to ? $tuesday_to : "23:59");
		$wednesday      = ($wednesday_from ? $wednesday_from : "0:00") . "-" . ($wednesday_to ? $wednesday_to : "23:59");
		$thursday       = ($thursday_from ? $thursday_from : "0:00") . "-" . ($thursday_to ? $thursday_to : "23:59");
		$friday         = ($friday_from ? $friday_from : "0:00") . "-" . ($friday_to ? $friday_to : "23:59");
		$saturday       = ($saturday_from ? $saturday_from : "0:00") . "-" . ($saturday_to ? $saturday_to : "23:59");

		$gdpr_compliance_content = isset($options['gdpr-compliance-content']) ? $options['gdpr-compliance-content'] : '';
		$bubble_position = isset($options['bubble-position']) ? $options['bubble-position'] : '';
		$select_animation = isset($options['select-animation']) ? $options['select-animation'] : '';
		$agent_name = isset($options['agent-name']) ? $options['agent-name'] : '';
		$agent_message = isset($options['agent-message']) ? $options['agent-message'] : '';
		$show_current_time = isset($options['show_current_time']) ? $options['show_current_time'] : true;

		$agent_photo = isset($options['agent-photo']) ? $options['agent-photo'] : '';
		if ($agent_photo) {
			$agent_photo = (isset($agent_photo['url']) && !empty($agent_photo['url'])) ? $agent_photo['url'] : CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/agent.png';
		} else {
			$agent_photo = CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/agent.png';
		}
		$bubble_visibility = isset($options['bubble-visibility']) ? $options['bubble-visibility'] : 'everywhere';
		// Method implementation goes here.
		if ('random' === $select_animation) :
			$animation = $random;
		else :
			$animation = $select_animation;
		endif;

		echo '<div class="wHelp ' . esc_attr($bubble_position) . ' wHelp-' . esc_attr($bubble_visibility) . '-only ';

		// Add bubble style classes based on the 'bubble-style' option.
		if ($options['bubble-style'] === 'dark') {
			echo 'dark-mode ';
		} elseif ($options['bubble-style'] === 'night') {
			echo 'night-mode ';
		}

		// Add position-specific class if position is 'left'.
		if ('left' === $bubble_position) {
			echo 'wHelp-left';
		}

		echo '">';
		echo wp_kses_post($bubble_type); ?>
		<div class="wHelp__popup animation<?php echo esc_attr($animation) ?> chat-availability" data-timezone="<?php echo esc_attr($options['select-timezone']); ?>" data-availability='{ "sunday":"<?php echo esc_attr($sunday); ?>", "monday":"<?php echo esc_attr($monday); ?>", "tuesday":"<?php echo esc_attr($tuesday); ?>", "wednesday":"<?php echo esc_attr($wednesday); ?>", "thursday":"<?php echo esc_attr($thursday); ?>", "friday":"<?php echo esc_attr($friday); ?>", "saturday":"<?php echo esc_attr($saturday); ?>" }'>
			<div class="wHelp__popup--header 
				<?php
				if ($options['header-content-position'] === 'center') {
				?>
					header-center<?php } ?>">
				<div class="image">
					<img src="<?php echo esc_attr($agent_photo); ?>" />
				</div>
				<div class="info">
					<h4 class="info__name"><?php echo esc_html($agent_name); ?></h4>
					<p class="info__title"><?php echo esc_html($options['agent-subtitle']); ?></p>
				</div>
			</div>
			<form class="wHelp__popup--content" data-template="<?php echo esc_attr($whatsapp_message_template); ?>" data-number="<?php echo esc_attr($whatsapp_number); ?>">
				<?php if ($options['opt-layout-type'] === 'form') : ?>
					<?php if ($options['gdpr-enable']) : ?>
						<div class="wHelp--checkbox">
							<input id="gdpr-check" name="gdpr-check" type="checkbox" class="wHelp__checkbox" />
							<label for="gdpr-check"><?php echo wp_kses_post($gdpr_compliance_content); ?></label>
						</div>
					<?php endif; ?>
					<div class="user-text">
						<input id="wHelp-name" type="text" placeholder="<?php echo esc_attr($options['agent-name-placeholder-text']); ?>" required>
						<textarea id="wHelp-message" rows="5" type="text" placeholder="<?php echo esc_attr($options['agent-message-placeholder-text']); ?>" required></textarea>
					</div>
				<?php else : ?>
					<?php if ($options['gdpr-enable']) : ?>
						<div class="wHelp--checkbox">
							<input id="gdpr-check" name="gdpr-check" type="checkbox" class="wHelp__checkbox" />
							<label for="gdpr-check"><?php echo wp_kses_post($gdpr_compliance_content); ?></label>
						</div>
					<?php endif;
					if ($show_current_time) {
					?>
						<div class="current-time"></div>
					<?php }
					if ($agent_message) : ?>
						<div class="sms">
							<?php if ($agent_photo) : ?>
								<div class="sms__user">
									<img src="<?php echo esc_attr($agent_photo); ?>" />
								</div>
							<?php
							endif;
							?>
							<div class="sms__text">
								<p>
									<?php echo esc_html($agent_message); ?>
								</p>
							</div>
						</div>
				<?php endif;
				endif; ?>

				<?php if ($options['opt-layout-type'] === 'form') : ?>
					<button type="submit" class="wHelp__send-message
						<?php
						if ($options['gdpr-enable']) :
						?>
							condition__checked<?php endif; ?>" target="_blank">
						<i class="<?php echo esc_html($options['before-chat-icon']); ?>"></i><?php echo esc_html($options['chat-button-text']); ?>
					</button>
				<?php else : ?>
					<button class="wHelp__send-message
						<?php
						if ($options['gdpr-enable']) :
						?>
							condition__checked<?php endif; ?>" target="_blank" type="submit">
						<i class="<?php echo esc_html($options['before-chat-icon']); ?>"></i><?php echo esc_html($options['chat-button-text']); ?>
						<a href="https://wa.me/<?php echo esc_attr($options['opt-number']); ?>" target="_blank"></a>
					</button>
				<?php endif; ?>
			</form>
		</div>
		</div>
<?php
	}
}
