<?php

/**
 *  Dynamic CSS
 *
 * @package    idonate-pro
 * @subpackage idonate-pro/src
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$options = get_option( 'cwp_option' );

$bubble_button_tooltip_width = isset( $options['bubble_button_tooltip_width'] ) ? $options['bubble_button_tooltip_width'] : '';

$bubble_position = isset( $options['bubble-position'] ) ? $options['bubble-position'] : 'right_bottom';
// Right
$right_bottom              = isset( $options['right_bottom'] ) ? $options['right_bottom'] : array();
$right_bottom_value_bottom = isset( $right_bottom['bottom'] ) ? $right_bottom['bottom'] : '25';
$right_bottom_value_right  = isset( $right_bottom['right'] ) ? $right_bottom['right'] : '30';
$right_bottom_unit         = isset( $right_bottom['unit'] ) ? $right_bottom['unit'] : 'px';

// Left
$left_bottom              = isset( $options['left_bottom'] ) ? $options['left_bottom'] : array();
$left_bottom_value_bottom = isset( $left_bottom['bottom'] ) ? $left_bottom['bottom'] : '25';
$left_bottom_value_left   = isset( $left_bottom['left'] ) ? $left_bottom['left'] : '30';
$left_bottom_unit         = isset( $left_bottom['unit'] ) ? $left_bottom['unit'] : 'px';

// Right Middle
$right_middle             = isset( $options['right_middle'] ) ? $options['right_middle'] : array();
$right_middle_value_right = isset( $right_middle['right'] ) ? $right_middle['right'] : '0';
$right_middle_unit        = isset( $right_middle['unit'] ) ? $right_middle['unit'] : 'px';

// Left Middle
$left_middle            = isset( $options['left_middle'] ) ? $options['left_middle'] : array();
$left_middle_value_left = isset( $left_middle['left'] ) ? $left_middle['left'] : '0';
$left_middle_unit       = isset( $left_middle['unit'] ) ? $left_middle['unit'] : 'px';


// Tablet positioning
$enable_tablet_positioning = isset( $options['enable-positioning-tablet'] ) ? $options['enable-positioning-tablet'] : '';
$bubble_position_tablet    = isset( $options['bubble-position-tablet'] ) ? $options['bubble-position-tablet'] : 'right_bottom';


// Right for Tablet
$right_bottom_tablet              = isset( $options['right_bottom_tablet'] ) ? $options['right_bottom_tablet'] : array();
$right_bottom_value_bottom_tablet = isset( $right_bottom_tablet['bottom'] ) ? $right_bottom_tablet['bottom'] : '25';
$right_bottom_value_right_tablet  = isset( $right_bottom_tablet['right'] ) ? $right_bottom_tablet['right'] : '30';
$right_bottom_unit_tablet         = isset( $right_bottom_tablet['unit'] ) ? $right_bottom_tablet['unit'] : 'px';

// Left for Tablet
$left_bottom_tablet              = isset( $options['left_bottom_tablet'] ) ? $options['left_bottom_tablet'] : array();
$left_bottom_value_bottom_tablet = isset( $left_bottom_tablet['bottom'] ) ? $left_bottom_tablet['bottom'] : '25';
$left_bottom_value_left_tablet   = isset( $left_bottom_tablet['left'] ) ? $left_bottom_tablet['left'] : '30';
$left_bottom_unit_tablet         = isset( $left_bottom_tablet['unit'] ) ? $left_bottom_tablet['unit'] : 'px';

// Right Middle for Tablet
$right_middle_tablet             = isset( $options['right_middle_tablet'] ) ? $options['right_middle_tablet'] : array();
$right_middle_value_right_tablet = isset( $right_middle_tablet['right'] ) ? $right_middle_tablet['right'] : '0';
$right_middle_unit_tablet        = isset( $right_middle_tablet['unit'] ) ? $right_middle_tablet['unit'] : 'px';

// Left Middle for Tablet
$left_middle_tablet            = isset( $options['left_middle_tablet'] ) ? $options['left_middle_tablet'] : array();
$left_middle_value_left_tablet = isset( $left_middle_tablet['left'] ) ? $left_middle_tablet['left'] : '0';
$left_middle_unit_tablet       = isset( $left_middle_tablet['unit'] ) ? $left_middle_tablet['unit'] : 'px';

// Mobile positioning
$enable_mobile_positioning = isset( $options['enable-positioning-mobile'] ) ? $options['enable-positioning-mobile'] : '';
$bubble_position_mobile    = isset( $options['bubble-position-mobile'] ) ? $options['bubble-position-mobile'] : 'right_bottom';

// Right for Mobile
$right_bottom_mobile              = isset( $options['right_bottom_mobile'] ) ? $options['right_bottom_mobile'] : array();
$right_bottom_value_bottom_mobile = isset( $right_bottom_mobile['bottom'] ) ? $right_bottom_mobile['bottom'] : '25';
$right_bottom_value_right_mobile  = isset( $right_bottom_mobile['right'] ) ? $right_bottom_mobile['right'] : '30';
$right_bottom_unit_mobile         = isset( $right_bottom_mobile['unit'] ) ? $right_bottom_mobile['unit'] : 'px';

// Left for Mobile
$left_bottom_mobile              = isset( $options['left_bottom_mobile'] ) ? $options['left_bottom_mobile'] : array();
$left_bottom_value_bottom_mobile = isset( $left_bottom_mobile['bottom'] ) ? $left_bottom_mobile['bottom'] : '25';
$left_bottom_value_left_mobile   = isset( $left_bottom_mobile['left'] ) ? $left_bottom_mobile['left'] : '30';
$left_bottom_unit_mobile         = isset( $left_bottom_mobile['unit'] ) ? $left_bottom_mobile['unit'] : 'px';

// Right Middle for Mobile
$right_middle_mobile             = isset( $options['right_middle_mobile'] ) ? $options['right_middle_mobile'] : array();
$right_middle_value_right_mobile = isset( $right_middle_mobile['right'] ) ? $right_middle_mobile['right'] : '0';
$right_middle_unit_mobile        = isset( $right_middle_mobile['unit'] ) ? $right_middle_mobile['unit'] : 'px';

// Left Middle for Mobile
$left_middle_mobile            = isset( $options['left_middle_mobile'] ) ? $options['left_middle_mobile'] : array();
$left_middle_value_left_mobile = isset( $left_middle_mobile['left'] ) ? $left_middle_mobile['left'] : '0';
$left_middle_unit_mobile       = isset( $left_middle_mobile['unit'] ) ? $left_middle_mobile['unit'] : 'px';


// Bubble button style
$bubble_button_style = isset($options['opt-button-style']) ? $options['opt-button-style'] : "1";

// Bubble button paddings
$bubble_button_padding = isset($options['bubble-button-padding']) ? $options['bubble-button-padding'] : array();
$bubble_button_padding_top =  isset($bubble_button_padding['top']) ? $bubble_button_padding['top'] : '5';
$bubble_button_padding_right =  isset($bubble_button_padding['right']) ? $bubble_button_padding['right'] : '10';
$bubble_button_padding_bottom =  isset($bubble_button_padding['bottom']) ? $bubble_button_padding['bottom'] : '5';
$bubble_button_padding_left =  isset($bubble_button_padding['left']) ? $bubble_button_padding['left'] : '10';
$bubble_button_padding_unit = isset($bubble_button_padding['unit']) ? $bubble_button_padding['unit'] : 'px';

if ( 'right_bottom' === $bubble_position  ) {
	$custom_css .= ".wHelp, .wHelp-multi {bottom: {$right_bottom_value_bottom}{$right_bottom_unit};right: {$right_bottom_value_right}{$right_bottom_unit};}.wHelp__popup, .wHelp-multi__popup{right: 0;}.wHelp .tooltip_text, .wHelp-multi .tooltip_text{right:100%;left:auto; margin-right: 10px;}";
}
if ( 'left_bottom' === $bubble_position ) {
	$custom_css .= ".wHelp, .wHelp-multi{left: {$left_bottom_value_left}{$left_bottom_unit};}.wHelp, .wHelp-multi{ bottom: {$left_bottom_value_bottom}{$left_bottom_unit};}.wHelp__popup, .wHelp-multi__popup{left: 0}.wHelp .tooltip_text, .wHelp-multi .tooltip_text{left:100%;right:auto; margin-left: 10px;}";
}
if ( 'right_middle' === $bubble_position ) {
	$custom_css .= ".wHelp, .wHelp-multi {top: auto; bottom: 50%;left: auto; right: {$right_middle_value_right}{$right_middle_unit};}.wHelp.wHelp-show, .wHelp-multi.wHelp-show{bottom: 20%}.wHelp .tooltip_text, .wHelp-multi .tooltip_text{right:100%;left:auto; margin-right: 10px;}";
}
if ( 'left_middle' === $bubble_position ) {
	$custom_css .= ".wHelp, .wHelp-multi {top: auto; bottom: 50%;left: {$left_middle_value_left}{$left_middle_unit}; right: auto;}.wHelp.wHelp-show, .wHelp-multi.wHelp-show{bottom: 20%}.wHelp__popup, .wHelp-multi__popup{right: auto}.wHelp .tooltip_text, .wHelp-multi .tooltip_text{left:100%;right:auto; margin-left: 10px;}";
}

if ( $enable_tablet_positioning ) {
	$custom_css .= '@media only screen and (min-width:576px) and (max-width:991px) {';
	if ( 'right_bottom' === $bubble_position_tablet  ) {
		$custom_css .= ".wHelp, .wHelp-multi { bottom: {$right_bottom_value_bottom_tablet}{$right_bottom_unit_tablet}; right: {$right_bottom_value_right_tablet}{$right_bottom_unit_tablet}; left: auto; }.wHelp.wHelp-show, .wHelp-multi.wHelp-show{bottom: {$right_bottom_value_bottom_mobile}{$right_bottom_unit_mobile}}.wHelp__popup, .wHelp-multi__popup{right:0;}.wHelp .tooltip_text, .wHelp-multi .tooltip_text{right:100%;left:auto; margin-right: 10px;}";
	}
	if ( 'left_bottom' === $bubble_position_tablet ) {
		$custom_css .= ".wHelp, .wHelp-multi {left: {$left_bottom_value_left_tablet}{$left_bottom_unit_tablet}; } .wHelp, .wHelp-multi { bottom: {$left_bottom_value_bottom_tablet}{$left_bottom_unit_tablet};}.wHelp.wHelp-show, .wHelp-multi.wHelp-show{bottom: {$right_bottom_value_bottom_mobile}{$right_bottom_unit_mobile}}.wHelp__popup, .wHelp-multi__popup{left: 0;}.wHelp .tooltip_text, .wHelp-multi .tooltip_text{left:100%}";
	}
	if ( 'right_middle' === $bubble_position_tablet ) {
		$custom_css .= ".wHelp, .wHelp-multi {top: auto;bottom: 50%;left: auto;right: {$right_middle_value_right_tablet}{$right_middle_unit_tablet};}.wHelp.wHelp-show, .wHelp-multi.wHelp-show {bottom: 20%;}.wHelp__popup, .wHelp-multi__popup{right: 0;}.wHelp .tooltip_text, .wHelp-multi .tooltip_text{right:100%;left:auto; margin-right: 10px;}";
	}
	if ( 'left_middle' === $bubble_position_tablet  ) {
		$custom_css .= ".wHelp, .wHelp-multi {top: auto; bottom: 50%; left: {$left_middle_value_left_tablet}{$left_middle_unit_tablet}; right: auto;} .wHelp.wHelp-show, .wHelp-multi.wHelp-show {bottom: 20%;}.wHelp__popup, .wHelp-multi__popup{right: auto;}.wHelp .tooltip_text, .wHelp-multi .tooltip_text{left:100%;right:auto; margin-left: 10px;}";
	}
	$custom_css .= '}';
}

if ( $enable_mobile_positioning ) {
	$custom_css .= '@media only screen and (max-width:576px) {';
	if ( 'right_bottom' === $bubble_position_mobile ) {
		$custom_css .= ".wHelp, .wHelp-multi {bottom: {$right_bottom_value_bottom_mobile}{$right_bottom_unit_mobile}; right: {$right_bottom_value_right_mobile}{$right_bottom_unit_mobile}; left: auto;}.wHelp.wHelp-show, .wHelp-multi.wHelp-show{bottom: {$right_bottom_value_bottom_mobile}{$right_bottom_unit_mobile}}.wHelp__popup, .wHelp-multi__popup{right:0; left:auto}.wHelp .tooltip_text, .wHelp-multi .tooltip_text{right:100%;left:auto; margin-right: 10px;};";
	}
	if ( 'left_bottom' === $bubble_position_mobile  ) {
		$custom_css .= ".wHelp, .wHelp-multi {left: {$left_bottom_value_left_mobile}{$left_bottom_unit_mobile};} .wHelp, .wHelp-multi {bottom: {$left_bottom_value_bottom_mobile}{$left_bottom_unit_mobile};}.wHelp.wHelp-show, .wHelp-multi.wHelp-show{bottom: {$left_bottom_value_bottom_mobile}{$left_bottom_unit_mobile}}.wHelp__popup, .wHelp-multi__popup{right:auto}.wHelp .tooltip_text, .wHelp-multi .tooltip_text{left:100%;right:auto; margin-left: 10px;}";
	}
	if ( 'right_middle' === $bubble_position_mobile ) {
		$custom_css .= ".wHelp, .wHelp-multi {top: auto; bottom: 50%; left: auto; right: {$right_middle_value_right_mobile}{$right_middle_unit_mobile}; } .wHelp.wHelp-show, .wHelp-multi.wHelp-show { bottom: 20%;}.wHelp__popup, .wHelp-multi__popup{ right: 0;}.wHelp .tooltip_text, .wHelp-multi .tooltip_text{right:100%;left:auto; margin-right: 10px;}";
	}
	if ( 'left_middle' === $bubble_position_mobile ) {
		$custom_css .= ".wHelp, .wHelp-multi {top: auto; bottom: 50%; left: {$left_middle_value_left_mobile}{$left_middle_unit_mobile}; right: auto;}.wHelp.wHelp-show, .wHelp-multi.wHelp-show {bottom: 20%;}.wHelp__popup, .wHelp-multi__popup{right: auto;}.wHelp .tooltip_text, .wHelp-multi .tooltip_text{left:100%;right:auto; margin-left: 10px;}";
	}
	$custom_css .= '}';
}

if ( $bubble_button_tooltip_width ) {
	$custom_css .= ".wHelp .tooltip_text, .wHelp-multi .tooltip_text {width: {$bubble_button_tooltip_width}px;}";
}

if(!('1' == $bubble_button_style)) {
	$custom_css .= ".wHelp .wHelp-bubble.bubble, .wHelp-multi .wHelp-bubble.bubble{padding-top:{$bubble_button_padding_top}{$bubble_button_padding_unit};padding-right:{$bubble_button_padding_right}{$bubble_button_padding_unit};padding-bottom:{$bubble_button_padding_bottom}{$bubble_button_padding_unit};padding-left:{$bubble_button_padding_left}{$bubble_button_padding_unit}";
	}