<?php
include 'class-wp-food-postype.php';
include 'shortcode-builder.php';
if ( exfood_get_option('exfood_booking') !='woo' && exfood_get_option('exfood_booking') !='disable' ) {
	include 'class-wp-order-postype.php';
}
add_action( 'admin_enqueue_scripts', 'exfood_admin_scripts' );
function exfood_admin_scripts(){
	$js_params = array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) );
	wp_localize_script( 'jquery', 'exfood_ajax', $js_params  );
	wp_enqueue_style('ex-admin_style', EXFOOD_PATH . 'admin/css/style.css','','1.0');
	wp_enqueue_script('ex-admin-js', EXFOOD_PATH . 'admin/js/admin.js', array( 'jquery' ),'1.0' );
}

add_filter( 'manage_ex_food_posts_columns', 'exfood_edit_columns',99 );
function exfood_edit_columns( $columns ) {
	global $wpdb;
	unset($columns['date']);
	$columns['exfood_id'] = esc_html__( 'ID' , 'wp-food' );
	$columns['date'] = esc_html__( 'Publish date' , 'wp-food' );		
	return $columns;
}
add_action( 'manage_ex_food_posts_custom_column', 'ex_food_custom_columns',12);
function ex_food_custom_columns( $column ) {
	global $post;
	switch ( $column ) {
		case 'exfood_id':
			$exfood_id = $post->ID;
			echo '<span class="exfood_id">'.wp_kses_post($exfood_id).'</span>';
			break;
	}
}


add_filter( 'manage_exfood_scbd_posts_columns', 'exfood_edit_scbd_columns',99 );
function exfood_edit_scbd_columns( $columns ) {
	global $wpdb;
	unset($columns['date']);
	$columns['layout'] = esc_html__( 'Type' , 'wp-food' );
	$columns['shortcode'] = esc_html__( 'Shortcode' , 'wp-food' );
	$columns['date'] = esc_html__( 'Publish date' , 'wp-food' );		
	return $columns;
}
add_action( 'manage_exfood_scbd_posts_custom_column', 'exfood_scbd_custom_columns',12);
function exfood_scbd_custom_columns( $column ) {
	global $post;
	switch ( $column ) {
		case 'layout':
			$sc_type = get_post_meta($post->ID, 'sc_type', true);
			$exfood_id = $post->ID;
			echo '<span class="layout">'.wp_kses_post($sc_type).'</span>';
			break;
		case 'shortcode':
			$_shortcode = get_post_meta($post->ID, '_shortcode', true);
			echo '<input type="text" readonly name="_shortcode" value="'.esc_attr($_shortcode).'">';
			break;	
	}
}

add_action( 'wp_ajax_exfood_change_sort_mb', 'exfood_change_sort' );
function exfood_change_sort(){
	$post_id = $_POST['post_id'];
	$value = $_POST['value'];
	if(isset($post_id) && $post_id != 0)
	{
		update_post_meta($post_id, 'exfood_order', esc_attr(str_replace(' ', '', $value)));
	}
	die;
}
function exfood_id_taxonomy_columns( $columns ){
	$columns['cat_id'] = esc_html__('ID','wp-food');

	return $columns;
}
add_filter('manage_edit-exfood_cat_columns' , 'exfood_id_taxonomy_columns');
function exfood_taxonomy_columns_content( $content, $column_name, $term_id ){
    if ( 'cat_id' == $column_name ) {
        $content = $term_id;
    }
	return $content;
}
add_filter( 'manage_exfood_cat_custom_column', 'exfood_taxonomy_columns_content', 10, 3 );

// order item table
function exfood_table_prder_item(){
	$screen_cr = get_current_screen();
	$edit = '';
	// global $pagenow;
	// echo $pagenow;
	$add_new_order = true;
	if(!empty($screen_cr) && $screen_cr->post_type == 'exfood_order' && $screen_cr->action != 'add'){
		$edit = ' exwpfd-order-edit';
		$add_new_order = false;
	}
	echo '<div class="exwpfd-order-items'.$edit.'">';
		echo exfood_table_order_item_html($add_new_order);
	echo '</div>';
}
// add new order metadata html
function exfood_add_order_item_meta_html($key){
	$id = 'exwpfd-order-'.rand(10,9999);
	$output = '
	<div class="exfood-add-order-item-meta">
	<span id="'.esc_attr($id).'" class="button add-order-meta" data-pl="'.esc_html__('Name | Price','wp-food').'">'.esc_html__('+ Add meta','wp-food').'</span>
	<span class="button button-primary save-order-meta" data-update="'.esc_attr($key).'">'.esc_html__('Save','wp-food').'</span>
	</div>
	';
	ob_start();
	$js_string = ob_get_contents();
	ob_end_clean();
	return $output.$js_string;
}
// get subtotal
function exfood_subtotal($id){
	$post_id = $id!='' ? $id :  get_the_ID() ;
	$userfood = get_post_meta( $post_id, 'exorder_food', true);
	if(!is_array($userfood) || empty($userfood)){
		return;
	}
	$total_price = 0;
	foreach ($userfood as $key => $value) {
	  	if (!isset($value['food_id'])) {
	  		continue;
	  	}
	    $food_id = $value['food_id'];
	    $price_food = get_post_meta( $food_id, 'exfood_price', true );
	    $saleprice = get_post_meta( $food_id, 'exfood_sale_price', true );
	    $price_food = $saleprice!='' && is_numeric($saleprice) ? $saleprice : $price_food;
	    $price_food = is_numeric($price_food) ? $price_food : 0;
		foreach ($value as $key_it => $item_meta) {
		  if(is_array($item_meta)){
		    foreach ($item_meta as $val) {
				$val = explode("|",$val);
				$price = isset ($val[2]) ? $val[2] : '';
				$price = exfood_cv_price($price);
				$price_food = $price!='' && is_numeric($price) ? $price_food + $price*1 : $price_food;
		    }
		  }
		}
		$price_food = $price_food * $value['food_qty'];
		$total_price = $total_price + $price_food;	
	}
	return $total_price;
}
function exfood_table_order_item_html($add_new_order){
	$post_id = isset($_POST['post_id']) && $_POST['post_id']!='' ? $_POST['post_id'] : get_the_ID() ;
	$userfood = get_post_meta( $post_id, 'exorder_food', true);
	if(!is_array($userfood) || empty($userfood)){
		return;
	}
	$html = '
	<table>
	  <tr class="exfood-cart-header">
	    <td class="exfood-cart-image"></td>
	    <td class="exfood-cart-details">'.esc_html__( 'Details', 'wp-food' ).'</td>
	    <td class="exfood-cart-quatity exfood-quantity">'.esc_html__( 'Quantity', 'wp-food' ).'</td>
	    <td class="exfood-cart-price">'.esc_html__( 'Total', 'wp-food' ).'</td>
	    <td class="exfood-cart-close"></td>';
	    $html .= '
	  </tr>';
	  $total_price = 0;
	  foreach ($userfood as $key => $value) {
	  	if (!isset($value['food_id'])) {
	  		continue;
	  	}
	    $food_id = $value['food_id'];
	    $price_food = get_post_meta( $food_id, 'exfood_price', true );
	    $saleprice = get_post_meta( $food_id, 'exfood_sale_price', true );
	    $price_food = $saleprice!='' && is_numeric($saleprice) ? $saleprice : $price_food;
	    $price_food = is_numeric($price_food) ? $price_food : 0;
	    $customlink = get_edit_post_link($food_id);
	    $html .= '
	    <tr>
			<td class="exfood-cart-image">
			<a class="exfood-title" href="'.esc_url($customlink).'">
			  <img src="'.get_the_post_thumbnail_url($food_id,'exfood_80x80').'"/>
			</a>
			</td>
			<td class="exfood-cart-details">
			<a class="exfood-title" href="'.esc_url($customlink).'">'.get_the_title($food_id).'</a>';
			foreach ($value as $key_it => $item_meta) {
			  if(is_array($item_meta)){
			    $html .= '<span class="exfood-addon">';
			    foreach ($item_meta as $val) {
			      $val = explode("|",$val);
			      $price = isset ($val[2]) ? $val[2] : '';
			      $price = exfood_cv_price($price);
			      $price_food = $price!='' && is_numeric($price) ? $price_food + $price*1 : $price_food;
			      if($price!=''){
			        $html .= '<p>'.wp_kses_post($val[1]) .' + '.exfood_price_with_currency($price).'</p>';
			      }else{
			        $html .= '<p>'.wp_kses_post($val[1]) .'</p>';
			      }
			    }
			    $html .= '</span>';
			  }
			}
			$price_food = $price_food * $value['food_qty'];
			$total_price = $total_price + $price_food;
			$html .= exfood_add_order_item_meta_html($key);
			$html .= '
			</td>
			<td class="exfood-cart-quatity exfood-quantity">';
				if(isset($checkout) && $checkout ==1){
				  $html .= '<span>'.wp_kses_post($value['food_qty']).'</span>';
				}else{
				  $html .= '
				  <input type="number" min="1" name="food_qty" class="food_qty" value="'.esc_attr($value['food_qty']).'" data-update="'.esc_attr($key).'">
				  ';
				}
			$html .= '
			</td>
			<td class="exfood-cart-price">'.exfood_price_with_currency($price_food).'</td>
			<td class="exfood-cart-close">
			    <a class="exfood-close" href="javascript:;" data-remove="'.esc_attr($key).'">×</a>
			</td>';
	      $html .= '
	    </tr>';
	  }
	$html .= '</table>';
	$html .= '
	<p class="exfood-total exfood-sub-total"><strong>'.esc_html__('Subtotal:','wp-food').'</strong>
	  <span>'.exfood_price_with_currency($total_price).'</span>
	</p>';
	$c_data = 0;
	foreach ($userfood as $key_i => $item_dta) {
		if(is_array($item_dta)){
			$c_data = 1;
			break;
		}
	}
	if($c_data == 0){
		$userfood = array();
		update_post_meta($post_id, 'exorder_food', $userfood);
	}
	$tax = $tax_rate = $shipping_fee = $final_total = 0;

	$tax_rate = isset($userfood['tax_rate']) ? $userfood['tax_rate'] : exfood_get_option('exfood_tax_rate','exfood_advanced_options');
	$shipping_fee = isset($userfood['shipping_fee']) ? $userfood['shipping_fee'] : exfood_get_option('exfood_shipping_fee','exfood_advanced_options');
	if (isset($userfood['final_total'])) { $final_total = $userfood['final_total'];	}
	if ($add_new_order) {
		$tax_rate = exfood_get_option('exfood_tax_rate','exfood_advanced_options');
		$final_total = $total_price;
		$shipping_fee_check = $tax_check = false;
		if(is_numeric($tax_rate)){
			$tax_check = true;
			$tax = ($total_price * $tax_rate)/100;
			$final_total = $tax + $final_total;
			$html .= '
			<p class="exfood-total exfood-tax"><strong>'.esc_html__('Tax:','wp-food').'</strong>
			  <span>'.exfood_price_with_currency($tax).'</span>
			</p>';
		}
		$shipping_fee = exfood_get_option('exfood_shipping_fee','exfood_advanced_options');
		$shipping_free = exfood_get_option('exfood_shipping_free','exfood_advanced_options');
		if(is_numeric($shipping_fee) && $shipping_fee > 0){
			$shipping_fee_check = true;
			if($shipping_free!='' && $final_total >= $shipping_free){
				$sp_cost = esc_html__( 'Free', 'wp-food' );
			}else{
				$final_total = $shipping_fee + $final_total;
				$sp_cost = exfood_price_with_currency($shipping_fee);
			}
			$html .= '
			<p class="exfood-total exfood-shipping-fee"><strong>'.esc_html__('Shipping fee:','wp-food').'</strong>
			  <span>'.$sp_cost.'</span>
			</p>';

		}
		if ($shipping_fee_check || $tax_check) {
			// if (!isset($userfood['final_total'])) {
				$userfood['final_total'] = $final_total;
				update_post_meta($post_id, 'exorder_food', $userfood);
			// }
			$html .= '
			<p class="exfood-total exfood-final-total"><strong>'.esc_html__('Total:','wp-food').'</strong>
			  <span>'.exfood_price_with_currency($final_total).'</span>
			</p>';
		}
	}else{
		if (is_numeric($tax_rate) || $shipping_fee > 0) {
			if(is_numeric($tax_rate)){
				$tax = ($total_price * $tax_rate)/100;
				$final_total = $tax + $total_price;
				$html .= '
				<p class="exfood-total exfood-tax"><strong>'.esc_html__('Tax:','wp-food').'</strong>
				  <span>'.exfood_price_with_currency($tax).'</span>
				</p>';
			}
			$shipping_free = exfood_get_option('exfood_shipping_free','exfood_advanced_options');
			if($shipping_fee > 0){
				$fn = $total_price;
				if($shipping_free!='' && ( $fn >= $shipping_free) ){
					$final_total = $total_price + $tax;
					$sp_cost = esc_html__( 'Free', 'wp-food' );
				}else{
					$final_total = $shipping_fee + $total_price + $tax;
					$sp_cost = exfood_price_with_currency($shipping_fee);
				}
				$html .= '
				<p class="exfood-total exfood-shipping-fee"><strong>'.esc_html__('Shipping fee:','wp-food').'</strong>
				  <span>'.$sp_cost.'</span>
				</p>';

			}
			$html .= '
			<p class="exfood-total exfood-final-total"><strong>'.esc_html__('Total:','wp-food').'</strong>
			  <span>'.exfood_price_with_currency($final_total).'</span>
			</p>';
		}
	}
	
	
	$html = apply_filters( 'exfood_admin_table_html', $html,$total_price );
	return $html;
}
function exfood_print_html(){
	global $userfood, $billing, $id;
	$id = isset($_POST['post_id']) && $_POST['post_id']!='' ? $_POST['post_id'] : get_the_ID() ;
	$userfood = get_post_meta( $id, 'exorder_food', true);
	$billing= array();
	$billing['_type'] = get_post_meta( $id, 'exorder_type', true );
	$billing['_date'] = get_post_meta( $id, 'exorder_date', true );
	$billing['_time'] = get_post_meta( $id, 'exorder_time', true );
	$billing['_phone'] = get_post_meta( $id, 'exorder_phone', true );
	$billing['_email'] = get_post_meta( $id, 'exorder_email', true );
	$billing['_location'] = get_post_meta( $id, 'exorder_location', true );
	$billing['_fname'] = get_post_meta( $id, 'exorder_fname', true );
	$billing['_lname'] = get_post_meta( $id, 'exorder_lname', true );
	$billing['_store'] = get_post_meta( $id, 'exorder_store', true );
	$billing['_address'] = get_post_meta( $id, 'exorder_address', true );
	$billing['_note'] = get_post_meta( $id, 'exorder_note', true );
	$billing['_method'] = get_post_meta( $id, 'exorder_method', true );
    exfood_template_plugin('print',false);	
}
add_action( 'wp_ajax_exfood_admin_add_order_item', 'exfood_admin_add_order_item' );
function exfood_admin_add_order_item(){
	$post_id = $_POST['post_id'];
	$food_id = $_POST['food_id'];
	$add_new = $_POST['add_new'];
	if($food_id > 0 && $post_id > 0){
		$userfood = get_post_meta( $post_id, 'exorder_food', true);
		$add_new_order = true;
		if ($add_new == 'no') {
			$add_new_order = false;
		}
		if (!is_array($userfood)) {
			$userfood = array();
			if ($add_new_order) {
				$tax_rate = exfood_get_option('exfood_tax_rate','exfood_advanced_options');
				if(is_numeric($tax_rate)){
					$tax = ($total_price * $tax_rate)/100;
					$userfood['tax_rate'] = $tax_rate;
				}else{$userfood['tax_rate'] = 0 ;}
				$shipping_fee = exfood_get_option('exfood_shipping_fee','exfood_advanced_options');
				if(is_numeric($shipping_fee) && $shipping_fee > 0){
					$shipping_fee_check = true;
					$userfood['shipping_fee'] = $shipping_fee;
				}else{$userfood['shipping_fee'] = 0 ;}
			}
		}
		$userfood[] = array(
			'food_id' => $food_id,
			'food_qty' => 1,
		);
		update_post_meta($post_id, 'exorder_food', $userfood);
		
		echo exfood_table_order_item_html($add_new_order);
	}
	die;
}

add_action( 'wp_ajax_adm_exfood_remove_cart_item', 'adm_exfood_remove_cart_item' );
function adm_exfood_remove_cart_item(){
	$key = $_POST['it_remove'];
	$post_id = $_POST['post_id'];
	$add_new = $_POST['add_new'];
	$tax = $tax_rate = $shipping_fee = $final_total = $sp_cost = 0;
	if(is_numeric($key)){
		$add_new_order = true;
		if ($add_new == 'no') {
			$add_new_order = false;
		}
		$userfood = get_post_meta( $post_id, 'exorder_food', true);
		unset($userfood[$key]);

		$tax_rate = isset($userfood['tax_rate']) ? $userfood['tax_rate'] : exfood_get_option('exfood_tax_rate','exfood_advanced_options');
		$shipping_fee = isset($userfood['shipping_fee']) ? $userfood['shipping_fee'] : exfood_get_option('exfood_shipping_fee','exfood_advanced_options');
		if (isset($userfood['final_total'])) { $final_total = $userfood['final_total'];	}
		$total_price_non_cr = exfood_update_total_price($userfood,1);
		$shipping_free = exfood_get_option('exfood_shipping_free','exfood_advanced_options');

		if (is_numeric($tax_rate) || $shipping_fee > 0) {
			if(is_numeric($tax_rate)){
				$tax = ($total_price_non_cr * $tax_rate)/100;
				$final_total = $tax + $total_price_non_cr;
			}
			if($shipping_fee > 0){
				$fn = $total_price_non_cr;
				if($shipping_free!='' && ($fn >= $shipping_free) ){
					$final_total = $fn + $tax;
					$sp_cost = esc_html__( 'Free', 'wp-food' );
				}else{
					$final_total = $shipping_fee + $total_price_non_cr + $tax;
					$sp_cost = exfood_price_with_currency($shipping_fee);
				}
			}
			$userfood['final_total'] = $final_total;
		}
		update_post_meta($post_id, 'exorder_food', $userfood);
		$avari = 1;
	}else{
		$avari = 0;
	}
	$total_price = exfood_update_total_price($userfood);
	$output =  array('status'=>$avari,'update_total'=> $total_price,'tax'=> exfood_price_with_currency($tax), 'shipping_fee'=> $sp_cost, 'final_total'=> exfood_price_with_currency($final_total));
	echo str_replace('\/', '/', json_encode($output));
	exit;	
}

add_action( 'wp_ajax_adm_exfood_update_cart_item', 'adm_exfood_update_cart_item' );
add_action( 'wp_ajax_nopriv_adm_exfood_update_cart_item', 'adm_exfood_update_cart_item' );

function adm_exfood_update_cart_item(){
	$key = $_POST['it_update'];
	$qty = $_POST['qty'];
	$post_id = $_POST['post_id'];
	$tax = $tax_rate = $shipping_fee = $final_total = $sp_cost = 0;
	$userfood = get_post_meta( $post_id, 'exorder_food', true);
	if(is_numeric($key) && isset($userfood[$key])){
		$userfood[$key]['food_qty'] = $qty;
		$tax_rate = isset($userfood['tax_rate']) ? $userfood['tax_rate'] : exfood_get_option('exfood_tax_rate','exfood_advanced_options');
		$shipping_fee = isset($userfood['shipping_fee']) ? $userfood['shipping_fee'] : exfood_get_option('exfood_shipping_fee','exfood_advanced_options');
		if (isset($userfood['final_total'])) { $final_total = $userfood['final_total'];	}
		$total_price_non_cr = exfood_update_total_price($userfood,1);
		$shipping_free = exfood_get_option('exfood_shipping_free','exfood_advanced_options');

		if (is_numeric($tax_rate) || $shipping_fee > 0) {
			if(is_numeric($tax_rate)){
				$tax = ($total_price_non_cr * $tax_rate)/100;
				$final_total = $tax + $total_price_non_cr;
			}
			if($shipping_fee > 0){
				$fn = $total_price_non_cr;
				if($shipping_free!='' && ($fn >= $shipping_free) ){
					$final_total = $fn + $tax;
					$sp_cost = esc_html__( 'Free', 'wp-food' );
				}else{
					$final_total = $shipping_fee + $total_price_non_cr + $tax;
					$sp_cost = exfood_price_with_currency($shipping_fee);
				}
			}
			$userfood['final_total'] = $final_total;
		}
		update_post_meta($post_id, 'exorder_food', $userfood);
		$avari = 1;
	}else{
		$avari = 0;
		$number_item = count($userfood);
		$output =  array('status'=>$avari,'info_text'=> esc_html__("This item does not exist in cart","wp-food"),'number_item'=>$number_item);
		echo str_replace('\/', '/', json_encode($output));
		exit;
	}
	$total_price = exfood_update_total_price($userfood);
	$food_id = $userfood[$key]['food_id'];
	$price_food = get_post_meta( $food_id, 'exfood_price', true );
	$saleprice = get_post_meta( $food_id, 'exfood_sale_price', true );
	$price_food = $saleprice!='' && is_numeric($saleprice) ? $saleprice : $price_food;
	$price_food = is_numeric($price_food) ? $price_food : 0;
	foreach ($userfood[$key] as $key_it => $item_meta) {
		if(is_array($item_meta)){
			foreach ($item_meta as $val) {
				$val = explode("|",$val);
				$price = isset ($val[2]) ? $val[2] : 0;
				$price = exfood_cv_price($price);
				$price_food = $price_food + $price*1;
			}
		}
	}
	$total_price = $price_food * $userfood[$key]['food_qty'];
	$total_cart = exfood_update_total_price($userfood);
	$output =  array('status'=>$avari,'update_price'=> exfood_price_with_currency($total_price),'update_total'=> $total_cart,'tax'=> exfood_price_with_currency($tax), 'shipping_fee'=> $sp_cost, 'final_total'=> exfood_price_with_currency($final_total));
	echo str_replace('\/', '/', json_encode($output));
	exit;	
}


add_action( 'wp_ajax_adm_exfood_add_order_meta', 'adm_exfood_add_order_meta' );
function adm_exfood_add_order_meta(){
	$key = $_POST['it_update'];
	$post_id = $_POST['post_id'];
	$metas = $_POST['metas'];
	$tax = $tax_rate = $shipping_fee = $final_total = 0;
	if(empty($metas)){
		echo 0; exit;
	}
	if(is_numeric($key)){
		$userfood = get_post_meta( $post_id, 'exorder_food', true);
		$html ='';
		foreach ($metas as $value) {
			$val = '|'.$value;
			$userfood[$key]['ex_extrafood_adm'][] = $val;
			$val = explode("|",$val);
			$price = isset ($val[2]) ? $val[2] : '';
			$price = exfood_cv_price($price);
			if($price!=''){
				$html .= '<p>'.$val[1] .': '.exfood_price_with_currency($price).'</p>';
			}else{
				$html .= '<p>'.$val[1] .'</p>';
			}
		}
		$tax_rate = isset($userfood['tax_rate']) ? $userfood['tax_rate'] : exfood_get_option('exfood_tax_rate','exfood_advanced_options');
		$shipping_fee = isset($userfood['shipping_fee']) ? $userfood['shipping_fee'] : exfood_get_option('exfood_shipping_fee','exfood_advanced_options');
		if (isset($userfood['final_total'])) { $final_total = $userfood['final_total'];	}
		$total_price_non_cr = exfood_update_total_price($userfood,1);

		if (is_numeric($tax_rate) || $shipping_fee > 0) {
			if(is_numeric($tax_rate)){
				$tax = ($total_price_non_cr * $tax_rate)/100;
				$final_total = $tax + $total_price_non_cr;
			}
			if($shipping_fee > 0){
				$fn = $total_price_non_cr;
				if($shipping_free!='' && ($fn >= $shipping_free) ){
					$final_total = $fn + $tax;
					$sp_cost = esc_html__( 'Free', 'wp-food' );
				}else{
					$final_total = $shipping_fee + $total_price_non_cr + $tax;
					$sp_cost = exfood_price_with_currency($shipping_fee);
				}
			}
			//$userfood['shipping_fee'] = $sp_cost;
			$userfood['final_total'] = $final_total;
		}
		update_post_meta($post_id, 'exorder_food', $userfood);
		$avari = 1;
	}else{
		$avari = 0;
	}
	$total_price = exfood_update_total_price($userfood);
	$food_id = $userfood[$key]['food_id'];
	$price_food = get_post_meta( $food_id, 'exfood_price', true );
	$saleprice = get_post_meta( $food_id, 'exfood_sale_price', true );
	$price_food = $saleprice!='' && is_numeric($saleprice) ? $saleprice : $price_food;
	$price_food = is_numeric($price_food) ? $price_food : 0;
	foreach ($userfood[$key] as $key_it => $item_meta) {
		if(is_array($item_meta)){
			foreach ($item_meta as $val) {
				$val = explode("|",$val);
				$price = isset ($val[2]) ? $val[2] : 0;
				$price = exfood_cv_price($price);
				$price_food = $price_food + $price*1;
			}
		}
	}
	$total_item = $price_food * $userfood[$key]['food_qty'];
	$output =  array('status'=>$avari,'update_total'=> $total_price, 'update_price'=> exfood_price_with_currency($total_item), 'html_add'=> '<span class="exfood-addon">'.$html.'</div>','tax'=> exfood_price_with_currency($tax), 'shipping_fee'=> exfood_price_with_currency($shipping_fee), 'final_total'=> exfood_price_with_currency($final_total));
	echo str_replace('\/', '/', json_encode($output));
	exit;	
}

add_action( 'wp_ajax_exfood_admin_show_store', 'exfood_admin_show_store' );
function exfood_admin_show_store(){
	$store_id = $_POST['store_id'];
	if(!is_numeric($store_id)){
		return;
	}
	$store_name = '';
	$store_name = get_the_title( $store_id );
	$output =  array('store_name'=>$store_name);
	echo str_replace('\/', '/', json_encode($output));
	exit;	
}

add_action('wp_ajax_exwpfd_change_sort_menu', 'wp_ajax_exwpfd_change_sort_menu' );
function wp_ajax_exwpfd_change_sort_menu(){
	$post_id = $_POST['post_id'];
	$value = $_POST['value'];
	if ($value == '') {
		$value = 0;
	}
	if(isset($post_id) && $post_id != 0)
	{
		update_term_meta($post_id, 'exfood_menu_order', esc_attr($value));
	}
	die;
}
// Search by id order
add_action( 'pre_get_posts','exwpf_admin_search_include_ids' );
function exwpf_admin_search_include_ids( $query ) {
    // Bail if we are not in the admin area
    if ( ! is_admin() ) {
        return;
    }
    // Bail if this is not the search query.
    if ( ! $query->is_main_query() && ! $query->is_search() || !in_array ( $query->get('post_type'), array('exfood_order') )  ) {
        return;
    }
    // Get the value that is being searched.
    $search_string = get_query_var( 's' );
    // Bail if the search string is not an integer.
    if ( ! filter_var( $search_string, FILTER_VALIDATE_INT ) ) {
        return;
    }
    // Set WP Query's p value to the searched post ID.
    $query->set( 'p', intval( $search_string ) );
    // Reset the search value to prevent standard search from being used.
    $query->set( 's', '' );
}

// upgrade data of time delivery from 1.1.2 to 1.2
add_action( 'init', 'exwpf_update_option' );
if(!function_exists('exwpf_update_option')){
	function exwpf_update_option() {
		if (get_option('_exf_udoption')!='updated' && is_user_logged_in() && current_user_can( 'manage_options' ) && function_exists('exfood_get_option')){
			$_timesl = exfood_get_option('exfood_ck_times','exfood_advanced_options');
			if(is_array($_timesl) && !empty($_timesl)){
				$_newtsl= array();
				foreach ($_timesl as $value) {
					$_newtsl[] = array(
						'name-ts'=> $value
					);
				}
				if(!empty($_newtsl)){
					$all_options = get_option( 'exfood_advanced_options' );
					$all_options['exfood_ck_times'] = '';
					$all_options['exfood_deli_time'] = $_newtsl;
					update_option( 'exfood_advanced_options', $all_options );
				}
			}	
			update_option( '_exf_udoption', 'updated' );
		}
	}
}

// Add custom user meta field
if(!function_exists('exf_user_profile_fields')){
	add_action('show_user_profile', 'exf_user_profile_fields');
	add_action('edit_user_profile', 'exf_user_profile_fields');
	// @param WP_User $user
	function exf_user_profile_fields( $user ) {?>
		<h3><?php esc_html_e('Customer billing address','wp-food'); ?></h3>
	    <table class="form-table">
	        <tr>
	            <th>
	                <label for="exorder_fname"><?php esc_html_e('First name','wp-food'); ?></label>
	            </th>
	            <td>
	                <input type="text" name="exorder_fname" id="exorder_fname" value="<?php echo esc_attr( get_the_author_meta( 'exorder_fname', $user->ID ) ); ?>" class="regular-text" />
	            </td>
	        </tr>
	        <tr>
	            <th>
	                <label for="exorder_lname"><?php esc_html_e('Last name','wp-food'); ?></label>
	            </th>
	            <td>
	                <input type="text" name="exorder_lname" id="exorder_lname" value="<?php echo esc_attr( get_the_author_meta( 'exorder_lname', $user->ID ) ); ?>" class="regular-text" />
	            </td>
	        </tr>

	        <tr>
	            <th>
	                <label for="exorder_phone"><?php esc_html_e('Mobile','wp-food'); ?></label>
	            </th>
	            <td>
	                <input type="text" name="exorder_phone" id="exorder_phone" value="<?php echo esc_attr( get_the_author_meta( 'exorder_phone', $user->ID ) ); ?>" class="regular-text" />
	            </td>
	        </tr>
	        <tr>
	            <th>
	                <label for="exorder_email"><?php esc_html_e('Email','wp-food'); ?></label>
	            </th>
	            <td>
	                <input type="text" name="exorder_email" id="exorder_email" value="<?php echo esc_attr( get_the_author_meta( 'exorder_email', $user->ID ) ); ?>" class="regular-text" />
	            </td>
	        </tr>
	        <tr>
	            <th>
	                <label for="exorder_address"><?php esc_html_e('Address','wp-food'); ?></label>
	            </th>
	            <td>
	                <input type="text" name="exorder_address" id="exorder_address" value="<?php echo esc_attr( get_the_author_meta( 'exorder_address', $user->ID ) ); ?>" class="regular-text" />
	            </td>
	        </tr>
	        
	    </table>
	<?php
	}
	// Hook is used to save custom fields that have been added to the WordPress profile page (if current user) 
	add_action( 'personal_options_update', 'exf_update_extra_profile_fields' );
	// Hook is used to save custom fields that have been added to the WordPress profile page (if not current user) 
	add_action( 'edit_user_profile_update', 'exf_update_extra_profile_fields' );
	function exf_update_extra_profile_fields( $user_id ) {
	    if ( current_user_can( 'edit_user', $user_id ) ){
	        update_user_meta( $user_id, 'exorder_fname', $_POST['exorder_fname'] );
	        update_user_meta( $user_id, 'exorder_lname', $_POST['exorder_lname'] );
	        update_user_meta( $user_id, 'exorder_phone', $_POST['exorder_phone'] );
	        update_user_meta( $user_id, 'exorder_email', $_POST['exorder_email'] );
	        update_user_meta( $user_id, 'exorder_address', $_POST['exorder_address'] );
	    }
	}
}